<?php
namespace Elementor;

class Azin_Woo_Products_Block extends Widget_Base {

	public function get_name() {
		return 'azin-woo-products-block';
	}
	
	public function get_title() {
		return __( 'WooCommerce Product Block', 'azin-file' );
	}
	
	public function get_icon() {
		return 'fal fa-shopping-cart';
	}
	
	public function get_categories() {
		return [ 'azin-file' ];
	}
	
	protected function register_controls() {

		require get_template_directory() . '/includes/el-widgets/fa.php';

		$prod_cat = array();

		$categories = get_terms( array(
			'taxonomy'   => 'product_cat',
			'hide_empty' => false,
		) );
		
		if ( ! empty( $categories ) && !is_wp_error( $categories ) ) {
		foreach ( $categories as $category ) {
		$prod_cat[ $category->term_id ] = $category->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'WooCommerce Product Block', 'azin-file' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Products', 'azin-file' ),
				'placeholder' => __( 'Enter the title', 'azin-file' ),
			]
		);

		$this->add_control(
			'prod_sort',
			[
				'label' => __( 'Sort products', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => __( 'Latest Products', 'azin-file' ),
					'latest-updated'  => __( 'Latest updated products', 'azin-file' ),
					'random' => __( 'Random products', 'azin-file' ),
					'viewed' => __( 'Popular products', 'azin-file' ),
					'saled' => __( 'Best-selling products', 'azin-file' ),
					'discounted' => __( 'Discounted products', 'azin-file' ),
					'special' => __( 'Special products', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'prod_filter',
			[
				'label' => __( 'Product filtering', 'azin-file' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Products category', 'azin-file' ),
					'tag' => __( 'Products tag', 'azin-file' ),
				],
			]
		);

		$this->add_control(
			'prod_cat',
			[
				'label' => __( 'Product categories', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $prod_cat,
				'condition' => [
					'prod_filter' => 'category',
				]
			]
		);

		$this->add_control(
			'prod_tag',
			[
				'label' => __( 'Product tag', 'azin-file' ),
				'description' => __( 'If you have defined the product filter on the tag, enter the desired tags in this box (separate the IDs with a "," sign, for example 145,12,6)', 'azin-file' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Tag(s) ID', 'azin-file' ),
				'condition'   => [
					'prod_filter' => 'tag',
				]
			]
		);

		$this->add_control(
			'prod_cat_exclude',
			[
				'label'       => __( 'Exclude Product categories', 'azin-file' ),
				'description' => __( 'Selected categories will not be displayed', 'azin-file' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'options'     => $prod_cat,
			]
		);

		$this->add_control(
			'out_prod',
			[
				'label' => __( 'Show in stock products', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'prod_icon',
			[
				'label' => __( 'Icon', 'azin-file' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'shopping-cart'
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'azin-file' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Automatic movement', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'prod_loop',
			[
				'label' => __( 'Duplicate products', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Number of products', 'azin-file' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 50,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Number of product columns', 'azin-file' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 3,
				'max' => 7,
				'step' => 1,
				'default' => 4,
			]
		);

		$this->add_control(
			'view_all',
			[
				'label' => __( 'Display view all button (If category or tag selected)', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'view_all_link',
			[
				'label'         => __( 'View all button custom link', 'azin-file' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'azin-file' ),
				'show_external' => true,
				'default'       => [
						'url'         => '',
						'is_external' => true,
						'nofollow'    => false,
				],
				'condition' => [
					'view_all' => 'yes',
				],
			]
        );

		$this->add_control(
			'link_title',
			[
				'label' => __( 'Linking the title of the block (If category or tag selected)', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'hide_no_prod',
			[
				'label' => __( 'Hide the block if there is no product', 'azin-file' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'azin-file' ),
				'label_off' => __( 'Off', 'azin-file' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
        
        $settings    	  = $this->get_settings_for_display();
        $prod_filter 	  = $settings['prod_filter'];
		$prod_cat 		  = $settings['prod_cat'];
		$prod_cat_exclude = $settings['prod_cat_exclude'];
        $prod_tag 	  	  = ( ! empty ( $settings['prod_tag'] && $settings['prod_tag'] != ' ' ) ? explode ( ",", $settings['prod_tag'] ) : '' );
		$prod_sort 	 	  = $settings['prod_sort'];
		$view_all_link    = '';

		if ( $prod_sort != 'special' ) {
			
			switch ( $prod_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'latest-updated':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby' => 'modified',
					'ignore_sticky_posts' => '1',
					'order' => 'DESC'  );
					break;
				case 'saled':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'total_sales',
					'orderby' => 'meta_value_num',
					'order' => 'DESC'  );
					break;
				case 'discounted':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_query' => array(
					array(
						'key' => '_sale_price',
						'value'   => array( '' ),
						'compare' => 'NOT IN'
					)
					),
					'order' => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
					'orderby' => 'meta_value_num',
					'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
			}

			if ( $prod_cat && $prod_filter == 'category' ) {
				$args['tax_query'] = array(
					array(
					'taxonomy' => 'product_cat',
					'field' => 'term_id',
					'terms' => $prod_cat
					)
				);
				$view_all_link = azin_get_term_links( 'product_cat', $prod_cat );
			} elseif ( ! empty ( $prod_tag ) && $prod_filter == 'tag' ) {
				$args['tax_query'] = array(
					array(
					'taxonomy' => 'product_tag',
					'field' => 'term_id',
					'terms' => $prod_tag
					)
				);
				$view_all_link = azin_get_term_links( 'product_tag', $prod_tag );
			}
		} elseif ( $prod_sort == 'special' ) {
			$args = array(
				'posts_per_page' => $settings['ptotalcount'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'meta_query' => array(
				array(
					'key' => 'file_special',
					'compare' => '=',
					'value' => 1,
					'type' => 'numeric'
				),
				),
				'order' => 'DESC'  );
		}

		if ( ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) || ( 'yes' === $settings['out_prod'] ) ) {
			$args['meta_query'] = array(
						'relation' => 'AND',
						array(
							'key' => '_stock_status',
							'value' => 'instock'
						)
					);
		}

		if ( ! empty( $prod_cat_exclude ) ) {
			$args['tax_query'] = array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'product_cat',
							'field' => 'term_id',
							'terms' => $prod_cat_exclude,
							'operator' => 'NOT IN'
						)
					);
		}

		if ( 'yes' === $settings['view_all'] ) {
			if ( ! empty ( $settings['view_all_link']['url'] ) ) {
				$all_link = $settings['view_all_link']['url'];
			} elseif ( ! empty ( $view_all_link ) ) {
				$all_link = $view_all_link;
			} else {
				$all_link = "";
			}
		}

		$block_args = array(
			'block_title'      => $settings['title'],
			'block_title_link' => 'yes' === $settings['link_title'] && $all_link != '' ? $all_link : '',
			'block_view_all'   => $settings['view_all'] = 'yes' ? true : false,
			'block_view_link'  => $all_link,
			'block_icon'       => 'fal fa-'. $settings['prod_icon'],
			'block_icon_img'   => ! empty ( $settings['custom_icon']['url'] ) ? $settings['custom_icon']['url'] : '',
			'block_itemscount' => $settings['pcount'],
			'block_itemplay'   => 'yes' === $settings['auto_play'] ? true : false,
			'block_itemloop'   => 'yes' === $settings['prod_loop'] ? true : false,
			'block_query'      => $args,
			'block_hide'	   => 'yes' === $settings['hide_no_prod'] ? true : false,
			'block_post_type'  => 'product'
		);
	  
		azin_carousel_block( $block_args );

	}

}