<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

class My_Elementor_Widgets {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		
		//Include WooCommerce & EDD Widgets
        if ( az_woo() ) {
            require_once( 'el-widgets/woo-products.php' );
        } else {
            require_once( 'el-widgets/edd-products.php' );
		}
		if ( az_woo() ) {
			require_once( 'el-widgets/woo-products-block.php' );
		} else {
			require_once( 'el-widgets/edd-products-block.php' );
		}

		require_once('el-widgets/category-grid.php');

		//Include Site Widgets
		require_once( 'el-widgets/services.php' );
		require_once( 'el-widgets/posts.php' );
		require_once( 'el-widgets/posts-block.php' );
		require_once( 'el-widgets/special-offer.php' );
		require_once( 'el-widgets/ads-image.php' );
		require_once( 'el-widgets/slider.php' );
		require_once( 'el-widgets/text-box.php' );
		require_once( 'el-widgets/search-box.php' );
		require_once( 'el-widgets/azin-site-info.php' );
		require_once( 'el-widgets/azin-ticker.php' );

		//Include Header Widgets
		if ( azin_active_elpro() ) {

			require_once('el-widgets/header-widgets/azin-header-logo.php');
			require_once('el-widgets/header-widgets/azin-search-bar.php');
			require_once('el-widgets/header-widgets/azin-user-btns.php');
			require_once('el-widgets/header-widgets/azin-mobile-user-btns.php');
			require_once('el-widgets/header-widgets/azin-mobile-menu-btn.php');
			require_once('el-widgets/header-widgets/azin-shopping-cart.php');

			if ( class_exists( 'YITH_WCWL' ) || class_exists( 'EDD_Wish_Lists' ) )
				require_once('el-widgets/header-widgets/azin-whishlist-btn.php');
		}

		add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {

		if ( az_woo() ) {
			\Elementor\Plugin::instance()->widgets_manager->register(new \Elementor\Azin_Woo_Products() );
		} else {
			\Elementor\Plugin::instance()->widgets_manager->register(new \Elementor\Azin_Edd_Products() );
		}

		if ( az_woo() ) {
			\Elementor\Plugin::instance()->widgets_manager->register(new \Elementor\Azin_Woo_Products_Block() );
		} else {
			\Elementor\Plugin::instance()->widgets_manager->register(new \Elementor\Azin_Edd_Products_Block() );
		}

		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Category_Grid() );
		
		//Call Site Widgets
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Blog_Posts() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Blog_Posts_Block() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Our_Service_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Special_Offer() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Ads_Image() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Text_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Search_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Site_Info() );
		\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Text_Ticker() );

		//Call Header Widgets
		if ( azin_active_elpro() ) {
			
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Header_Logo() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Search_Bar() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_User_Buttons() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Mobile_User_Buttons() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Mobile_Menu_Btn() );
			\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Shopping_Cart() );

			if ( class_exists( 'YITH_WCWL' ) || class_exists( 'EDD_Wish_Lists' ) )
				\Elementor\Plugin::instance()->widgets_manager->register( new \Elementor\Azin_Wishlist_Btn() );
		}
	}

}

add_action( 'init', 'my_elementor_init' );
function my_elementor_init() {
	My_Elementor_Widgets::get_instance();
}

function add_elementor_widget_categories( $elements_manager ) {

	$elements_manager->add_category(
		'azin-file',
		[
			'title' => __( 'AzinFile', 'azin-file' ),
			'icon' => 'fal fa-plug',
		]
	);

	if ( azin_active_elpro() ) {
		$elements_manager->add_category(
			'azin-file-header',
			[
				'title' => __( 'Azinfile header widgets', 'azin-file' ),
				'icon' => 'fa fa-plug',
			]
		);
	}
}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );

//For Google Fonts:
add_filter( 'elementor/frontend/print_google_fonts', '__return_false' );

//For Font Awesome:
add_action( 'elementor/frontend/after_register_styles',function() {
	foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
	}
}, 20 );

//Register Elementor Location's
add_action( 'elementor/theme/register_locations', 'azin_register_elementor_locations' );
function azin_register_elementor_locations( $elementor_theme_manager ) {

	$elementor_theme_manager->register_location( 'header' );
	$elementor_theme_manager->register_location( 'footer' );
	// $elementor_theme_manager->register_location( 'single' );
	// $elementor_theme_manager->register_location( 'archive' );

}

//Register elementor preview mode script
add_action( 'elementor/preview/enqueue_scripts', 'azin_elementor_script' );
function azin_elementor_script() {
    wp_enqueue_script('azin-js-elementor', AZ_URI . '/js/elementor.js', array('jquery' ), AZ_VER, true);
}

//Disable elementor use mini cart template
function azin_disable_elementor_use_mini_cart_template(){
	update_option( 'elementor_use_mini_cart_template', 'no' );
}
add_action( 'init', 'azin_disable_elementor_use_mini_cart_template' );