<?php
add_shortcode( 'azin_edd_dashboard_content', 'azin_edd_dashboard_content' );

function azin_edd_dashboard_content() {
     
    ob_start();
    $customer = new EDD_Customer( get_current_user_id(), true );
    ?>
    
    <ul class="azin-dashboard-stats row">
        <li class="col-lg-3 col-md-6 col-12">
            <div class="azin-dashboard-stat-con azin-dashboard-green shadow-box">
                <i class="fal fa-shopping-cart"></i>
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count">
                        <?php echo edd_currency_filter( edd_format_amount( $customer->purchase_value ) ); ?>
                    </span>
                    <span class="azin-dashboard-stats-title">
                        <?php _e( 'Total Orders', 'azin-file' ); ?>
                    </span>
                </span>
            </div>
        </li>

        <li class="col-lg-3 col-md-6 col-12">
            <div class="azin-dashboard-stat-con azin-dashboard-yellow shadow-box">
                <i class="fal fa-box-check"></i>
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count">
                        <?php echo $customer->purchase_count; ?>
                    </span>
                    <span class="azin-dashboard-stats-title">
                        <?php _e( 'Completed orders', 'azin-file' ); ?>
                    </span>
                </span>
            </div>
        </li>

        <?php if ( class_exists( 'EDD_Wallet' ) ) { ?>
        <li class="col-lg-3 col-md-6 col-12">
            <div class="azin-dashboard-stat-con azin-dashboard-blue shadow-box">
                <i class="fal fa-wallet"></i>
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count">
                        <?php
                        $wallet = edd_currency_filter(edd_wallet()->wallet->balance( get_current_user_id() ) );
                        echo $wallet; ?>
                    </span>
                    <span class="azin-dashboard-stats-title">
                        <?php _e( 'Wallet Inventory', 'azin-file' ); ?>
                    </span>
                </span>
            </div>
        </li>
        <?php } ?>

        <li class="col-lg-3 col-md-6 col-12">
            <div class="azin-dashboard-stat-con azin-dashboard-red shadow-box">
                <i class="fal fa-user-plus"></i>
                <span class="col azin-stats-con d-flex">
                    <span class="azin-dashboard-stats-count">
                        <?php echo azin_register_date( get_current_user_id() ); ?>
                    </span>
                    <span class="azin-dashboard-stats-title">
                        <?php _e( 'Registration date', 'azin-file' ); ?>
                    </span>
                </span>
            </div>
        </li>

    </ul>
    
    <?php if ( azin_opt( 'show_dashboard_message' ) ) { ?>
        <div class="row azin-dashbord-message">
            <div class="col-12">
                
                <?php if ( ! empty( azin_opt( 'dashboard_message_one' ) ) ) { ?>
                    <div class="woocommerce-message" role="alert">
                        <?php echo do_shortcode( azin_opt( 'dashboard_message_one' ) ) ?>
                    </div>
                <?php } ?>

                <?php if ( ! empty( azin_opt( 'dashboard_message_two' ) ) ) { ?>
                    <div class="woocommerce-info" role="alert">
                        <?php echo do_shortcode( azin_opt( 'dashboard_message_two' ) ) ?>
                    </div>
                <?php } ?>

                <?php if ( ! empty( azin_opt( 'dashboard_message_three' ) ) ) { ?>
                    <div class="woocommerce-error" role="alert">
                        <?php echo do_shortcode( azin_opt( 'dashboard_message_three' ) ) ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    <?php } ?>

    <?php $menu_items = azin_edd_build_menu(); ?>
    <ul class="azin-dashbord-items row">
        <?php
        foreach ( $menu_items as $item => $value ) {
            
        if( ! empty( $value['link'] ) ) { ?>
            <li class="col-sm-3 col-6 customer-dashboard-menu-item <?php echo $value[ 'task' ]; ?>">
            <?php $link = ( $value['dashboard_link'] == true ? $value['link'] : get_home_url() . '/' . $value['link'] ); ?>
                <a href="<?php echo $link; ?>" class="shadow-box">
                    <?php echo $value[ 'name' ]; ?>
                </a>
            </li>
        <?php
        } else {
        ?>
            <li class="col-sm-3 col-6 customer-dashboard-menu-item <?php echo $value[ 'task' ]; ?>">
                <a href="<?php echo get_home_url().'/dashboard/?task='. $value['task']; ?>" class="shadow-box">
                    <?php echo $value[ 'name' ]; ?>
                </a>
            </li>
        <?php } ?>
        <?php
        }
        ?>
        <li class="col-sm-3 col-6 customer-dashboard-menu-item logout">
            <a href="<?php echo wp_logout_url( home_url() ); ?>" class="shadow-box">
                <?php _e( 'Logout', 'azin-file'); ?>
            </a>
        </li>
    </ul>
<?php
    $content = ob_get_clean();
    return $content;
}


function azin_edd_build_menu() {
    
    $menu = array();

    $user_id = get_current_user_id();
    if( class_exists( 'EDD_Front_End_Submissions' ) && !EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $menu[ 'fes_become_vendor' ] = array(
            'task'=> 'fes_become_vendor',
            'name' => __( 'Become a Vendor', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'EDD_Front_End_Submissions' ) && EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $menu[ 'fes_become_vendor' ] = array(
            'task'=> 'fes_become_vendor',
            'name' => __( 'Vendor Dashboard', 'azin-file' ),
            "link" => 'vendor-dashboard',
            "dashboard_link" => false,
        );
    }
    
    $menu[ 'profile' ] = array(
        'task' => 'profile',
        'name' => __( 'Edit profile', 'azin-file' ),
        "link" => '',
        "dashboard_link" => false,
    );

    // Azin dashboard link one
    if ( azin_opt( 'dashboard_link_one' ) ) {
        $menu['azin_dashboard_link_one'] = array(
        "icon" => azin_opt( 'dashboard_link_one_icon' ),
        "task" => 'dashboard-link-one',
        "name" => azin_opt( 'dashboard_link_one_title' ),
        "link" => azin_opt( 'dashboard_link_one_url' ),
        "dashboard_link" => true,
        );
    }

    // Azin dashboard link two
    if ( azin_opt( 'dashboard_link_two' ) ) {
        $menu['azin_dashboard_link_two'] = array(
        "icon" => azin_opt( 'dashboard_link_two_icon' ),
        "task" => 'dashboard-link-two',
        "name" => azin_opt( 'dashboard_link_two_title' ),
        "link" => azin_opt( 'dashboard_link_two_url' ),
        "dashboard_link" => true,
        );
    }

    // Azin dashboard link three
    if ( azin_opt( 'dashboard_link_three' ) ) {
        $menu['azin_dashboard_link_three'] = array(
        "icon" => azin_opt( 'dashboard_link_three_icon' ),
        "task" => 'dashboard-link-three',
        "name" => azin_opt( 'dashboard_link_three_title' ),
        "link" => azin_opt( 'dashboard_link_three_url' ),
        "dashboard_link" => true,
        );
    }

    $menu[ 'purchases' ] = array(
        'task' => 'purchases',
        'name' => __( 'Purchase History', 'azin-file' ),
        "link" => '',
        "dashboard_link" => false,
    );

    $menu[ 'downloads' ] = array(
        'task' => 'download',
        'name' => __( 'Downloads', 'azin-file' ),
        "link" => '',
        "dashboard_link" => false,
    );
    
    if( class_exists( 'EDD_Points_Renderer' ) ) {
    $menu[ 'points' ] = array(
    "task" => 'points',
    "name" => __( 'Points', 'azin-file' ),
    "link" => '',
    "dashboard_link" => false,
    );
    }

    if( class_exists( 'EDD_Software_Licensing' ) ) {
    $menu[ 'license' ] = array(
    "task" => 'license',
    "name" => __( 'Licenses', 'azin-file' ),
    "link" => '',
    "dashboard_link" => false,
    );
    }
    
    // Support for EDD Wallet
    if( class_exists( 'EDD_Wallet' ) ) {
        $menu[ 'wallet' ] = array(
            'task'=> 'wallet',
            'name' => __( 'Wallet', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }

    // Support for EDD All Access
    if( class_exists( 'EDD_All_Access' ) ) {
        $menu[ 'edd-all-access' ] = array(
            'task'=> 'subscriptions',
            'name' => __( 'Subscriptions', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'EDD_Wish_Lists' ) ) {
        $menu[ 'wishlists' ] = array(
            'task'=> 'wishlist',
            'name' => __( 'Wishlist', 'azin-file' ),
            "link" => azin_edd_whishlist_url(),
            "dashboard_link" => true,
        );
    }
    
    if( class_exists( 'Awesome_Support' ) ) {
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if(is_array($ticket_submit_id)){
            $ticket_submit = $ticket_submit_id[0];
        }
        else {
            $ticket_submit = $ticket_submit_id;
        }
        $tpost = get_post((int)$ticket_submit); 
        $tslug = $tpost->post_name;
        $menu[ 'submit-ticket' ] = array(
            'task'=> 'send-ticket',
            'name' => __( 'Submit ticket', 'azin-file' ),
            "link" => $tslug,
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'Awesome_Support' ) ) {
        $lpost = get_post((int)wpas_get_option( 'ticket_list' )); 
        $lslug = $lpost->post_name;
        $menu[ 'tickets' ] = array(
            'task'=> 'tickets',
            'name' => __( 'Tickets', 'azin-file' ),
            "link" => $lslug,
            "dashboard_link" => false,
        );
    }

    $user_id = get_current_user_id();
    if( class_exists( 'EDD_Front_End_Submissions' ) && !EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $menu[ 'fes_become_vendor' ] = array(
            'task'=> 'fes_become_vendor',
            'name' => __( 'Become a Vendor', 'azin-file' ),
            "link" => '',
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'EDD_Front_End_Submissions' ) && EDD_FES()->vendors->user_is_vendor( $user_id ) ) {
        $menu[ 'fes_become_vendor' ] = array(
            'task'=> 'fes_become_vendor',
            'name' => __( 'Vendor Dashboard', 'azin-file' ),
            "link" => 'vendor-dashboard',
            "dashboard_link" => false,
        );
    }
    
    if( class_exists( 'Affiliate_WP' ) ) {
        $apost = get_post(affwp_get_affiliate_area_page_id()); 
        $aslug = $apost->post_name;
        $menu[ 'affiliate' ] = array(
            'task'=> 'affiliate',
            'name' => __( 'Affiliate', 'azin-file' ),
            "link" => $aslug,
            "dashboard_link" => false,
        );
    }
    
    return $menu;

}