<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

if ( class_exists( 'EDD_Front_End_Submissions' ) ) {
  function az_fes_dashboard_menus() {
    
    $menu_items = array();
    
      // Dashboard tab
    $menu_items['home'] = array(
      "icon" => "tachometer-alt",
      "task" => array( 'dashboard', '' ),
      "name" => __( 'Dashboard', 'azin-file' ),
    );
    
    // "Products" tab
    $menu_items['my_products'] = array(
      "icon" => "briefcase",
      "task" => array( 'products' ),
      "name" => __( 'Products', 'azin-file' ),
    );
    
    // Add "Product" tab
    if ( EDD_FES()->vendors->vendor_can_create_product() ) {
      $menu_items['new_product'] = array(
        "icon" => "plus-circle",
        "task" => array( 'new-product' ),
        "name" => __( 'New Product', 'azin-file' ),
      );
    }

    // Azin dashboard link one
    if ( azin_opt( 'dashboard_link_one' ) ) {
      $menu_items['azin_dashboard_link_one'] = array(
        "icon" => azin_opt( 'dashboard_link_one_icon' ),
        "task" => 'dashboard-link-one',
        "name" => azin_opt( 'dashboard_link_one_title' ),
        "link" => azin_opt( 'dashboard_link_one_url' ),
        "dashboard_link" => true,
      );
    }

    // Azin dashboard link two
    if ( azin_opt( 'dashboard_link_two' ) ) {
      $menu_items['azin_dashboard_link_two'] = array(
        "icon" => azin_opt( 'dashboard_link_two_icon' ),
        "task" => 'dashboard-link-two',
        "name" => azin_opt( 'dashboard_link_two_title' ),
        "link" => azin_opt( 'dashboard_link_two_url' ),
        "dashboard_link" => true,
      );
    }

    // Azin dashboard link three
    if ( azin_opt( 'dashboard_link_three' ) ) {
      $menu_items['azin_dashboard_link_three'] = array(
        "icon" => azin_opt( 'dashboard_link_three_icon' ),
        "task" => 'dashboard-link-three',
        "name" => azin_opt( 'dashboard_link_three_title' ),
        "link" => azin_opt( 'dashboard_link_three_url' ),
        "dashboard_link" => true,
      );
    }

    if ( azin_opt( 'course_user_panel' ) ) {
      // Download tab :: Purchased items for download
      $menu_items[ 'courses' ] = array(
        "task" => array( 'courses' ),
        "icon" => "graduation-cap",
        "name" => __( 'Courses', 'azin-file')
      );
    }

    if ( azin_opt( 'course_user_panel' ) && ! azin_opt( 'remove_downloads' ) ) {
      // Download tab :: Purchased items for download
      $menu_items[ 'downloads' ] = array(
        "task" => array( 'download' ),
        "icon" => "download",
        "name" => __( 'Downloads', 'azin-file')
      );
    }
    
    // Earnings tab
    if ( EDD_FES()->integrations->is_commissions_active() ) {
      $menu_items['earnings'] = array(
        "icon" => "dollar-sign",
        "task" => array( 'earnings' ),
        "name" => __( 'Income', 'azin-file' ),
      );
    }
    
    // Orders tab
    if ( EDD_FES()->vendors->vendor_can_view_orders() ) {
      $menu_items['orders'] = array(
        "icon" => "shopping-cart",
        "task" => array( 'orders' ),
        "name" => __( 'My sales', 'azin-file' ),
      );
    }
    
    //Support for EDD Wishlists
    if ( class_exists( 'EDD_Wish_Lists' ) ) {
      $menu_items[ 'wishlists' ] = array(
        "task" => array( 'wishlist' ),
        "icon" => "heart",
        "name" => __( 'Wishlist', 'azin-file' ),
        "link" => azin_edd_whishlist_url(),
        "dashboard_link" => true,
      );
    }
    
    if ( class_exists( 'EDD_Points_Renderer' ) ) {
        $menu_items[ 'points' ] = array(
        "task" => array( 'points' ),
        "icon" => "gift",
        "name" => __( 'Points', 'azin-file')
    );
    }

    if ( class_exists( 'EDD_Software_Licensing' ) ) {
        $menu_items[ 'license' ] = array(
        "task" => array( 'license' ),
        "icon" => "key",
        "name" => __( 'Licenses', 'azin-file')
    );
    }
    
    // Invoice tab
    $menu_items[ 'purchases' ] = array(
        "task" => array( 'purchases' ),
        "icon" => "list-alt",
        "name" => __( 'My purchases', 'azin-file')
    );
     
    if ( class_exists( 'EDD_Wallet' ) ) {
     $menu_items['wallet'] = array(
        "icon" => "wallet",
        "task" => array( 'wallet' ),
        "name" => __( 'Wallet', 'azin-file' ),
      );  
    }

    if ( class_exists( 'EDD_All_Access' ) ) {
      $menu_items['subscriptions'] = array(
         "icon" => "file-invoice-dollar",
         "task" => array( 'subscriptions' ),
         "name" => __( 'Subscriptions', 'azin-file' ),
       );  
    }

      if ( class_exists( 'Awesome_Support' ) ) { 
      $ticket_submit_id = wpas_get_option( 'ticket_submit' );
            if ( is_array( $ticket_submit_id) ) {
                $ticket_submit = $ticket_submit_id[0];
            }
            else {
                $ticket_submit = $ticket_submit_id;
            }
            $tpost = get_post((int)$ticket_submit); 
      $tslug = $tpost->post_name;
      $menu_items['submit-ticket'] = array(
        "icon" => "paper-plane",
        "task" => $tslug,
        "name" => __( 'Submit Ticket', 'azin-file' ),
        "link" => $tslug,
        "dashboard_link" => false,
      );
      }

      if ( class_exists( 'Awesome_Support' ) ) { 
        $lpost = get_post((int)wpas_get_option( 'ticket_list' ) ); 
        $lslug = $lpost->post_name;
        $menu_items['tickets'] = array(
          "icon" => "list",
          "task" => $lslug,
          "name" => __( 'Tickets', 'azin-file' ),
          "link" => $lslug,
          "dashboard_link" => false,
        );
      }

      if ( class_exists( 'Affiliate_WP' ) ) { 
        $apost = get_post(affwp_get_affiliate_area_page_id() ); 
        $aslug = $apost->post_name;
        $menu_items['affiliate'] = array(
          "icon" => "handshake",
          "task" => $aslug,
          "name" => __( 'Affiliate', 'azin-file' ),
          "link" => $aslug,
          "dashboard_link" => false,
        );
      }

      // Profile tab
      $menu_items['profile'] = array(
        "icon" => "pen-square",
        "task" => array( 'profile' ),
        "name" => __( 'Profile', 'azin-file' ),
      );

      $menu_items['logout'] = array(
        "icon" => "power-off",
        "task" => array( 'logout' ),
        "name" => __( 'Logout', 'azin-file' ),
      );  
      return $menu_items;
  }

add_filter( 'fes_vendor_dashboard_menu', 'az_fes_dashboard_menus', 10, 2 ); 
}   


function az_custom_task_wishlist( $custom, $task) {
  
    if ( 'wishlist' == $task ) {
      $custom = 'wishlist';
    } 
    
    if ( 'download' == $task ) {
      $custom = 'download';
    }
    
    if ( 'points' == $task ) {
      $custom = 'points';
    }

    if ( 'license' == $task ) {
      $custom = 'license';
    }
    
    if ( 'purchases' == $task ) {
      $custom = 'purchases';
    }
    if ( 'wallet' == $task ) {
      $custom = 'wallet';
    }
    if ( 'subscriptions' == $task ) {
      $custom = 'subscriptions';
    }

return $custom; 
}

add_filter( 'fes_signal_custom_task', 'az_custom_task_wishlist', 10, 2 ); 


 function az_custom_template_wishlist( $task) {
  
  if ( $_GET[ 'task' ] == 'subscriptions' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'subscriptions' );  
    return $template;
  } 

  if ( $_GET[ 'task' ] == 'wishlist' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'wishlist' );  
    return $template;
  } 

  if ( $_GET[ 'task' ] == 'courses' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'courses' );  
    return $template;
  } 
  
  if ( $_GET[ 'task' ] == 'download' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'download' );  
    return $template;
  } 
     
  if ( $_GET[ 'task' ] == 'points' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'points' );  
    return $template;
  } 

  if ( $_GET[ 'task' ] == 'license' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'license' );  
    return $template;
  } 
  
  if ( $_GET[ 'task' ] == 'purchases' ) {    
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'invoices' );  
    return $template;
  } 
    
  if ( $_GET[ 'task' ] == 'wallet' ) {   
    $template = EDD_FES()->templates->fes_get_template_part( 'frontend', 'wallet' );  
    return $template;
  }
}

add_action( 'fes_custom_task_wishlist', 'az_custom_template_wishlist', 10, 2 ); 
add_action( 'fes_custom_task_download', 'az_custom_template_wishlist', 10, 2 );
add_action( 'fes_custom_task_purchases', 'az_custom_template_wishlist', 10, 2 );
add_action( 'fes_custom_task_points', 'az_custom_template_wishlist', 10, 2 );
add_action( 'fes_custom_task_license', 'az_custom_template_wishlist', 10, 2 );
add_action( 'fes_custom_task_withdraw', 'az_custom_template_wishlist', 10, 2 );
add_action( 'fes_custom_task_wallet', 'az_custom_template_wishlist', 10, 2 );
add_action( 'fes_custom_task_subscriptions', 'az_custom_template_wishlist', 10, 2 );
?>