<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

require_once AZ_DIR . '/includes/mobile-nav-bar.php';

//Azin Footer Codes
if( !is_admin() ) {
    add_action( 'wp_footer', 'azin_footer_codes' );
}

function azin_footer_codes() {
    
    //Show Mobile Bar
    if ( azin_opt( 'show_mobile_bar' ) && ! empty( azin_opt( 'mobile_bar_btns' ) ) ) {
        $mftitle     = azin_opt( 'mobile_bar_title' );
        $title_class = azin_opt( 'mobile_bar_title' ) ? ' mobile-footer-no-title' : ''; 
        ?>
        <div class="mobile-footer<?php echo $title_class; ?>">
            <ul>
            <?php 
                $i = 0;
                foreach( azin_opt( 'mobile_bar_btns' ) as $btn ) {
                    if ( $i > 4 ) break;
                    switch ( $btn ) {
                        case 'back-top':
                            azin_nav_back_top_btn( $mftitle );
                            $i++;
                            break;
                        case 'wishlist':
                            azin_nav_wishlist_btn( $mftitle );
                            $i++;
                            break;
                        case 'home-btn':
                            azin_nav_home_btn( $mftitle );
                            $i++;
                            break;
                        /*case 'compare-btn':
                            azin_nav_compare_btn( $mftitle );
                            $i++;
                            break;*/
                        case 'cart-btn':
                            azin_nav_cart_btn( $mftitle );
                            $i++;
                            break;
                        case 'my-account':
                            azin_nav_my_account_btn( $mftitle );
                            $i++;
                            break;
                        case 'menu':
                            azin_nav_menu_btn( $mftitle );
                            $i++;
                            break;
                        case 'custom-btn-one':
                            azin_nav_custom_btn_one( $mftitle );
                            $i++;
                            break;
                        case 'custom-btn-two':
                            azin_nav_custom_btn_two( $mftitle );
                            $i++;
                            break;
                        case 'custom-btn-three':
                            azin_nav_custom_btn_three( $mftitle );
                            $i++;
                            break;
                    }
                }
            ?>
            </ul>
        </div>
    <?php } ?>

    <!-- mobile menu -->
    <div id="mSidenav" class="sidemnav">
        <div class="side-mhead">
            <a href="javascript:void(0)" class="closebtn" onclick="closemNav()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>

            <?php if ( azin_opt( 'show_mobile_logo' ) ) { ?>
            <a href="<?php echo azin_logo_link(); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" rel="home">
            <?php
                $logo_width = ( ! empty( azin_opt( 'site_logo', 'width' ) ) ) ? azin_opt( 'site_logo', 'width' ) : '140';
                $logo_height = ( ! empty( azin_opt( 'site_logo', 'height' ) ) ) ? azin_opt( 'site_logo', 'height' ) : '60';
                $srcset      = ( ! empty( azin_opt( 'site_logo_retina', 'url' ) ) ) ? ' srcset="'. azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ) .' 2x"' : '';
            ?>
                <img <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="logo" <?php } ?> src="<?php echo azin_to_https( azin_opt( 'site_logo', 'url' ) ); ?>"<?php echo $srcset ?> width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" class="mobile-menu-logo"/>
            </a>
            <?php } ?>
            
        </div>
        <?php
            $azin_remove_parent_link = ( azin_opt( 'remove_parent_link' ) ? ' azin-remove-parent-link' : '' );
        ?> 
        <nav class="azin-mobile-menu<?php echo $azin_remove_parent_link; ?>" <?php if ( azin_opt( 'site_schema' ) ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?> id="cssmenu">
        
        <?php
            if( azin_opt( 'replace_mobile_menu' ) ) {
                wp_nav_menu(array(
                    'menu'              => 'mobile_menu',
                    'theme_location'    => 'mobile_menu',
                    'container_id'      => 'cssmenu',
                    'fallback_cb'       => 'CSS_Menu_Maker_fallback',
                    'walker' => new CSS_Menu_Maker_Walker()
                ) );
            } else {
                wp_nav_menu(array(
                    'menu'              => 'primary',
                    'theme_location'    => 'primary',
                    'container_id' => 'cssmenu',
                    'fallback_cb'       => 'CSS_Menu_Maker_fallback',
                    'walker' => new CSS_Menu_Maker_Walker()
                ) );
            }
        ?>

        </nav>

        <?php if ( ! azin_opt( 'hide_side_panel_icon' ) ) { ?>
            <i class="fal fa-file-search side-icon" aria-hidden="true"></i>
        <?php } ?>

    </div>
    <div id="mCanvasNav" class="overlay3" onclick="closemNav()"></div>
    <!-- mobile menu -->

    <?php if ( is_user_logged_in() ) { ?>
        <!-- side user-menu -->
        <div id="mySidenav" class="sidenav">
            <div class="side-head">
                <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </a>
                <?php
                $user = wp_get_current_user();
                echo get_avatar( get_current_user_id(), 85, '', $user->display_name); ?>
                <span class="side-uname">
                    <?php echo $user->display_name; ?></span>
                <?php
                if ( class_exists( 'EDD_Wallet' ) ) {
                    $wallet = edd_currency_filter(edd_wallet()->wallet->balance( get_current_user_id() ) );
                    echo '<span class="m-wallet">'. __( 'Wallet balance: ', 'azin-file' ) . $wallet .'</span>';
                }
                if ( class_exists( 'WooWallet' ) ) {
                    $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                    echo '<span class="m-wallet">'. __( 'Wallet balance: ', 'azin-file' ) . $wallet .'</span>';
                }
                ?>
            </div>
            <?php if ( azin_opt( 'replace_user_menu' ) && has_nav_menu( 'user_menu' ) ) { ?>
                <?php
                    wp_nav_menu( array(
                        'menu'              => 'user_menu',
                        'theme_location'    => 'user_menu',
                        'menu_class'        => 'usmenu',
                        'depth'             => 1,
                        'container'         => '',
                        'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                        'walker'            => new Yamm_Nav_Walker()
                        )
                    );
                ?>
            <?php } else { ?>
                <ul class="usmenu">
                    <?php
                    if ( az_woo() ) {
                        require AZ_DIR .'/includes/woo/umenu.php';
                    } else {
                        require AZ_DIR .'/includes/edd/umenu.php';
                    }
                    ?>
                </ul>
            <?php } ?>

            <?php if ( ! azin_opt( 'hide_side_panel_icon' ) ) { ?>
                <i class="fal fa-id-card side-icon" aria-hidden="true"></i>
            <?php } ?>

        </div>
        <div id="myCanvasNav" class="overlay3" onclick="closeNav()"></div>
        <!-- side user-menu -->
    <?php
    }
    ?>

    <!-- side cart -->
    <?php $side_open = ( azin_opt( 'ajax_add_open_cart' ) && ! az_elementor_edit_mode() ? ' azin-open-side' : '' ); ?>
    <div id="mySideCart" class="sidecart<?php echo $side_open; ?>">
        <div class="side-head">
        <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php _e( 'Close', 'azin-file'); ?>" data-title="<?php _e( 'Close', 'azin-file'); ?>" rel="nofollow" onclick="closeCart()">
            <i class="fal fa-times" aria-hidden="true"></i>
        </a>
        <div class="side-title">
             <i class="fal fa-shopping-bag" aria-hidden="true"></i> <?php echo _e( 'Shopping Cart', 'azin-file' ); ?>
        </div>
        </div>
        <div class="widget_shopping_cart_content widget_edd_cart_widget wid-content">
            <?php
            if ( az_woo() ) {
                if ( ! azin_opt( 'remove_cart_fragments' ) )
                    wp_enqueue_script( 'wc-cart-fragments' );
                woocommerce_mini_cart();
            } else {
                echo edd_shopping_cart();
            }
            ?>
        </div>

        <?php if ( ! azin_opt( 'hide_side_panel_icon' ) ) { ?>
            <i class="fal fa-bags-shopping side-icon" aria-hidden="true"></i>
        <?php } ?>

    </div>
    <div id="myCanvasCart" class="overlay3" onclick="closeCart()"></div>
    <!-- side cart -->

    <?php if(azin_opt( 'ch_login_link' ) || !is_user_logged_in()) { ?>
    <!-- side login -->
    <div id="mySideLogin" class="sidelogin">
        <div class="side-head">
            <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php _e( 'Close', 'azin-file'); ?>" data-title="<?php _e( 'Close', 'azin-file'); ?>" rel="nofollow" onclick="closeLogin()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <div class="side-title">
                <i class="fal fa-user-circle" aria-hidden="true"></i> <?php _e( 'Login to the site', 'azin-file' ); ?>
            </div>
        </div>
        <?php if ( function_exists('digits_version') && azin_opt( 'digits_mode' )) { $digits_class = ' digits-login'; } else { $digits_class='';} ?>
        <form name="login_form" class="login_form <?php echo $digits_class; ?>" id="login_form" action="#" method="post">
            <div class="row">
                <div class="col-12">
                <div class="status"></div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon1">
                        <span class="input-group-text">
                        <i class="fal fa-user" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="username" type="text" class="form-control" id="username" placeholder="<?php _e( 'Username', 'azin-file'); ?>" required="required" />
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon2">
                        <span class="input-group-text">
                        <i class="fal fa-key" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="password" type="password" class="form-control" id="password" placeholder="<?php _e( 'Password', 'azin-file'); ?>" required="required" />
                    </div>
                </div>
                <a href="<?php echo wp_lostpassword_url(); ?>" title="<?php _e( 'Reset password', 'azin-file'); ?>" class="lost-password">
                    <?php _e( 'Reset password', 'azin-file'); ?>
                </a>
                <a href="<?php echo azin_register_link() ?>" class="pregisterlink">
                    <?php _e( 'Create an account', 'azin-file'); ?>
                </a>
                <?php if(azin_opt( 'recapcha_login' )) { ?>
                <div class="g-recaptcha" data-sitekey="<?php echo azin_opt( 'site_key' ); ?>"></div>
                <?php } ?>
                <?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
                <button class="btn btn-success plogin-btn" id="loginSubmit">
                    <i class="fal fa-user" aria-hidden="true"></i><?php _e( '  Login to the site', 'azin-file'); ?>
                </button>
                </div>
                <?php if ( azin_opt( 'show_login_notices' ) ) { ?>
                    <div class="col-12 azin-login-notices-text">
                        <?php echo do_shortcode( azin_opt( 'login_notices_text' ) ); ?>
                    </div>
                <?php } ?>
            </div>
        </form>

        <?php if ( ! azin_opt( 'hide_side_panel_icon' ) ) { ?>
            <i class="fal fa-user-circle side-icon" aria-hidden="true"></i>
        <?php } ?>

    </div>
    <div id="myCanvasLogin" class="overlay3" onclick="closeLogin()"></div>
    <!-- side login -->
    <?php } ?>
       
    <?php
    if ( azin_opt( 'show_alert_app' ) ) { ?>
        <div class="alert alert-dark alert-app alert-dismissible fade show" role="alert">
            <button type="button" class="alert-app-close close" data-dismiss="alert" aria-label="Close">
                <i class="fal fa-times" aria-hidden="true"></i>
            </button>
            <span class="alert-app-title">
                <?php echo azin_opt( 'alert_app_title' ); ?>
            </span>
            <?php if ( azin_opt( 'and_link' ) != '' ) { ?>
                <a href="<?php echo azin_opt( 'and_link' ); ?>" rel="nofollow" class="btn btn-success and-btn"><i class="fab fa-android" aria-hidden="true"></i><?php _e( ' Android', 'azin-file' ); ?></a>
                <?php } ?>
                <?php if ( azin_opt( 'ios_link' ) != '' ) { ?>
                <a href="<?php echo azin_opt( 'ios_link' ); ?>" rel="nofollow" class="btn btn-secondary ios-btn"><i class="fab fa-apple" aria-hidden="true"></i><?php _e( ' IOS', 'azin-file' ); ?></a>
            <?php } ?>
        </div>
    <?php }
       
    if ( azin_opt( 'show_return_top' ) ) { ?>
        <div id="back-top" class="hidden-sm hidden-xs hidden-mobile">
            <a href="#top"><span class="fal fa-chevron-up"></span></a>
        </div>
    <?php
    } 
       
    if ( azin_opt( 'show_cart_btn' ) && ! azin_opt( 'show_cart_btn_head' ) ) {
        if ( az_woo() ) {
            $cart_count = WC()->cart->get_cart_contents_count();
            $cart_url = wc_get_cart_url();
        } else {
            $cart_count = edd_get_cart_quantity();
            $cart_url = edd_get_checkout_uri();
        }
        ?>
        <div id="cart-btn">

            <?php if ( azin_opt( 'link_cart_page' ) ) { ?>
                <a href="<?php echo $cart_url; ?>" class="fal fa-shopping-bag shop-icon" data-toggle="tooltip" data-placement="right" title="<?php _e( 'Cart', 'azin-file' ); ?>">
                </a>
            <?php } else { ?>
                <span onclick="openCart()" class="fal fa-shopping-bag shop-icon" data-toggle="tooltip" data-placement="right" title="<?php _e( 'Cart', 'azin-file' ); ?>">
                </span>
            <?php } ?>
            
            <?php if ( azin_opt( 'show_cart_number' )) { ?>
                <span class="edd-cart-quantity">
                    <?php echo $cart_count; ?>
                </span>
            <?php } ?>

        </div>    
    <?php 
    }
    
    if ( ! empty( azin_opt( 'footer_codes' ) ) ) {
        echo azin_opt( 'footer_codes' )."\n";
    }

}

//azin_share_modal
if ( azin_opt( 'social_share' ) ) {
    add_action( 'wp_footer', 'azin_share_modal' );
}
function azin_share_modal() {
    global $post;
    
    if ( 'post' == $post->post_type || 'product' == $post->post_type || 'download' == $post->post_type ) {
    ?>
    <!-- The Share Modal -->
    <div class="modal fade" id="shareModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <!-- Share Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fal fa-share-alt" aria-hidden="true"></i>
                    <?php _e( 'Sharing on social networks', 'azin-file' ); ?>
                </h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>
            </div>
            <!-- Share Modal body -->
            <div class="modal-body">
            <ul class="social-box">
                <?php if(function_exists('affwp_is_affiliate') && affwp_is_affiliate(get_current_user_id())) {  ?>

                    <?php if ( azin_opt( 'share_facebook' ) ) { ?>
                    <li class="social-face">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Facebook', 'azin-file' ); ?>" href="http://www.facebook.com/sharer.php?u=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-facebook-f" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_google' ) ) { ?>
                    <li class="social-google">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Google+', 'azin-file' ); ?>" href="https://plus.google.com/share?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-google-plus-g" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_pinterest' ) ) { ?>
                    <li class="social-pin">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Pinterest', 'azin-file' ); ?>" href="http://pinterest.com/pin/create/link/?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-pinterest-p" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_twitter' ) ) { ?>
                    <li class="social-twi">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Twitter', 'azin-file' ); ?>" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-twitter" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_linkedin' ) ) { ?>
                    <li class="social-link">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Linkedin', 'azin-file' ); ?>" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo get_permalink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-linkedin-in" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_telegram' ) ) { ?>
                    <li class="social-tele">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Telegram', 'azin-file' ); ?>" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-telegram-plane" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_whatsapp' ) ) { ?>
                    <li class="social-wts">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Whatsapp', 'azin-file' ); ?>" href="https://wa.me/?text=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fab fa-whatsapp" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_email' ) ) { ?>
                    <li class="social-email">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Email', 'azin-file' ); ?>" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank">
                            <i class="fal fa-envelope" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                <?php } else { ?>

                    <?php if ( azin_opt( 'share_facebook' ) ) { ?>
                    <li class="social-face">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Facebook', 'azin-file' ); ?>" href="http://www.facebook.com/sharer.php?u=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fab fa-facebook-f" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_google' ) ) { ?>
                    <li class="social-google">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Google+', 'azin-file' ); ?>" href="https://plus.google.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fab fa-google-plus-g" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_pinterest' ) ) { ?>
                    <li class="social-pin">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Pinterest', 'azin-file' ); ?>" href="http://pinterest.com/pin/create/link/?url=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fab fa-pinterest-p" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_twitter' ) ) { ?>
                    <li class="social-twi">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Twitter', 'azin-file' ); ?>" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fab fa-twitter" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_linkedin' ) ) { ?>
                    <li class="social-link">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Linkedin', 'azin-file' ); ?>" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo get_permalink(); ?>" target="_blank">
                            <i class="fab fa-linkedin-in" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_telegram' ) ) { ?>
                    <li class="social-tele">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Telegram', 'azin-file' ); ?>" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fab fa-telegram-plane" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_whatsapp' ) ) { ?>
                    <li class="social-wts">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Whatsapp', 'azin-file' ); ?>" href="https://wa.me/?text=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fab fa-whatsapp" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                    <?php if ( azin_opt( 'share_email' ) ) { ?>
                    <li class="social-email">
                        <a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Email', 'azin-file' ); ?>" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo wp_get_shortlink(); ?>" target="_blank">
                            <i class="fal fa-envelope" aria-hidden="true"></i>
                        </a>
                    </li>
                    <?php } ?>

                <?php } ?>
                </ul>

                <?php if ( azin_opt( 'share_copy' ) ) { ?>
                    <div class="short-con">
                        <?php if( function_exists( 'affwp_is_affiliate' ) && affwp_is_affiliate( get_current_user_id() ) ) {  ?>
                            <span class="short-text"><?php _e( 'Marketing link:', 'azin-file') ?></span>
                            <span class="short-link"><?php echo wp_get_shortlink() . '&ref=' . get_current_user_id(); ?></span>
                        <?php } else { ?>
                            <span class="short-text"><?php _e( 'Shortlink:', 'azin-file') ?></span>
                            <span class="short-link"><?php echo wp_get_shortlink(); ?></span>
                            <span data-toggle="tooltip" data-placement="top" title="<?php _e( 'Copy Link', 'azin-file' ); ?>" class="short-btn" onclick="copyToClipboard('.short-link')"><i class="fal fa-copy" aria-hidden="true"></i></span>
                        <?php } ?>
                    </div>
                    <div class="link-copy">
                        <?php _e( 'The link has been copied!', 'azin-file' ); ?>
                    </div>
                <?php } ?>

            </div>

            </div>
        </div>
    </div>
<?php }
}

//azin_sticky_add_to_cart_woo
add_action( 'wp_footer', 'azin_sticky_add_to_cart_woo' );
function azin_sticky_add_to_cart_woo() { 
    global $product;

    if( is_singular( 'product' ) ) {

        $coming = rwmb_meta( 'file_coming', '', $product->get_id() );

        $classes  = 'azin-sticky-add-cart';
        $classes .= ! azin_opt( 'show_buy_fixed_mobile' ) ? ' azin-sticky-mobile-hide' : ' azin-sticky-mobile-show';
        $classes .= ! azin_opt( 'show_buy_fixed_title' ) ? ' azin-sticky-title-hide' : ' azin-sticky-title-show';
        $classes .= ! azin_opt( 'show_buy_fixed_price' ) ? ' azin-sticky-price-hide' : ' azin-sticky-price-show';

        if( ! $coming && $product->is_in_stock() && azin_opt( 'show_buy_fixed' ) ) { ?>
            <div class="<?php echo $classes ?>">

                <div class="azin-sticky-thumb">
                    <?php if ( has_post_thumbnail()) {
                        the_post_thumbnail( 'thumbnail' );
                    } else {
                        echo '<img width="64" height="64" src="'. esc_url( get_template_directory_uri() ) .'/images/mthumb.png" alt="'. the_title_attribute( 'echo=0' ) .'" class="post-tumb"/>';
                    } ?>
                </div>

                <div class="azin-sticky-title">
                    <?php the_title(); ?>
                </div>

                <div class="azin-sticky-price">
                    <?php woocommerce_template_single_price(); ?>
                </div>

                <?php if( $product->is_type( 'simple' ) )  { ?>
                    <div class="azin-sticky-add">
                        <?php 
                        if ( azin_is_free( $product->get_id() ) && ! $product->is_type( 'variable' )  ) {

                            if ( azin_opt( 'free_logged' ) && !is_user_logged_in() ) {

                                if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                                    echo '<a href="'.azin_opt( 'free_logged_link' ).'" title="'. __( 'Login', 'azin-file' ) .'">';
                                }

                                echo '<span class="free-logged">'. azin_opt( 'text_free_logged' ).'</span>';

                                if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                                    echo '</a>';
                                }

                            } else {
                                echo do_shortcode( '[download_now id="'. $product->get_id() .'" text="'. __( 'Download', 'azin-file' ) .'"]' );
                            }

                        } else {
                            woocommerce_template_single_add_to_cart();
                        } ?>
                    </div>
                <?php } elseif ( $product->is_type( 'variable' ) ) { ?>
                    <div class="azin-sticky-add">
                        <span class="single_add_to_cart_button button alt buy-fixed">
                            <?php _e( 'Select options' , 'azin-file'); ?>
                        </span>
                    </div>
                <?php }        
                ?>

            </div>
<?php   }
    }
}

//azin_sticky_add_to_cart_edd
add_action( 'wp_footer', 'azin_sticky_add_to_cart_edd' );
function azin_sticky_add_to_cart_edd() {
    if( is_singular( 'download' ) ) {

        $coming = rwmb_meta( 'file_coming', '', get_the_ID() );

        $classes  = 'azin-sticky-add-cart';
        $classes .= ! azin_opt( 'show_buy_fixed_mobile' ) ? ' azin-sticky-mobile-hide' : ' azin-sticky-mobile-show';
        $classes .= ! azin_opt( 'show_buy_fixed_title' ) ? ' azin-sticky-title-hide' : ' azin-sticky-title-show';
        $classes .= ! azin_opt( 'show_buy_fixed_price' ) ? ' azin-sticky-price-hide' : ' azin-sticky-price-show';

        if ( ! $coming && azin_opt( 'show_buy_fixed' ) ) { ?>
            <div class="<?php echo $classes ?>">

                <div class="azin-sticky-thumb">
                    <?php if ( has_post_thumbnail()) {
                        the_post_thumbnail( 'thumbnail' );
                    } else {
                        echo '<img width="64" height="64" src="'. esc_url( get_template_directory_uri() ) .'/images/mthumb.png" alt="'. the_title_attribute( 'echo=0' ) .'" class="post-tumb"/>';
                    } ?>
                </div>

                <div class="azin-sticky-title">
                    <?php the_title(); ?>
                </div>

                <div class="azin-sticky-price">
                    <?php echo p_price( get_the_ID() ); ?>
                </div>

                <?php 
                    $download         = new EDD_Download( get_the_ID() );
                    $variable_pricing = $download->has_variable_prices();
                    $variable_product = $variable_pricing ? true : false;
                ?>

                <?php if( ! $variable_product )  { ?>
                    <div class="azin-sticky-add">
                        <?php 
                        if ( function_exists( 'edd_price' ) ) { 

                            if ( azin_is_free( get_the_ID() ) && azin_opt( 'free_logged' ) && ! is_user_logged_in() ) { 
                                
                                if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                                    echo '<a href="'.azin_opt( 'free_logged_link' ).'" title="'. __( 'Login', 'azin-file' ) .'">';
                                }
        
                                echo '<span class="free-logged">'. azin_opt( 'text_free_logged' ).'</span>';
        
                                if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                                    echo '</a>';
                                }
                                
                            } else {
                                echo edd_get_purchase_link( get_the_ID(), 'Add', 'button' ); 
                            }
        
                        }  ?>
                    </div>
                <?php } elseif ( $variable_product ) { ?>
                    <div class="azin-sticky-add">
                        <span class="single_add_to_cart_button button alt buy-fixed">
                            <?php _e( 'Select options' , 'azin-file'); ?>
                        </span>
                    </div>
                <?php }        
                ?>

            </div>
<?php   }
    }
}

//azin_site_popup
if ( azin_opt( 'enable_site_popup' ) ) {
    add_action( 'wp_footer', 'azin_site_popup' );
}
function azin_site_popup() {
    
    if ( azin_opt( 'site_popup_home' ) && ! is_front_page() )
        return;

    $modal_classes = '';

    switch ( azin_opt( 'site_popup_image_pos' ) ) {
        case 'top':
            $modal_classes .= ' modal-image-top';
            break;
        case 'right':
            $modal_classes .= ' modal-image-right';
            break;
        case 'left':
            $modal_classes .= ' modal-image-left';
            break; 
        case 'full-image':
            $modal_classes .= ' modal-image-full';
            break;

        default:
          $modal_classes .= ' modal-image-top';
    }

    $modal_classes .= azin_opt( 'show_site_popup_image' ) ? ' modal-with-image' : ' modal-not-image';

    $modal_classes .= azin_opt( 'site_popup_one_time' ) ? ' modal-one-time' : '';

    if ( azin_opt( 'site_popup_one_time' ) && azin_opt( 'site_popup_reshown' ) > 0 ) {
        $popup_reshown = azin_opt( 'site_popup_reshown' );
    } else {
        $popup_reshown = "null";
    }

    if ( azin_opt( 'site_popup_close_any' ) ) {
        $popup_close_any = 'class="modal fade popup-close-any"';
    } else {
        $popup_close_any = 'class="modal fade" data-backdrop="static"';
    }
    
    ?>
    <!-- Popup Modal -->
    <div <?php echo $popup_close_any; ?> data-keyboard="false" id="azinSitePopup" data-reshown="<?php echo $popup_reshown; ?>">
        <div class="modal-dialog <?php echo azin_opt( 'site_popup_size' ); ?> modal-dialog-centered<?php echo $modal_classes; ?>">

            <div class="modal-content ">

                <button type="button" class="close" data-dismiss="modal">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>

                <?php if ( azin_opt( 'show_site_popup_image' ) ) {
                    $image_width = ( ! empty( azin_opt( 'site_popup_image', 'width' ) ) ) ? azin_opt( 'site_popup_image', 'width' ) : '140';
                    $image_height = ( ! empty( azin_opt( 'site_popup_image', 'height' ) ) ) ? azin_opt( 'site_popup_image', 'height' ) : '60'; 
                ?>

                    <div class="modal-image col-md-5 col-12">
                        <?php if ( ! empty ( azin_opt( 'site_popup_image_link' ) ) ) { ?>
                            <a class="site-popup-image-link" href="<?php echo azin_opt( 'site_popup_image_link' ); ?>"<?php echo azin_opt( 'open_site_popup_image_link_new_tab' ) ? ' target="_blank"' : ''; ?>>
                        <?php } ?>
                        <img src="<?php echo azin_to_https( azin_opt( 'site_popup_image', 'url' ) ); ?>" width="<?php echo $image_width; ?>" height="<?php echo $image_height; ?>" alt="<?php echo azin_opt( 'site_popup_title' ); ?>" title="<?php echo azin_opt( 'site_popup_title' ); ?>" />
                        <?php if ( ! empty ( azin_opt( 'site_popup_image_link' ) ) ) { ?>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <?php if ( azin_opt( 'site_popup_image_pos' ) != 'full-image' ) { ?>
                <div class="modal-text col-md-7 col-12">
                    <?php echo do_shortcode( azin_opt( 'site_popup_content_text' ) ); ?>
                    
                    <?php if ( azin_opt( 'show_site_popup_button' ) ) { ?>
                        <a class="btn btn-lg <?php echo azin_opt( 'site_popup_button_color' ); ?> site-popup-button" href="<?php echo azin_opt( 'site_popup_button_link' ); ?>"<?php echo azin_opt( 'open_site_popup_link_new_tab' ) ? ' target="_blank"' : ''; ?>>
                            <?php echo '<span class="'. azin_opt( 'site_popup_button_icon' ) . '"></span> ' . azin_opt( 'site_popup_button_title' ); ?>
                        </a>
                    <?php } ?>
                </div>
                <?php } ?>

            </div>
        </div>
    </div>
<?php 
}

//azin_auto_update_cart
add_action( 'wp_footer', 'azin_auto_update_cart', 100 );
function azin_auto_update_cart() { 
    if ( ! class_exists('WooCommerce') || ! az_woo() ) 
        return;
    if( is_cart() ) { ?>
    <script>
    var timeout;
    jQuery( function( $ ) {
        $('.woocommerce').on('change', 'input.qty', function(){
            if ( timeout !== undefined ) {
                clearTimeout( timeout );
            }
            timeout = setTimeout(function() {
                $("[name='update_cart']").trigger("click");
            }, 1000 );
        });
        $('.woocommerce').on('click', "button.plus, button.minus", function(){
            if ( timeout !== undefined ) {
                clearTimeout( timeout );
            }
            timeout = setTimeout(function() {
                $("[name='update_cart']").trigger("click");
            }, 500 );
        });
    } );
    </script>
<?php }
}

if ( azin_opt( 'maintenance' ) && ! current_user_can('administrator') )
{
    remove_action( 'wp_footer', 'azin_footer_codes' );
    remove_action( 'wp_footer', 'azin_auto_update_cart' );
    remove_action( 'wp_footer', 'azin_sticky_add_to_cart_woo' );
    remove_action( 'wp_footer', 'azin_sticky_add_to_cart_edd' );
    //remove_action( 'wp_footer', 'azin_add_btn_modal' );
    remove_action( 'wp_footer', 'azin_site_popup' );
}