<?php
// Exit if accessed directly
if (!defined('ABSPATH' )) {
    exit;
}

//Azin Header Codes
if( ! is_admin() ) {
    add_action('wp_body_open', 'azin_header_codes' );
}

function azin_header_codes() {

    if ( azin_opt( 'site_schema' ) ) { ?>
        <span style="display:none" itemscope itemtype="https://schema.org/Organization">
            <meta itemprop="name" content="<?php bloginfo( 'name' ); ?>">
            <meta itemprop="image" content="<?php echo azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ); ?>">
            <meta itemprop="url" content="<?php echo esc_url( home_url() ); ?>">
            <meta itemprop="address" content="<?php echo azin_opt( 'addr_text' ); ?>">
        </span>
    <?php }
    
    //Show Page Loading
    azin_page_loading();

    if ( azin_opt( 'show_msg' ) ) {
        if ( azin_opt( 'user_close' ) && azin_opt( 'msg_reshown' ) > 0 ) {
            $msg_reshown = azin_opt( 'msg_reshown' );
        } else {
            $msg_reshown = "null";
        }
    ?>
        <!-- Massage Box -->
        <div class="container-fluid msg-con" id="azinHeadMsg" data-reshown="<?php echo $msg_reshown; ?>">
            <div class="container msg" role="alert">
                <div class="row">
                    <div class="col-12 col-md-10 msg-txt">
                        <span class="<?php echo azin_opt( 'msg_icon' ); ?>" aria-hidden="true"></span>
                        <?php echo do_shortcode( azin_opt( 'site_msg' ) ); ?>
                    </div>
                    <?php if ( azin_opt( 'msg_btn' ) ) { ?>
                    <div class="col-12 col-md-2">
                    <a class="msg-btn btn <?php echo azin_opt( 'msg_btn_color' ); ?>" href="<?php echo azin_opt( 'msg_btn_link' ); ?>" title="<?php echo azin_opt( 'msg_btn_text' ); ?>">
                        <?php echo azin_opt( 'msg_btn_text' ); ?>
                        <i class="fal fa-angle-left"></i>
                    </a>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <?php if ( azin_opt( 'user_close' ) ) { ?>
                    <span role="button" class="fal fa-times close" aria-label="<?php _e( 'Close', 'azin-file' ); ?>" aria-hidden="true"></span>
            <?php } ?>
        </div>
        <!-- Massage Box -->
<?php } 
}

function azin_head_contact() {
    
    if ( azin_opt( 'header_nav' ) ) { ?>

        <nav class="header-nav" <?php if ( azin_opt( 'site_schema' ) ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
            <?php
            if ( has_nav_menu( 'header' ) ) {
                wp_nav_menu(
                    array(
                        'menu'              => 'header',
                        'theme_location'    => 'header',
                        'depth'             => 1,
                        'container'         => ''
                    )
                );
            }
            ?>
        </nav>

        <?php
        } else {
            if ( azin_opt( 'show_contact' ) ) {
        ?>
            <div class="tel">

                <?php if ( azin_opt( 'site_tel' ) != '' ) { ?>
                <div class="top-tel">
                    <?php if ( azin_opt( 'site_tel_link' ) ) { ?>
                    <a href="tel:<?php echo azin_remove_dash( azin_opt( 'site_tel' ) ); ?>" target="_blank" rel="nofollow">
                    <?php } ?>
                        <span class="fal fa-phone" aria-hidden="true"></span>
                        <span class="top-val"<?php if ( azin_opt( 'site_schema' ) ) { ?> itemprop="telephone"<?php } ?>>
                            <?php echo azin_opt( 'site_tel' ); ?>
                        </span>
                    <?php if ( azin_opt( 'site_tel_link' ) ) { ?>
                    </a>
                    <?php } ?>
                </div>
                <?php } ?>

                <?php if ( azin_opt( 'site_email' ) != '' ) { ?>
                <div class="top-tel">
                    <?php if ( azin_opt( 'site_email_link' ) ) { ?>
                    <a href="mailto:<?php echo azin_opt( 'site_email' ); ?>" target="_blank" rel="nofollow">
                    <?php } ?>
                        <span class="fal fa-envelope" aria-hidden="true"></span>
                        <span class="top-val">
                            <?php echo azin_opt( 'site_email' ); ?>
                        </span>
                    <?php if ( azin_opt( 'site_email_link' ) ) { ?>
                    </a>
                    <?php } ?>
                </div>
                <?php } ?>

            </div>
        <?php } else { ?>
            <span class="date">
                <?php echo '<span>' . azin_opt( 'text_date' ) . '</span>' . ' '; ?>
                <?php azin_date(); ?>
            </span>
    <?php }
    }
}

function azin_social_links( $class, $schema, $tooltip ) {
    $social_nofollow = azin_opt( 'nofollow_social_link' ) ? ' rel="nofollow"' : '';
    $link_schema     = $schema && azin_opt( 'site_schema' ) ? 'itemprop="sameAs" ' : '';
    $ul_class        = ! empty ( $class ) ? ' class="'. $class .'"' : '';
    $tooltip_text    = $tooltip ? 'data-toggle="tooltip" data-placement="top" ' : '';
?>
    <ul<?php echo $ul_class; ?>>
        <?php if( azin_opt( 'so_twitter' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Twitter', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_twitter_link' ); ?>" aria-label="<?php _e( 'Twitter', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-twitter"></i>
            </a>
        </li>
        <?php } ?>
        <?php if( azin_opt( 'so_facebook' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Facebook', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_facebook_link' ); ?>" aria-label="<?php _e( 'Facebook', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-facebook-f"></i>
            </a>
        </li>
        <?php } ?>
        <?php if( azin_opt( 'so_google' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Google+', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_google_link' ); ?>" aria-label="<?php _e( 'Google+', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-google-plus-g"></i>
            </a>
        </li>
        <?php } ?>
        <?php if( azin_opt( 'so_whatsapp' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Whatsapp', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_whatsapp_link' ); ?>" aria-label="<?php _e( 'Whatsapp', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-whatsapp"></i>
            </a>
        </li>
        <?php } ?>
        <?php if( azin_opt( 'so_threads' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Threads', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_threads_link' ); ?>" aria-label="<?php _e( 'Threads', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-threads"></i>
            </a>
        </li>
        <?php } ?>
        <?php if( azin_opt( 'so_tiktok' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Tiktok', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_tiktok_link' ); ?>" aria-label="<?php _e( 'Tiktok', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-tiktok"></i>
            </a>
        </li>
        <?php } ?>
        <?php if( azin_opt( 'so_telegram' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Telegram', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_telegram_link' ); ?>" aria-label="<?php _e( 'Telegram', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-telegram-plane"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_instagram' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Instagram', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_instagram_link' ); ?>" aria-label="<?php _e( 'Instagram', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-instagram"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( azin_opt( 'so_soundcloud' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Soundcloud', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_soundcloud_link' ); ?>" aria-label="<?php _e( 'Soundcloud', 'azin-file' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-soundcloud"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( azin_opt( 'so_spotify' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Spotify', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_spotify_link' ); ?>" aria-label="<?php _e( 'Spotify', 'azin-file' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-spotify"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( azin_opt( 'so_google_podcasts' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Google podcasts', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_google_podcasts_link' ); ?>" aria-label="<?php _e( 'Google podcasts', 'azin-file' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-google-podcasts"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( azin_opt( 'so_castbox' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Castbox', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_castbox_link' ); ?>" aria-label="<?php _e( 'Castbox', 'azin-file' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-castbox"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( azin_opt( 'so_linktree' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Linktree', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_linktree_link' ); ?>" aria-label="<?php _e( 'Linktree', 'azin-file' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-linktr"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_youtube' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Youtube', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_youtube_link' ); ?>" aria-label="<?php _e( 'Youtube', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-youtube"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_linkedin' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Linkedin', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_linkedin_link' ); ?>" aria-label="<?php _e( 'Linkedin', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-linkedin-in"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_dribble' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Dribble', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_dribble_link' ); ?>" aria-label="<?php _e( 'Dribble', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-dribbble"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_behance' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Behance', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_behance_link' ); ?>" aria-label="<?php _e( 'Behance', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-behance"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_pinterest' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Pinterest', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_pinterest_link' ); ?>" aria-label="<?php _e( 'Pinterest', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-pinterest-p"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_aparat' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Aparat', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_aparat_link' ); ?>" aria-label="<?php _e( 'Aparat', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-aparat"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_soroush' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Soroush', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_soroush_link' ); ?>" aria-label="<?php _e( 'Soroush', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Soroush"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_gap' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Gap', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_gap_link' ); ?>" aria-label="<?php _e( 'Gap', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Gap"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_eitaa' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Eitaa', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_eitaa_link' ); ?>" aria-label="<?php _e( 'Eitaa', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Eitaa"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_bisphone' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Bisphone', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_bisphone_link' ); ?>" aria-label="<?php _e( 'Bisphone', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Bisphone"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_bale' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Bale', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_bale_link' ); ?>" aria-label="<?php _e( 'Bale', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Bale"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_igap' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'iGap', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_igap_link' ); ?>" aria-label="<?php _e( 'iGap', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-iGap"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_rubika' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Rubika', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_rubika_link' ); ?>" aria-label="<?php _e( 'Rubika', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-rubika"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_hoorsa' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Hoorsa', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_hoorsa_link' ); ?>" aria-label="<?php _e( 'Hoorsa', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-hoorsa"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_phone' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Phone', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_phone_remove_tel' ) ? azin_opt( 'so_phone_link' ) : 'tel:'. azin_remove_dash( azin_opt( 'so_phone_link' ) ); ?>" aria-label="<?php _e( 'Phone', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fal fa-phone" aria-hidden="true"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_mobile' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Mobile', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="<?php echo azin_opt( 'so_mobile_remove_tel' ) ? azin_opt( 'so_mobile_link' ) : 'tel:'. azin_remove_dash( azin_opt( 'so_mobile_link' ) ); ?>" aria-label="<?php _e( 'Mobile', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fal fa-mobile-alt" aria-hidden="true"></i>
            </a>
        </li>
        <?php } ?>

        <?php if( azin_opt( 'so_email' ) ) { ?>
        <li <?php echo $tooltip_text ?>title="<?php _e( 'Email', 'azin-file' ); ?>">
            <a <?php echo $link_schema; ?>href="mailto:<?php echo azin_opt( 'so_email_link' ); ?>" aria-label="<?php _e( 'Email', 'azin-file' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fal fa-at" aria-hidden="true"></i>
            </a>
        </li>
        <?php } ?>

    </ul>
    <?php
}