<?php
//azin_back_top_btn
function azin_nav_back_top_btn( $mftitle ) {
    if ( ! azin_opt( 'ch_back_top_btn' ) ) { ?>
        <li class="azin-return-top">
            <span aria-hidden="true" class="fal fa-chevron-up f-icon" title="<?php _e( 'Return Top', 'azin-file'); ?>">
            </span>
            <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php _e( 'Return', 'azin-file'); ?></span>
            <?php } ?>
        </li>
    <?php } else { ?>
        <li>
            <a href="<?php echo azin_opt( 'back_top_btn_link' ); ?>" title="<?php echo azin_opt( 'back_top_btn_title' ); ?>">
                <span aria-hidden="true" class="f-icon <?php echo azin_opt( 'back_top_btn_icon' ); ?>" title="<?php echo azin_opt( 'back_top_btn_title' ); ?>">
                </span>
                <?php if ( ! $mftitle ) { ?>
                    <span class="mf-title"><?php echo azin_opt( 'back_top_btn_title' ); ?></span>
                <?php } ?>
            </a>
        </li>
    <?php } 
}

//azin_nav_home_btn
function azin_nav_home_btn( $mftitle ) {
?>
    <li>
        <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>">
            <span aria-hidden="true" class="fal fa-home f-icon" title="<?php _e( 'Home', 'azin-file'); ?>">
            </span>
            <?php if( ! $mftitle ) { ?>
                <span class="mf-title"><?php _e( 'Home', 'azin-file'); ?></span>
            <?php } ?>
        </a>
    </li>
<?php
}

//azin_nav_menu_btn
function azin_nav_menu_btn( $mftitle ) {
?>
    <li onclick="openmNav()">
        <span aria-hidden="true" class="fal fa-bars f-icon" title="<?php _e( 'Menu', 'azin-file'); ?>">
        </span>
        <?php if ( ! $mftitle ) { ?>
        <span class="mf-title"><?php _e( 'Menu', 'azin-file'); ?></span>
        <?php } ?>
    </li>
<?php
}

//azin_nav_custom_btn_one
function azin_nav_custom_btn_one( $mftitle ) {
    ?>
   <li>
       <a href="<?php echo azin_opt( 'mobile_nav_btn_one_link' ); ?>" title="<?php echo azin_opt( 'mobile_nav_btn_one_title' ); ?>">
           <span aria-hidden="true" class="f-icon <?php echo azin_opt( 'mobile_nav_btn_one_icon' ); ?>" title="<?php echo azin_opt( 'mobile_nav_btn_one_title' ); ?>">
           </span>
           <?php if ( ! $mftitle ) { ?>
               <span class="mf-title"><?php echo azin_opt( 'mobile_nav_btn_one_title' ); ?></span>
           <?php } ?>
       </a>
   </li>
   <?php
}

//azin_nav_custom_btn_two
function azin_nav_custom_btn_two( $mftitle ) {
    ?>
   <li>
       <a href="<?php echo azin_opt( 'mobile_nav_btn_two_link' ); ?>" title="<?php echo azin_opt( 'mobile_nav_btn_two_title' ); ?>">
           <span aria-hidden="true" class="f-icon <?php echo azin_opt( 'mobile_nav_btn_two_icon' ); ?>" title="<?php echo azin_opt( 'mobile_nav_btn_two_title' ); ?>">
           </span>
           <?php if ( ! $mftitle ) { ?>
               <span class="mf-title"><?php echo azin_opt( 'mobile_nav_btn_two_title' ); ?></span>
           <?php } ?>
       </a>
   </li>
   <?php
}

//azin_nav_custom_btn_three
function azin_nav_custom_btn_three( $mftitle ) {
   ?>
  <li>
      <a href="<?php echo azin_opt( 'mobile_nav_btn_three_link' ); ?>" title="<?php echo azin_opt( 'mobile_nav_btn_three_title' ); ?>">
          <span aria-hidden="true" class="f-icon <?php echo azin_opt( 'mobile_nav_btn_three_icon' ); ?>" title="<?php echo azin_opt( 'mobile_nav_btn_three_title' ); ?>">
          </span>
          <?php if ( ! $mftitle ) { ?>
              <span class="mf-title"><?php echo azin_opt( 'mobile_nav_btn_three_title' ); ?></span>
          <?php } ?>
      </a>
  </li>
  <?php
}

//azin_nav_cart_btn
function azin_nav_cart_btn( $mftitle ) {
    if ( az_woo() ) {
        $cart_count = WC()->cart->get_cart_contents_count();
        $cart_url = wc_get_cart_url();
    } else {
        $cart_count = edd_get_cart_quantity();
        $cart_url = edd_get_checkout_uri();
    }
    ?>
        <li onclick="openCart()">
            <?php if ( azin_opt( 'link_cart_page' ) ) { ?>
                <a href="<?php echo $cart_url; ?>" class="fal fa-shopping-bag f-icon" title="<?php _e( 'Shopping Cart', 'azin-file'); ?>">
                    <span class="cart-amount">
                        <?php echo $cart_count; ?>
                    </span>
                </a>
            <?php } else { ?>
                <span aria-hidden="true" class="fal fa-shopping-bag f-icon" title="<?php _e( 'Shopping Cart', 'azin-file'); ?>">
                    <span class="cart-amount">
                        <?php echo $cart_count; ?>
                    </span>
                </span>
            <?php } ?>
            
            <?php if ( ! $mftitle ) { ?>
            <span class="mf-title"><?php _e( 'Cart', 'azin-file'); ?></span>
            <?php } ?>
        </li>
    <?php
}

//azin_nav_wishlist_btn
function azin_nav_wishlist_btn( $mftitle ) {
    
    if ( ! azin_opt( 'ch_whish_btn' ) ) { 
        if ( class_exists('WooCommerce') && class_exists('YITH_WCWL') ) {
            $wcwl_url = esc_url( YITH_WCWL()->get_wishlist_url() ); ?>
            <li>
                <a href="<?php echo $wcwl_url; ?>" title="<?php _e( 'Wishlist', 'azin-file'); ?>" rel="nofollow">
                    <span aria-hidden="true" class="fal fa-heart f-icon" title="<?php _e( 'Wishlist', 'azin-file'); ?>">
                        <span class="wish-amount">
                            <?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?>
                        </span>
                    </span>
                    <?php if ( ! $mftitle ) { ?>
                        <span class="mf-title"><?php _e( 'Wishlist', 'azin-file'); ?></span>
                    <?php } ?>
                </a>
            </li>
        <?php 
        } elseif ( class_exists('EDD_Wish_Lists') ) {
            $wish_url = azin_edd_whishlist_url(); ?>
            <li>
                <a href="<?php echo $wish_url; ?>" title="<?php _e( 'Wishlist', 'azin-file'); ?>" rel="nofollow">
                    <span aria-hidden="true" class="fal fa-heart f-icon" title="<?php _e( 'Wishlist', 'azin-file'); ?>">
                    </span>
                    <?php if ( ! $mftitle ) { ?>
                        <span class="mf-title"><?php _e( 'Wishlist', 'azin-file'); ?></span>
                    <?php } ?>
                </a>
            </li>
        <?php 
        }
        ?>
    <?php } else { ?>
        <li>
            <a href="<?php echo azin_opt( 'whish_btn_link' ); ?>" title="<?php echo azin_opt( 'whish_btn_title' ); ?>">
                <span aria-hidden="true" class="f-icon <?php echo azin_opt( 'whish_btn_icon' ); ?>" title="<?php echo azin_opt( 'whish_btn_title' ); ?>">
                </span>
                <?php if ( ! $mftitle ) { ?>
                    <span class="mf-title"><?php echo azin_opt( 'whish_btn_title' ); ?></span>
                <?php } ?>
            </a>
        </li>
    <?php }
}

//azin_nav_my_account_btn
function azin_nav_my_account_btn( $mftitle ) {
    
    if( ! is_user_logged_in() ) {
        if ( function_exists('digits_version') && azin_opt( 'digits_mode' ) ) {
            $digits_mode = ( azin_opt( 'digits_page' ) ? 'digitlink' : 'digitpopup' ); ?>
            <li class="digitsbtn <?php echo $digits_mode; ?>">
                <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'My Account', 'azin-file'); ?>">
                </span>
                <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php _e( 'My Account', 'azin-file'); ?></span>
                <?php } ?>
            </li>
        <?php } elseif( azin_opt( 'merge_user_btn' ) ) { ?>
            <li>
                <a title="<?php _e( 'My Account', 'azin-file'); ?>" <?php if( azin_opt( 'ch_login_link' ) ) {echo 'href="'. azin_opt( 'login_link' ) .'"'; } else {echo 'href="'. esc_url( azin_myaccount_link() ) .'"'; } ?>>
                    <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'My Account', 'azin-file'); ?>">
                    </span>
                    <?php if ( ! $mftitle ) { ?>
                    <span class="mf-title"><?php _e( 'My Account', 'azin-file'); ?></span>
                    <?php } ?>
                </a>
            </li>
        <?php } else { ?>
            <li>
                <a title="<?php _e( 'My Account', 'azin-file'); ?>" <?php if( azin_opt( 'ch_login_link' ) ) {echo 'href="'.azin_opt( 'login_link' ).'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>>
                    <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'My Account', 'azin-file'); ?>">
                    </span>
                    <?php if ( ! $mftitle ) { ?>
                    <span class="mf-title"><?php _e( 'My Account', 'azin-file'); ?></span>
                    <?php } ?>
                </a>
            </li>
        <?php } ?>
    <?php } else { ?>
        <li onclick="openNav()">
            <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'User Menu', 'azin-file'); ?>">
            </span>
            <?php if ( ! $mftitle ) { ?>
            <span class="mf-title"><?php _e( 'User Menu', 'azin-file'); ?></span>
            <?php } ?>
        </li>
    <?php }
}