<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

$post_type = az_woo() ? 'product' : 'download';
$meta_key  = az_woo() ? 'total_sales' : '_edd_download_earnings';

if ( azin_opt( 'most_saled' ) ) {

    $args = array(
        'posts_per_page' => 8,
        'post_type'      => $post_type,
        'post_status'    => 'publish',
        'meta_key'       => $meta_key,
        'orderby'        => 'meta_value_num',
        'order'          => 'DESC'  );
        
} else {

    $args = array(
        'posts_per_page' => 8,
        'post_type'      => $post_type,
        'post_status'    => 'publish',
        'meta_key'       => 'post_views_count',
        'orderby'        => 'meta_value_num',
        'order'          => 'DESC'  );
}

if ( az_woo() && 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
    $args['meta_query' ] = array(
        'relation' => 'AND',
        array(
            'key'   => '_stock_status',
            'value' => 'instock'
        )
    );
}

$block_args = array(
    'block_title'      => azin_opt( 'most_viewed_title' ),
    'block_icon'       => azin_opt( 'most_viewed_icon' ),
    'block_itemscount' => azin_opt( 'main_bcol_count' ),
    'block_itemplay'   => azin_opt( 'most_viewed_play' ) ? true : false,
    'block_query'      => $args,
    'block_post_type'  => $post_type
 );

 azin_carousel_block( $block_args );

?>