<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
	exit;

$post_type = az_woo() ? 'product' : 'download';

$args = array(
	'posts_per_page' => 8,
	'post_type' => $post_type,
	'post_status' => 'publish',
	'order' => 'DESC'  
);

if ( az_woo() && 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
	$args['meta_query' ] = array(
		'relation' => 'AND',
		array(
			'key' => '_stock_status',
			'value' => 'instock'
		)
	);
}

$block_title_link = az_woo() ? get_permalink( wc_get_page_id( 'shop' ) ) : get_home_url() . '/downloads';

$block_args = array(
	'block_title'      => azin_opt( 'prod_block_title' ),
	'block_title_link' => $block_title_link,
	'block_icon'       => azin_opt( 'prod_block_icon' ),
	'block_itemscount' => azin_opt( 'main_bcol_count' ),
	'block_itemplay'   => azin_opt( 'prod_block_play' ) ? true : false,
	'block_query'      => $args,
	'block_post_type'  => $post_type
);

azin_carousel_block( $block_args );
?>