<?php

// Exit if accessed directly
if (!defined('ABSPATH') ) {
    exit;
}


//Azin register ajax script
function azin_ajax_script() {
    wp_register_script('azin-ajax-script', get_stylesheet_directory_uri(). '/js/azin-ajax.js', array('jquery' ), AZ_VER, true);
    
    // Localize the script with new data
    $script_data_array = array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'security' => wp_create_nonce( 'azin_ajax' ),
    );

    wp_localize_script( 'azin-ajax-script', 'azinproduct', $script_data_array );
    wp_enqueue_script('azin-ajax-script');
}
add_action( 'wp_enqueue_scripts', 'azin_ajax_script' );


//Product quick view on product archive pages
if ( azin_opt( 'show_btn_quick_view' ) ) {
    add_action('wp_ajax_load_post_by_ajax', 'azin_load_post_by_ajax_callback');
    add_action('wp_ajax_nopriv_load_post_by_ajax', 'azin_load_post_by_ajax_callback');
}
function azin_load_post_by_ajax_callback() {
    

    check_ajax_referer('azin_ajax', 'security');

    $product_id = $_POST['id'];
    
    if ( az_woo() ){
        $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'p' => $_POST['id'],
        );
    } else {
        $args = array(
            'post_type' => 'download',
            'post_status' => 'publish',
            'p' => $_POST['id'],
        );
    }
 
    $posts = new WP_Query( $args );
 
    $arr_response = array();
    
    if ( $posts->have_posts() ) {
 
        while( $posts->have_posts() ) {
            
            $posts->the_post();

            $mtitle = '<a class="quick-view-link" href="'. get_permalink() .'"><i class="fal fa-bags-shopping" aria-hidden="true"></i>' . get_the_title() . '</a>';


            //Quick view preview
            ob_start();

            az_product_preview( $product_id , true );

            $view_text = azin_is_course( $product_id ) ? __( 'View Course', 'azin-file' ) : __( 'View Product', 'azin-file' );

            echo '<a class="quick-view-details" href="'. get_permalink() .'">'. $view_text .'</a>';

            $preview = ob_get_clean();

            //Quick view product details
            ob_start();
            
            az_product_fields( $product_id );
            
            az_check_user_purchased( $product_id );

            if ( az_woo() ) {

                az_product_price_woo( $product_id );

                az_add_product_woo( $product_id );
            } else {
                az_product_price_edd( $product_id );

                az_add_product_edd( $product_id );
            }

            $content = ob_get_clean();

            if ( az_woo() ) {
                $product = wc_get_product( $product_id );
                if( ! $product->is_type( 'external' ) && ( azin_opt( 'ajax_add' ) && get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' && get_option( 'woocommerce_cart_redirect_after_add' ) === 'no') ) {
                    $quickajax = 'quickajax';
                } else {
                    $quickajax = 'quickajax-disable';
                }
            } else {
                $quickajax = '';
            }
            
            $arr_response = array(
                'title' => $mtitle,
                'preview' => $preview,
                'content' => $content,
                'quickajax' => $quickajax,
            );
        }
        wp_reset_postdata();
    }
 
    echo json_encode( $arr_response );
 
    wp_die();
}

//Quick view modal
if ( azin_opt( 'show_btn_quick_view' ) ) {
    add_action( 'wp_footer', 'azin_quick_view_modal' );
}

function azin_quick_view_modal() {
 ?>
<!-- Modal -->
<div class="modal fade bd-example-modal-lg<?php echo ( azin_opt( 'quick_view_style_two' ) ? ' azin-quick-view-style-two' : ' azin-quick-view-style-one' ) ?>" id="postModal" tabindex="-1" role="dialog" aria-labelledby="postModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="postModalLabel"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>
              </div>
              <div class="modal-body<?php echo az_woo() ? ' woocommerce' : ''; ?>">
                <div class="container-fluid<?php echo az_woo() ? ' single-product' : ' single-download'; ?> product-quick-view">
                    <div class="row product">

                        <div class="col-12 quick-gallery">
                        </div>

                        <div class="col-12 summary entry-summary scrollable">
                            <div class="summary-content">   
                            </div>
                        </div>
                    </div>
                </div>
              </div>
        </div>
      </div>
</div>
<?php }