<?php 
//Plus Minus Quantity Buttons @ WooCommerce Single Product Page
 
if ( $max_value && $min_value === $max_value ) {
	?>
	<div class="quantity hidden">
		<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" class="qty" name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $min_value ); ?>" />
	</div>
	<?php
} else {
	/* translators: %s: Quantity. */
	$label = ! empty( $args['product_name'] ) ? sprintf( __( '%s quantity', 'azin-file' ), wp_strip_all_tags( $args['product_name'] ) ) : __( 'Quantity', 'azin-file' );
   ?>
	<div class="quantity-con">
		<button type="button" class="plus">
   			<i class="fal fa-plus"></i>
		</button>
		<div class="quantity">
			<label class="screen-reader-text" for="<?php echo esc_attr( $input_id ); ?>"><?php echo esc_attr( $label ); ?></label>
			<input type="number" step="<?php echo esc_attr( $step ); ?>" <?php if ( is_numeric( $min_value ) ) : ?>min="<?php echo esc_attr( $min_value ); ?>"<?php endif; ?> <?php if ( is_numeric( $max_value ) ) : ?>max="<?php echo esc_attr( $max_value ); ?>"<?php endif; ?> name="<?php echo esc_attr( $input_name ); ?>" value="<?php echo esc_attr( $input_value ); ?>" title="<?php _ex( 'Qty', 'Product quantity input tooltip', 'azin-file' ) ?>" class="input-text qty text" size="4" />
		</div>
		<button type="button" class="minus">
			<i class="fal fa-minus"></i>
		</button>
	</div>
	<?php
}