<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

//Azinfile product header banner
function az_post_head_banner() {

    //Post Page Header Banner
    if ( azin_opt( 'show_post_head_banner' ) ) {
        
        if ( azin_opt( 'post_head_banner_replace' ) ) {

            $bnr_args = array(
                'bnr_code'      => azin_opt( 'post_head_banner_code' ),
                'not_on_mobile' => false,
                'custom_class'  => ' foot-con'
            );

            azin_bnr_code( $bnr_args );

        } else {

            $pheadb_width = ( ! empty( azin_opt( 'post_head_banner', 'width' ) ) ) ? azin_opt( 'post_head_banner', 'width' ) : '840';
            $pheadb_height = ( ! empty( azin_opt( 'post_head_banner', 'height' ) ) ) ? azin_opt( 'post_head_banner', 'height' ) : '150';
            $hover_title = azin_opt( 'post_head_banner_hover_title' ) ? 'yes' : 'no';
            $target = azin_opt( 'post_head_banner_newtab' ) ? ' target="_blank"' : '';
            $nofollow = azin_opt( 'post_head_banner_nofollow' ) ? ' rel="nofollow"' : '';
            
            $bnr_args = array(
                'img_src' => azin_to_https( azin_opt( 'post_head_banner', 'url' ) ),
                'img_link_url' => azin_opt( 'post_head_banner_link' ),
                'img_title' => azin_opt( 'post_head_banner_title' ),
                'link_target' => $target,
                'link_rel' => $nofollow,
                'hover_effect' => azin_opt( 'post_head_banner_hover_effect' ),
                'hover_title' => $hover_title,
                'image_width' => $pheadb_width,
                'image_height' => $pheadb_height,
                'not_on_mobile' => false,
                'custom_class' => ' foot-con'
            );

            azin_bnr_image( $bnr_args );

        }
    } 
}

//Azinfile post footer banner
function az_post_foot_banner() {
    
    //Post Page Footer Banner
    if ( azin_opt( 'show_post_foot_banner' ) ) {

        if ( azin_opt( 'post_foot_banner_replace' ) ) {

            $bnr_args = array(
                'bnr_code'      => azin_opt( 'post_foot_banner_code' ),
                'not_on_mobile' => false,
                'custom_class'  => ' foot-con'
            );

            azin_bnr_code( $bnr_args );

        } else {

            $pfootb_width = ( ! empty( azin_opt( 'post_foot_banner', 'width' ) ) ) ? azin_opt( 'post_foot_banner', 'width' ) : '840';
            $pfootb_height = ( ! empty( azin_opt( 'post_foot_banner', 'height' ) ) ) ? azin_opt( 'post_foot_banner', 'height' ) : '150';
            $hover_title = azin_opt( 'post_foot_banner_hover_title' ) ? 'yes' : 'no';
            $target = azin_opt( 'post_foot_banner_newtab' ) ? ' target="_blank"' : '';
            $nofollow = azin_opt( 'post_foot_banner_nofollow' ) ? ' rel="nofollow"' : '';
            
            $bnr_args = array(
                'img_src' => azin_to_https( azin_opt( 'post_foot_banner', 'url' ) ),
                'img_link_url' => azin_opt( 'post_foot_banner_link' ),
                'img_title' => azin_opt( 'post_foot_banner_title' ),
                'link_target' => $target,
                'link_rel' => $nofollow,
                'hover_effect' => azin_opt( 'post_foot_banner_hover_effect' ),
                'hover_title' => $hover_title,
                'image_width' => $pfootb_width,
                'image_height' => $pfootb_height,
                'not_on_mobile' => false,
                'custom_class' => ' foot-con'
            );
    
            azin_bnr_image( $bnr_args );

        }
    }

    if ( azin_opt( 'show_ads_banner1_down' ) ) {
        azin_ads_banner_one();
    }

    if ( azin_opt( 'show_ads_banner2_down' ) ) {
        azin_ads_banner_two();
    }
}

// Azin_show_related_post
function azin_show_related_post( $id ) {

    if ( ! azin_opt( 'show_related_s' ) ) 
        return;

    $custom_taxterms = wp_get_object_terms( $id, azin_opt( 'related_s_by' ), array( 'fields' => 'ids' ) );
    
    $args = array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'posts_per_page' => azin_opt( 'related_s_count' ),
        'orderby' => 'rand',
        'tax_query' => array(
            array(
                'taxonomy' => azin_opt( 'related_s_by' ),
                'field' => 'id',
                'terms' => $custom_taxterms
            )
        ),
        'post__not_in' => array ( $id),
    );

    $query = new WP_Query( $args );

    if ( $query->found_posts < 1 )
        return;

    $block_args = array(
        'block_title'      => azin_opt( 'related_s_title' ),
        //'block_title_link' => '',
        'block_icon'       => 'fal fa-file-alt',
        'block_itemscount' => azin_opt( 'related_scol_count' ),
        'block_itemplay'   => false,
        'block_itemloop'   => false,
        'block_query'      => $args,
        //'block_hide'	   => false,
        'block_post_type'  => 'post'
    );

    azin_carousel_block( $block_args );

}

// Azin_show_related_post_products
function azin_show_related_post_products( $id ) {
    
    if ( ! azin_opt( 'show_related_post_products' ) )
        return;

        $tag = az_woo() ? 'product_tag' : 'download_tag';
        $post_type = az_woo() ? 'product' : 'download';

    if ( azin_opt( 'related_post_products_by' ) == 'tag' ) {

        $related_taxterms = wp_get_object_terms( $id, 'post_tag', array( 'fields' => 'names' ) );
    
        $args = array(
            'post_type' => $post_type,
            'post_status' => 'publish',
            'posts_per_page' => azin_opt( 'related_post_products_count' ),
            'orderby' => 'rand',
            //'fields'                    => 'ids',
            'no_found_rows'             => true,
            'update_post_term_cache'    => false,
            'tax_query' => array(
                array(
                    'taxonomy' => $tag,
                    'field' => 'name',
                    'terms' => $related_taxterms
                )
            ),
            'post__not_in' => array ( $id ),
        );

    } else {

        $args = array(
            'post_type' => $post_type,
            'post_status' => 'publish',
            'posts_per_page' => azin_opt( 'related_post_products_count' ),
            'orderby' => 'rand',
            //'fields'                    => 'ids',
            'no_found_rows'             => true,
            'update_post_term_cache'    => false,
            'post__in' => rwmb_meta( 'file_related_products_ids', '', $id )
        );
        
    }

    $query = new WP_Query( $args );

    if ( $query->found_posts < 1 )
        return;

    $block_args = array(
        'block_title'      => azin_opt( 'related_post_products_title' ),
        //'block_title_link' => '',
        'block_icon'       => 'fal fa-shopping-bag',
        'block_itemscount' => azin_opt( 'related_post_products_col_count' ),
        'block_itemplay'   => false,
        'block_itemloop'   => false,
        'block_query'      => $args,
        //'block_hide'	   => false,
        'block_post_type'  => $post_type
    );

    azin_carousel_block( $block_args );

}

//Azinfile product archive content
function azin_post_archive_content( $id, $col ) {
    
    $post_class = '';
    $post_class .= ( azin_opt( 'mobile_col' ) == 1 ? ' mobile-col-one' : '' );
    ?>
    <div role="main" class="<?php echo $col . $post_class; ?> pcon" id="post-<?php the_ID(); ?>">
        
            <div class="mini-post<?php echo ( azin_opt( 'show_post_cat_archive' ) && azin_opt( 'post_cat_style' ) === 'second' ? ' mini-post-cat-style-two' : '' ); ?>">
                <div class="post-img">

                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                        <?php 
                        if ( azin_opt( 'post_custom_thumb' ) ) { 
                            pc_img();
                        } else { 
                            p_img(); 
                        } ?>
                    </a>

                    <?php if( azin_opt( 'show_post_cat_archive' ) && ! empty ( $id ) ) {
                        $post_categories = get_post_primary_category( $id, 'category' ); 
                        $primary_category = $post_categories['primary_category']; ?>
                        <span class="post-cat<?php echo azin_opt( 'post_cat_style' ) === 'second' ? ' post-cat-style-two' : ''; ?>">
                            <?php echo $primary_category->name; ?>
                        </span>
                    <?php } ?>

                    <?php if ( azin_opt( 'show_post_pub' ) ) {

                        if ( azin_opt( 'post_pub_style' ) === 'first' ) {
                            echo '<span class="post-pub">';
                                if ( azin_opt( 'show_post_update' ) ) {
                                    echo get_the_modified_time( 'j F Y', $id );
                                } else {
                                    echo get_jdate_publish_time();
                                }
                            echo '</span>';
                        } elseif ( azin_opt( 'post_pub_style' ) === 'second' ) {
                            echo '<span class="post-pub-style-two">';
                                if ( azin_opt( 'show_post_update' ) ) {
                                    echo '<span class="post-pub-day">'. get_the_modified_time( 'j', $id ) .'</span>';
                                    echo '<span class="post-pub-month">'. get_the_modified_time( 'F', $id ) .'</span>';
                                    //echo '<span class="post-pub-year">'. get_the_modified_time( 'Y', $id ) .'</span>';
                                } else {
                                    echo '<span class="post-pub-day">'. get_jdate_publish_time_two( 'j' ) .'</span>';
                                    echo '<span class="post-pub-month">'. get_jdate_publish_time_two( 'F' ) .'</span>';
                                    //echo '<span class="post-pub-year">'. get_jdate_publish_time_two( 'Y' ) .'</span>';
                                }
                            echo '</span>';
                        }
                    } ?>

                </div>

                <div class="col-12">
                    <div class="col-10 prod-name pt-name">
                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                            <h2 title="<?php the_title(); ?>">
                                <?php the_title(); ?>
                            </h2>
                        </a>
                    </div>
                </div>

                <?php if ( azin_opt( 'show_post_author_archive' ) ) { ?>
                    <span class="azin-post-author">
                        <?php if ( azin_opt( 'link_post_author' ) ) { ?>
                        <a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>" rel="author">
                        <?php } ?>

                        <?php 
                            $author = get_post_field( 'post_author', get_the_ID() );
                            echo get_avatar( $author , 20, '' , get_the_author_meta('display_name', $author ) ); 
                            echo '<span class="azin-author-name">'. get_the_author_meta( 'display_name', $author ) .'</span>';
                        ?>

                        <?php if ( azin_opt( 'link_post_author' ) ) { ?>
                        </a>
                        <?php } ?>
                    </span>
                <?php } ?>


                <?php if ( azin_opt( 'show_excerpt' ) ) { ?>
                    <div class="col-12 pdesc">
                        <?php the_excerpt(); ?>
                    </div>
                <?php } ?>
            </div>
   </div>
    <?php
}

function azin_post_block_content( $id ) {
     ?>
    <div class="item">
        <div class="mini-post<?php echo ( azin_opt( 'show_post_cat_archive' ) && azin_opt( 'post_cat_style' ) === 'second' ? ' mini-post-cat-style-two' : '' ); ?>">
            <div class="post-img">

                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                    <?php 
                    if ( azin_opt( 'post_custom_thumb' ) ) { 
                        pc_img();
                    } else { 
                        p_img(); 
                    } ?>
                </a>

                <?php if( azin_opt( 'show_post_cat_archive' ) && ! empty ( $id ) ) {
                    $post_categories = get_post_primary_category( $id, 'category' ); 
                    $primary_category = $post_categories['primary_category']; ?>
                    <span class="post-cat<?php echo azin_opt( 'post_cat_style' ) === 'second' ? ' post-cat-style-two' : ''; ?>">
                        <?php echo $primary_category->name; ?>
                    </span>
                <?php } ?>

                <?php if ( azin_opt( 'show_post_pub' ) ) {

                    if ( azin_opt( 'post_pub_style' ) === 'first' ) {
                        echo '<span class="post-pub">';
                            if ( azin_opt( 'show_post_update' ) ) {
                                echo get_the_modified_time( 'j F Y', $id );
                            } else {
                                echo get_jdate_publish_time();
                            }
                        echo '</span>';
                    } elseif ( azin_opt( 'post_pub_style' ) === 'second' ) {
                        echo '<span class="post-pub-style-two">';
                            if ( azin_opt( 'show_post_update' ) ) {
                                echo '<span class="post-pub-day">'. get_the_modified_time( 'j', $id ) .'</span>';
                                echo '<span class="post-pub-month">'. get_the_modified_time( 'F', $id ) .'</span>';
                                //echo '<span class="post-pub-year">'. get_the_modified_time( 'Y', $id ) .'</span>';
                            } else {
                                echo '<span class="post-pub-day">'. get_jdate_publish_time_two( 'j' ) .'</span>';
                                echo '<span class="post-pub-month">'. get_jdate_publish_time_two( 'F' ) .'</span>';
                                //echo '<span class="post-pub-year">'. get_jdate_publish_time_two( 'Y' ) .'</span>';
                            }
                        echo '</span>';
                    }
                } ?>

            </div>

            <div class="col-12">
                <div class="col-10 prod-name pt-name">
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                        <h2 title="<?php the_title(); ?>">
                            <?php the_title(); ?>
                        </h2>
                    </a>
                </div>
            </div>

            <?php if ( azin_opt( 'show_post_author_archive' ) ) { ?>
                <span class="azin-post-author">
                    <?php if ( azin_opt( 'link_post_author' ) ) { ?>
                    <a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>" rel="author">
                    <?php } ?>

                    <?php 
                        $author = get_post_field( 'post_author', get_the_ID() );
                        echo get_avatar( $author , 20, '' , get_the_author_meta('display_name', $author ) ); 
                        echo '<span class="azin-author-name">'. get_the_author_meta( 'display_name', $author ) .'</span>';
                    ?>

                    <?php if ( azin_opt( 'link_post_author' ) ) { ?>
                    </a>
                    <?php } ?>
                </span>
            <?php } ?>


            <?php if ( azin_opt( 'show_excerpt' ) ) { ?>
                <div class="col-12 pdesc">
                    <?php the_excerpt(); ?>
                </div>
            <?php } ?>
        </div>
    </div>
<?php
}