<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

//Azinfile site header banner
function az_header_banner() {
    
    if ( azin_opt( 'show_head_banner' ) ) {

        $not_on_mobile = ! azin_opt( 'show_head_mobile' ) ? true : false;

        if ( azin_opt( 'head_banner_replace' ) ) {

            $bnr_args = array(
                'bnr_code'      => azin_opt( 'head_banner_code' ),
                'not_on_mobile' => $not_on_mobile,
                'custom_class'  => ' head-con'
            );

            azin_bnr_code( $bnr_args );
            
        } else {

            $headb_width = ( ! empty( azin_opt( 'head_banner', 'width' ) ) ) ? azin_opt( 'head_banner', 'width' ) : '1188';
            $headb_height = ( ! empty( azin_opt( 'head_banner', 'height' ) ) ) ? azin_opt( 'head_banner', 'height' ) : '134';
            $hover_title = azin_opt( 'head_banner_hover_title' ) ? 'yes' : 'no';
            $target = azin_opt( 'head_banner_newtab' ) ? ' target="_blank"' : '';
            $nofollow = azin_opt( 'head_banner_nofollow' ) ? ' rel="nofollow"' : '';
            
            $bnr_args = array(
                'img_src'       => azin_to_https( azin_opt( 'head_banner', 'url' ) ),
                'img_link_url'  => azin_opt( 'head_banner_link' ),
                'img_title'     => azin_opt( 'head_banner_title' ),
                'link_target'   => $target,
                'link_rel'      => $nofollow,
                'hover_effect'  => azin_opt( 'head_banner_hover_effect' ),
                'hover_title'   => $hover_title,
                'image_width'   => $headb_width,
                'image_height'  => $headb_height,
                'not_on_mobile' => $not_on_mobile,
                'custom_class'  => ' head-con'
            );

            azin_bnr_image( $bnr_args );

        }
    }
}

//Azinfile product header banner
function az_product_head_banner( $id ) {
    
    if ( azin_opt( 'show_down_head_banner' ) ) {

        if ( azin_opt( 'down_head_banner_replace' ) ) {

            $bnr_args = array(
                'bnr_code'      => azin_opt( 'down_head_banner_code' ),
                'not_on_mobile' => false,
                'custom_class'  => ' foot-con'
            );

            azin_bnr_code( $bnr_args );

        } else {

            $dheadb_width = ( ! empty( azin_opt( 'down_head_banner', 'width' ) ) ) ? azin_opt( 'down_head_banner', 'width' ) : '840';
            $dheadb_height = ( ! empty( azin_opt( 'down_head_banner', 'height' ) ) ) ? azin_opt( 'down_head_banner', 'height' ) : '150';
            $hover_title = azin_opt( 'down_head_banner_hover_title' ) ? 'yes' : 'no';
            $target = azin_opt( 'down_head_banner_newtab' ) ? ' target="_blank"' : '';
            $nofollow = azin_opt( 'down_head_banner_nofollow' ) ? ' rel="nofollow"' : '';
            
            
            $bnr_args = array(
                'img_src' => azin_to_https( azin_opt( 'down_head_banner', 'url' ) ),
                'img_link_url' => azin_opt( 'down_head_banner_link' ),
                'img_title' => azin_opt( 'down_head_banner_title' ),
                'link_target' => $target,
                'link_rel' => $nofollow,
                'hover_effect' => azin_opt( 'down_head_banner_hover_effect' ),
                'hover_title' => $hover_title,
                'image_width' => $dheadb_width,
                'image_height' => $dheadb_height,
                'not_on_mobile' => false,
                'custom_class' => ' foot-con'
            );

            azin_bnr_image( $bnr_args );

        }
    }

    $top_banner_img = rwmb_meta ( 'file_product_top_banner_img', '', $id );
    $top_banner_title = rwmb_meta ( 'file_product_top_banner_title', '', $id );
    $top_banner_link = rwmb_meta ( 'file_product_top_banner_link', '', $id );
    $top_banner_id = attachment_url_to_postid( esc_url( $top_banner_img ) );
    $top_banner = wp_get_attachment_image_src( $top_banner_id, 'full' );
    $target = azin_opt( 'down_head_banner_newtab' ) ? ' target="_blank"' : '';
    $nofollow = azin_opt( 'down_head_banner_nofollow' ) ? ' rel="nofollow"' : '';

    if ( ! empty ( $top_banner_img) ) {
        $bnr_args = array(
            'img_src' => azin_to_https( $top_banner_img ),
            'img_link_url' => $top_banner_link,
            'img_title' => $top_banner_title,
            'link_target' => $target,
            'link_rel' => $nofollow,
            'hover_effect' => azin_opt( 'down_head_banner_hover_effect' ),
            'hover_title' => $top_banner_title,
            'image_width' => $top_banner[1],
            'image_height' => $top_banner[2],
            'not_on_mobile' => false,
            'custom_class' => ' foot-con'
        );

        azin_bnr_image( $bnr_args );
    }
}

//Azinfile product footer banner
function az_product_foot_banner() {
    
    if ( azin_opt( 'show_down_foot_banner' ) ) {

        if ( azin_opt( 'down_foot_banner_replace' ) ) {

            $bnr_args = array(
                'bnr_code'      => azin_opt( 'down_foot_banner_code' ),
                'not_on_mobile' => false,
                'custom_class'  => ' foot-con'
            );

            azin_bnr_code( $bnr_args );

        } else {

            $dfootb_width = ( ! empty( azin_opt( 'down_foot_banner', 'width' ) ) ) ? azin_opt( 'down_foot_banner', 'width' ) : '840';
            $dfootb_height = ( ! empty( azin_opt( 'down_foot_banner', 'height' ) ) ) ? azin_opt( 'down_foot_banner', 'height' ) : '150';
            $hover_title = azin_opt( 'down_foot_banner_hover_title' ) ? 'yes' : 'no';
            $target = azin_opt( 'down_foot_banner_newtab' ) ? ' target="_blank"' : '';
            $nofollow = azin_opt( 'down_foot_banner_nofollow' ) ? ' rel="nofollow"' : '';
            
            $bnr_args = array(
                'img_src' => azin_to_https( azin_opt( 'down_foot_banner', 'url' ) ),
                'img_link_url' => azin_opt( 'down_foot_banner_link' ),
                'img_title' => azin_opt( 'down_foot_banner_title' ),
                'link_target' => $target,
                'link_rel' => $nofollow,
                'hover_effect' => azin_opt( 'down_foot_banner_hover_effect' ),
                'hover_title' => $hover_title,
                'image_width' => $dfootb_width,
                'image_height' => $dfootb_height,
                'not_on_mobile' => false,
                'custom_class' => ' foot-con'
            );

            azin_bnr_image( $bnr_args );

        }
    }

    if ( azin_opt( 'show_ads_banner1_down' ) ) {
        azin_ads_banner_one();
    }

    if ( azin_opt( 'show_ads_banner2_down' ) ) {
        azin_ads_banner_two();
    }
}

//Azinfile Woo product header (style one)
function az_header_style_one_woo( $id ) {
    
    if ( ! azin_opt( 'bread_style_two' ) || !azin_opt( 'show_bread' ) ) { ?>
    <header class="post-row">
        <div class="post-title">
            <h1>
                <i aria-hidden="true" class="fal fa-<?php $posticon = ( rwmb_meta( 'file_p_type', '', $id ) != '' ? rwmb_meta( 'file_p_type', '', $id ) : 'download' ); echo $posticon; ?>"></i>
                <?php the_title(); ?>
            </h1>
            <div class="post-extra">
                <?php if ( function_exists("waproduct_add_star_rating") && ( azin_opt( 'star_rating' ) ) ) { ?>
                <div class="rating">
                    <?php waproduct_add_star_rating( $id ); ?>
                </div>
                <?php } ?>

                <?php if ( azin_opt( 'social_share' ) ) { ?>
                    <span tabindex="0" class="share-btn" data-toggle="modal" data-target="#shareModal">
                        <i class="fal fa-share-alt" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Share', 'azin-file' ) ?>"></i>
                    </span>
                <?php } ?>

                <?php //Like Button 
                    if ( azin_opt( 'product_like_btn' ) ) { ?>

                        <?php if ( is_single() && 'product' == get_post_type() && class_exists('YITH_WCWL') ) { ?>
                            <span class="azin-like-product-single" data-toggle="tooltip" data-placement="top"  title="<?php _e( 'Add to Wishlist', 'azin-file'); ?>">
                                <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist product_id="'. $id .'" icon="fa-heart" already_in_wishslist_text="" product_added_text="" label="" browse_wishlist_text=""]') ); ?>
                            </span>
                        <?php } ?>

                <?php } 
                //Like Button ?>

                <?php if ( ! azin_opt( 'show_pre_prod_btn_under' ) ) { ?>
                <?php if ( rwmb_meta( 'file_pre', '', $id ) != '' ) { ?>
                <a href="<?php echo rwmb_meta( 'file_pre', '', $id ); ?>" data-title="<?php echo azin_opt( 'text_pre' ); ?>" target="_blank">
                    <span class="pre-btn" data-toggle="tooltip" data-placement="top" title="<?php echo azin_opt( 'text_pre' ); ?>">
                        <i class="<?php echo azin_opt( 'pre_prod_btn_icon' ); ?>"></i>
                        <span class="pre-text hidden-sm hidden-xs hidden-mobile">
                            <?php echo azin_opt( 'text_pre' ); ?>
                        </span>
                    </span>
                </a>
                <?php } ?>
                <?php } ?>

            </div>
        </div>
    </header>
<?php
    }
}

//Azinfile Edd product header (style one)
function az_header_style_one_edd( $id ) {
    
    if ( ! azin_opt( 'bread_style_two' ) || !azin_opt( 'show_bread' ) ) { ?>
        <header class="post-row">
            <div class="post-title">
                <h1 <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="name" <?php } ?>><i
                        aria-hidden="true"
                        class="fal fa-<?php $posticon = ( rwmb_meta( 'file_p_type', '', $id ) != '' ? rwmb_meta( 'file_p_type', '', $id ) : 'download' ); echo $posticon; ?>"></i>
                    <?php the_title(); ?>
                </h1>
                <div class="post-extra">
                    <?php if ( function_exists("az_star_ratings") && ( azin_opt( 'star_rating' ) ) ) { ?>
                    <div class="rating">
                        <?php echo az_star_ratings( $id ); ?>
                    </div>
                    <?php } ?>
                    
                    <?php if ( azin_opt( 'social_share' ) ) { ?>
                    <span tabindex="0" class="share-btn" data-toggle="modal" data-target="#shareModal">
                        <i class="fal fa-share-alt" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Share', 'azin-file' ) ?>"></i>
                    </span>
                    <?php } ?>

                    <?php //Like Button 
                    if ( azin_opt( 'product_like_btn' ) ) { ?>

                        <?php if ( is_single() && 'download' == get_post_type() && class_exists('EDD_Wish_Lists') ) { ?>
                            <span class="azin-like-product-single" data-toggle="tooltip" data-placement="top"  title="<?php _e( 'Add to Wishlist', 'azin-file'); ?>">
                                <?php edd_wl_load_wish_list_link( $id ); ?>
                            </span>
                        <?php } ?>

                    <?php } 
                    //Like Button ?>

                    <?php if ( ! azin_opt( 'show_pre_prod_btn_under' ) ) { ?>
                    <?php if ( rwmb_meta( 'file_pre', '', $id ) != '' ) { ?>
                    <a href="<?php echo rwmb_meta( 'file_pre', '', $id ); ?>" data-title="<?php echo azin_opt( 'text_pre' ); ?>" target="_blank">
                        <span class="pre-btn" data-toggle="tooltip" data-placement="top" title="<?php echo azin_opt( 'text_pre' ); ?>">
                            <i class="<?php echo azin_opt( 'pre_prod_btn_icon' ); ?>"></i>
                            <span class="pre-text hidden-sm hidden-xs hidden-mobile">
                                <?php echo azin_opt( 'text_pre' ); ?>
                            </span>
                        </span>
                    </a>
                    <?php } ?>
                    <?php } ?>

                </div>
            </div>
        </header>
<?php }
}

//Azinfile product preview
function az_product_preview( $id, $full_image ) {
    
    global $product;

    //File Preview
    $file_pre = rwmb_meta( 'file_pre_type', '', $id );
    
    if ( az_woo() ) {
        $images = $product->get_gallery_image_ids();
    } else {
        if ( ! azin_opt( 'product_custom_thumb' ) ) {
            $images = rwmb_meta( 'file_images', array( 'size' => 'single-download' ) );
        } else {
            $images = rwmb_meta( 'file_images', array( 'size' => 'single-download-s' ) );
        }
    }

    $videos = rwmb_meta( 'file_video', '', $id );
    $aparat = rwmb_meta( 'file_aparat', '', $id );
    $audio = rwmb_meta ( 'file_audio', '', $id );

    //Aparat Preview
    if ( $file_pre == 'pre_aparat' && ! empty( $aparat) ) {
		
		echo '<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}</style><div class="h_iframe-aparat_embed_frame"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'.$aparat.'/vt/frame" title="'.get_the_title( $id ).'" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>';

    //Video Preview
    } elseif ( $file_pre == 'pre_video' && ! empty( $videos ) ) { 

    if ( ! azin_opt( 'product_custom_thumb' ) ) {
        $poster_size = ( azin_opt( 'product_style_two' ) ? 'full' : 'single-download' ); 
    } else {
        $poster_size = 'single-download-s'; 
    }

    $poster = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), $poster_size )[0];
    echo do_shortcode( '[video src="'. $videos .'" preload="none" poster="'. $poster .'"]' ); 

    //Image Slider Preview
    } elseif ( ( azin_opt( 'auto_woo_gallery' ) || $file_pre == 'pre_slides' ) && ! empty( $images ) ) { ?>

        <div class="azin-product-gallery owl-carousel" data-close="<?php _e( 'Close', 'azin-file' ); ?>" data-nextbtn="<?php _e( 'Next', 'azin-file' ); ?>" data-prevbtn="<?php _e( 'Previous', 'azin-file' ); ?>" data-loadingmsg="<?php _e( 'Loading...', 'azin-file' ); ?>" data-itemplay="false" data-itemtime="8000" data-dir="<?php azin_rtl(); ?>">
            <?php

            if ( ! azin_opt( 'product_custom_thumb' ) ) {
                $image_size = ( azin_opt( 'product_style_two' ) ? 'full' : 'single-download' );
                $image_size_edd = ( azin_opt( 'product_style_two' ) ? 'full_url' : 'url' );
            } else {
                $image_size = 'single-download-s';
                $image_size_edd = 'single-download-s';
            }
            
            if ( azin_opt( 'firt_img_gallery' ) ) {
                
                $image_url_single_download = wp_get_attachment_image_src( get_post_thumbnail_id(), $image_size )[0];
                $image_url_full = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' )[0];
                $image_id    = get_post_thumbnail_id();
                $image_alt   = get_post_meta( $image_id, '_wp_attachment_image_alt', TRUE );
                $image_alt   = ! empty( $image_alt ) ? $image_alt : get_the_title();
            ?>
                <div class="item">
                    <a href="<?php echo $image_url_full; ?>" class="imgg" title="<?php the_title_attribute(); ?>">
                        <img class="item-img" src="<?php echo $image_url_single_download; ?>" alt="<?php echo $image_alt; ?>" />
                    </a>
                </div>
            <?php
            } 
            
            foreach ( $images as $image ) {

                if ( az_woo() ) {
                    $image_url_single_download = wp_get_attachment_image_src( $image, $image_size )[0];
                    $image_url_full = wp_get_attachment_image_src( $image, 'full' )[0];
                    $image_id  = $image;
                } else {
                    $image_url_single_download = $image[ $image_size_edd ];
                    $image_url_full = $image[ 'full_url' ];
                    $image_id  = $image['ID'];
                }

                $image_alt   = get_post_meta( $image_id, '_wp_attachment_image_alt', TRUE );
                $image_alt   = ! empty( $image_alt ) ? $image_alt : get_the_title();
                ?>
                <?php if ( azin_opt( 'site_schema' ) ) {?>
                <?php } ?>
                <div class="item">
                <meta itemprop="image" content="<?php echo $image_url_full; ?>" />
                    <a href="<?php echo $image_url_full; ?>" class="imgg" title="<?php the_title_attribute(); ?>">
                        <img class="item-img" src="<?php echo $image_url_single_download; ?>" alt="<?php echo $image_alt; ?>" />
                    </a>
                </div>
            <?php } ?>
        </div>

        <div class="azin-product-thumbnails owl-carousel" data-dir="<?php azin_rtl(); ?>">

                <?php if ( azin_opt( 'firt_img_gallery' ) ) {
                    
                    $image_url = wp_get_attachment_image_src( get_post_thumbnail_id(), 'thumbnail' )[0];
                    $image_id    = get_post_thumbnail_id();
                    $image_alt   = get_post_meta( $image_id, '_wp_attachment_image_alt', TRUE );
                    $image_alt   = ! empty( $image_alt ) ? $image_alt : get_the_title();           
                    ?>
                    <div class="item">
                        <img src="<?php echo $image_url; ?>" alt="<?php echo $image_alt; ?>" />
                    </div>
                <?php } ?>

                <?php 
                if ( ! az_woo() ) {
                    $images = rwmb_meta( 'file_images', array( 'size' => 'thumbnail' ) ); 
                }
                foreach ( $images as $image ) {
                    if ( az_woo() ) {
                        $image_url = wp_get_attachment_image_src( $image, 'thumbnail' )[0];
                        $image_id  = $image;
                    } else {
                        $image_url = azin_to_https( $image['url'] );
                        $image_id  = $image['ID'];
                    }

                    $image_alt   = get_post_meta( $image_id, '_wp_attachment_image_alt', TRUE );
                    $image_alt   = ! empty( $image_alt ) ? $image_alt : get_the_title();
                     ?>
                <div class="item">
                    <img src="<?php echo $image_url; ?>" alt="<?php echo $image_alt; ?>" />
                </div>
                <?php } ?>

        </div>

        <?php 
    
    //Image Preview
    } else { 
        if ( has_post_thumbnail() ) {

            if ( $full_image ) {
                $image_size = 'full'; 
            } elseif ( ! azin_opt( 'product_custom_thumb' ) ) {
                $image_size = ( azin_opt( 'product_style_two' ) ? 'full' : 'single-download' ); 
            } else {
                $image_size = 'single-download-s';
            }

            ?>
            <a href="<?php the_post_thumbnail_url( 'full' ); ?>" class="imgg" title="<?php the_title_attribute(); ?>">
                <?php 
                    $image_id    = get_post_thumbnail_id();
                    $image_alt   = get_post_meta( $image_id, '_wp_attachment_image_alt', TRUE );
                    $image_alt   = ! empty( $image_alt ) ? $image_alt : get_the_title();           
                ?>
                <img <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="image"<?php } ?> src="<?php the_post_thumbnail_url( $image_size ); ?>" class="post-tumb" alt="<?php echo $image_alt; ?>" />
            </a>
    <?php 
        } else { ?>

            <img <?php if ( azin_opt( 'site_schema' ) ) { ?>itemprop="image"<?php } ?> src="<?php echo esc_url( get_template_directory_uri() ); ?>/images/thumb.png" class="post-tumb" alt="<?php echo get_the_title(); ?>" />

    <?php } 
        //Audio Preview
        if ( $file_pre == 'pre_music' && ! empty( $audio ) ) {

            echo do_shortcode( '[audio src="'.$audio.'"]' );
        
        }

    }

}

//Azinfile product badge
function az_product_badge( $id ) {
    
    if ( rwmb_meta( 'file_special', '', $id ) ) { ?>
        <span class="special" aria-hidden="true">
            <?php echo azin_opt( 'text_special' ); ?>
        </span>
    <?php } 
    
    if ( ! empty( rwmb_meta( 'file_plabel', '', $id ) ) ) { ?>
        <span class="product-label <?php echo rwmb_meta( 'file_plabel_color' ); ?>" aria-hidden="true">
            <?php echo rwmb_meta( 'file_plabel' ); ?>
        </span>
    <?php }
}

//Azinfile product badge
function az_archive_badge( $id ) {
    
    if ( ! empty( dis_price_archive( $id ) ) ) { ?>
        <span class="special" aria-hidden="true">
            <?php echo dis_price_archive( $id ); ?>
        </span>
    <?php 
    } elseif ( rwmb_meta( 'file_special', '', $id ) ) { ?>
        <span class="special" aria-hidden="true">
            <?php echo azin_opt( 'text_special' ); ?>
        </span>
    <?php } 
    
    if ( ! empty( rwmb_meta( 'file_plabel', '', $id ) ) ) { ?>
        <span class="product-label <?php echo rwmb_meta( 'file_plabel_color' ); ?>" aria-hidden="true">
            <?php echo rwmb_meta( 'file_plabel' ); ?>
        </span>
    <?php }
}

//Azinfile product fields
function az_product_fields( $id ) {
    
    setPostViews ( $id );

    //Show Woocommerce product SKU field
    if ( azin_opt( 'show_product_sku' ) ) {
        if ( azin_opt( 'edit_product_sku' ) && ! empty( rwmb_meta( 'file_product_sku', '', $id ) ) ) {
        ?>
            <div class="prod-row prod-attr col-12 azin-product-sku">
    
                <div class="attr">
                    <span class="fal <?php echo azin_opt( 'product_sku_icon' ); ?> picon"></span>
                    <span class="attr-text">
                        <?php echo azin_opt( 'product_sku_title' ); ?>
                    </span>
                </div>

                <div class="attr-value">
                    <span>
                        <?php echo rwmb_meta( 'file_product_sku', '', $id ); ?>
                    </span>
                </div>
            </div>
        <?php
        } elseif ( az_woo() ) {
            global $product;
            $product_sku = $product->get_sku();
            if ( ! empty( $product_sku ) ) {
        ?>
            <div class="prod-row prod-attr col-12 azin-product-sku">
    
                <div class="attr">
                    <span class="fal <?php echo azin_opt( 'product_sku_icon' ); ?> picon"></span>
                    <span class="attr-text">
                        <?php echo azin_opt( 'product_sku_title' ); ?>
                    </span>
                </div>
        
                <div class="attr-value">
                    <span>
                        <?php echo $product_sku; ?>
                    </span>
                </div>
            </div>
        <?php 
            }
        }
    }

    if ( azin_opt( 'show_fone' ) && ! empty( rwmb_meta( 'file_fone', '', $id ) ) ) { ?>
        <div class="prod-row prod-attr col-12 fone">
            <?php $fone_icon = ( ! empty ( azin_opt( 'fone_icon' ) ) ? azin_opt( 'fone_icon' ) : 'fa-file-alt' ); ?>
            <div class="attr">
                <span class="fal <?php echo $fone_icon; ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_opt( 'fone' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php echo rwmb_meta( 'file_fone', '', $id ); ?>
                </span>
            </div>

        </div>
    <?php } 
    
    if ( azin_opt( 'show_ftwo' ) && ! empty( rwmb_meta( 'file_ftwo', '', $id ) ) ) { ?>
        <div class="prod-row prod-attr col-12 ftwo">
            <?php $ftwo_icon = ( ! empty ( azin_opt( 'ftwo_icon' ) ) ? azin_opt( 'ftwo_icon' ) : 'fa-save' ); ?>
            <div class="attr">
                <span class="fal <?php echo $ftwo_icon; ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_opt( 'ftwo' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php echo rwmb_meta( 'file_ftwo', '', $id ); ?>
                </span>
            </div>

        </div>
    <?php } 
    
    if ( azin_opt( 'show_fthree' ) ) { 
        if ( azin_opt( 'edit_fthree' ) && empty( rwmb_meta( 'file_fthree', '', $id ) ) ) {
        //show nothing
        } else {
    ?>
        <div class="prod-row prod-attr col-12 fthree">

            <div class="attr">
                <span class="fal <?php echo azin_opt( 'fthree_icon' ); ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_is_course( $id ) && ! azin_opt( 'edit_fthree' ) ? __( 'Teacher', 'azin-file' ) : azin_opt( 'fthree' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php
                    if ( azin_opt( 'edit_fthree' ) ) { 
                        echo rwmb_meta( 'file_fthree', '', $id );
                    } else { 

                        if ( class_exists( 'WeDevs_Dokan' ) && az_woo() ) {
                            $author_link = get_store_url( get_the_author_meta( 'ID' ) );
                        } else {
                            $author_link = get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) );
                        }
                        ?>
                        
                        <a class="author-link" href="<?php echo $author_link; ?>">
                            <?php the_author(); ?>
                        </a>
                    <?php } ?>
                </span>
            </div>

        </div>
    <?php } 
    }
    
    if ( azin_opt( 'show_ffour' ) ) { 
        if ( azin_opt( 'edit_ffour' ) && empty( rwmb_meta( 'file_ffour', '', $id ) ) ) {
        //show nothing
        } else {
    ?>
        <div class="prod-row prod-attr col-12 ffour">

            <div class="attr">
                <span class="fal <?php echo azin_opt( 'ffour_icon' ); ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_opt( 'ffour' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php if ( azin_opt( 'edit_ffour' ) ) {
                        echo rwmb_meta( 'file_ffour', '', $id );
                    } else {
                        echo get_the_date( 'j F Y' ); 
                    } ?>
                </span>
            </div>

        </div>
    <?php }
    }

    if ( azin_opt( 'show_modified_date' ) ) {
        if ( azin_opt( 'edit_modified_date' ) && empty( rwmb_meta( 'file_modified_date', '', $id ) ) ) {
            //show nothing
        } else { ?>
        <div class="prod-row prod-attr col-12 azin-modified-date">

            <div class="attr">
                <span class="fal <?php echo azin_opt( 'modified_date_icon' ); ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_opt( 'modified_date_title' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                <?php if ( azin_opt( 'edit_modified_date' ) ) {
                        echo rwmb_meta( 'file_modified_date', '', $id );
                    } else {
                        echo get_the_modified_time( 'j F Y', $id );
                    }
                ?>
                </span>
            </div>
        </div>
    <?php }
    }
    
    if ( azin_opt( 'show_ffive' ) ) {
        if ( azin_opt( 'edit_ffive' ) && empty( rwmb_meta( 'file_ffive', '', $id ) ) ) {
        //show nothing
        } else {
    ?>
        <div class="prod-row prod-attr col-12 ffive">
            <?php $ffive_icon = ( ! empty ( azin_opt( 'ffive_icon' ) ) ? azin_opt( 'ffive_icon' ) : 'fa-folder-open' ); ?>
            <div class="attr">
                <span class="fal <?php echo $ffive_icon; ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_opt( 'ffive' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php
                    if ( azin_opt( 'edit_ffive' ) ) {
                        echo rwmb_meta( 'file_ffive', '', $id );
                    } else {
                        $sep = ( is_rtl() ? '، ' : ', ' );
                        if ( az_woo() ) {
                            the_terms( $id, 'product_cat', '', $sep, '' );
                        } else {
                            the_terms( $id, 'download_category', '', $sep, '' );
                        }
                    }  
                    ?>
                </span>
            </div>

        </div>
    <?php }
    }
    
    if ( azin_opt( 'show_fsix' ) ) { 
        if ( azin_opt( 'edit_fsix' ) && empty( rwmb_meta( 'file_fsix', '', $id ) ) ) {
        //show nothing
        } else {
    ?>
        <div class="prod-row prod-attr col-12 fsix">

            <div class="attr">
                <span class="fal <?php echo azin_opt( 'fsix_icon' ); ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_opt( 'fsix' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php 
                    if ( azin_opt( 'edit_fsix' ) ) {
                        echo rwmb_meta( 'file_fsix', '', $id );
                    } else {
                        echo getPostViews( $id );
                    } 
                    ?>
                </span>
            </div>

        </div>
    <?php }
    }

    if ( azin_opt( 'show_dcount' ) ) {
        if ( azin_opt( 'edit_dcount' ) && empty( rwmb_meta( 'file_dcount', '', $id ) ) ) {
            //show nothing
        } else { ?>
        <div class="prod-row prod-attr col-12 dcount">

            <div class="attr">
                <span class="fal <?php echo azin_opt( 'dcount_icon' ); ?> picon"></span>
                <span class="attr-text">
                    <?php echo azin_is_course( $id ) && ! azin_opt( 'edit_dcount' ) ? __( 'Number of students', 'azin-file' ) : azin_opt( 'dcount_title' ); ?>
                </span>
            </div>

            <div class="attr-value">
                <span>
                    <?php 
                        if ( azin_opt( 'edit_dcount' ) ) {
                            echo rwmb_meta( 'file_dcount', '', $id );
                        } else {
                            if ( az_woo() ) {
                                $count = get_post_meta( $id, 'total_sales', true );
                            } else {
                                $download = new EDD_Download( $id );
                                $count = $download->get_sales();
                            }

                            if ( azin_is_course( $id ) ) {
                                $total_count = sprintf( _n( '%s Student', '%s Students', $count, 'azin-file' ), $count );
                            } else {
                                $total_count = sprintf( _n( '%s Sale', '%s Sales', $count, 'azin-file' ), $count );
                            }

                            //$count_suffix = azin_is_course( $id ) ? __( 'Students', 'azin-file' ) : __( ' Sales', 'azin-file' );
                            echo $total_count;
                        } 
                    ?>
                </span>
            </div>
        </div>
    <?php }
    }

}

//Azinfile product price EDD
function az_product_price_edd( $id ) {
    

    if ( !rwmb_meta( 'file_coming', '', $id ) ) {
        $variable_prices = edd_has_variable_prices( $id );

        if ( !$variable_prices ) { 
    ?>
        <div class="prod-row price-row col-12">
            <div class="sprice">
                <?php
                echo p_price( $id );

                if ( azin_opt( 'show_prod_dis' ) && rwmb_meta( 'file_saleprice', '' , $id ) != '' ) { 
                    echo dis_price_prod( $id );
                } 
                ?>
            </div>
        </div>
        <?php }
    } 
}

//Azinfile add product to cart EDD
function az_add_product_edd( $id ) {

    if ( azin_is_free( $id ) && azin_opt( 'free_price_remove_buy' ) )
        return;
     ?>
    <div class="prod-add col-12">
        <div class="add-col">
            <?php 
            if ( ! rwmb_meta( 'file_coming', '', $id ) ) {

                if ( function_exists( 'edd_price' ) ) { 

                    if ( azin_is_free( $id ) && azin_opt( 'free_logged' ) && ! is_user_logged_in() ) { 
                        
                        if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                            echo '<a href="'.azin_opt( 'free_logged_link' ).'" title="'. __( 'Login', 'azin-file' ) .'">';
                        }

                        echo '<span class="free-logged">'. azin_opt( 'text_free_logged' ).'</span>';

                        if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                            echo '</a>';
                        }
                        
                    } else {
                        echo edd_get_purchase_link( $id, 'Add', 'button' ); 
                    }

                } 

            } else {

                if ( azin_opt( 'link_coming' ) && ! empty( azin_opt( 'link_coming_addr' ) ) ) {
                    echo '<a class="coming-link" href="'. azin_opt( 'link_coming_addr' ) .'" title="'.azin_opt( 'text_coming_soon' ).'" target="_blank">';
                }

                echo '<span class="coming">'. azin_opt( 'text_coming' ).'</span>';
                
                if ( azin_opt( 'link_coming' ) && ! empty( azin_opt( 'link_coming_addr' ) ) ) {
                    echo '</a>';
                }
            }
            ?>
        </div>
    </div>

    <?php
    //Product Under Buy Preview button
    if ( azin_opt( 'show_pre_prod_btn_under' ) ) {

        $file_pre_link = rwmb_meta( 'file_pre' , '',  $id );
        $file_pre_title = azin_opt( 'text_pre' );

        ?>

        <div class="col-12 prod-extra-btn-con">
            <a class="btn <?php echo azin_opt( 'pre_prod_btn_color' ); ?> prod-extra-btn" target="_blank" href="<?php echo $file_pre_link; ?>" title="<?php echo $file_pre_title; ?>">
                <i class="<?php echo azin_opt( 'pre_prod_btn_icon' ); ?>" aria-hidden="true"></i>
                <?php echo $file_pre_title; ?>
            </a>
        </div>

        <?php
    }

    //Additional product button
    azin_add_prod_btn( $id );
}

//Azinfile product price Woo
function az_product_price_woo( $id ) {
    
    global $product;

    if ( !rwmb_meta( 'file_coming', '', $id ) && $product->is_in_stock() ) { ?>
        <div class="prod-row price-row col-12">
            <div class="sprice">
                <?php
                    echo $product->get_price_html();

                    if ( azin_opt( 'show_prod_dis' ) && $product->is_on_sale() ) {
                        echo disw_price_prod( $id );
                    }
                ?>
            </div>
        </div>
    <?php 
    }
}

//Azinfile add product to cart Woo
function az_add_product_woo( $id ) {
    
    global $product;
    
    if ( azin_is_free( $id ) && azin_opt( 'free_price_remove_buy' ) )
        return;
    ?>

    <div class="prod-add col-12">
        <div class="col-12 add-col">
            <?php
            if ( ! rwmb_meta( 'file_coming', '', $id ) ) {

                if ( azin_is_free( $id ) && ! $product->is_type( 'variable' )  ) {

                    if ( azin_opt( 'free_logged' ) && !is_user_logged_in() ) {

                        if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                            echo '<a href="'.azin_opt( 'free_logged_link' ).'" title="'. __( 'Login', 'azin-file' ) .'">';
                        }

                        echo '<span class="free-logged">'. azin_opt( 'text_free_logged' ).'</span>';

                        if ( ! empty( azin_opt( 'free_logged_link' ) ) ) {
                            echo '</a>';
                        }

                    } else {
                        echo do_shortcode( '[download_now id="'. $id .'" text="'. __( 'Download', 'azin-file' ) .'"]' );
                    }

                } else {
                    woocommerce_template_single_add_to_cart();
                }

            } else {

                if ( azin_opt( 'link_coming' ) && ! empty( azin_opt( 'link_coming_addr' ) ) ) {
                    echo '<a class="coming-link" href="'. azin_opt( 'link_coming_addr' ) .'" title="'.azin_opt( 'text_coming_soon' ).'" target="_blank">';
                }

                echo '<span class="coming">'. azin_opt( 'text_coming' ).'</span>';

                if ( azin_opt( 'link_coming' ) && ! empty( azin_opt( 'link_coming_addr' ) ) ) {
                    echo '</a>';
                }
            }
            ?>
        </div>
    </div>

    <?php
    //Product Under Buy Preview button
    if ( azin_opt( 'show_pre_prod_btn_under' ) ) {

        $file_pre_link = rwmb_meta( 'file_pre' , '',  $id );
        $file_pre_title = azin_opt( 'text_pre' );

        ?>
        <?php if ( ! empty ( $file_pre_link ) && ! empty ( $file_pre_title ) ) { ?>
        <div class="col-12 prod-extra-btn-con">
            <a class="btn <?php echo azin_opt( 'pre_prod_btn_color' ); ?> prod-extra-btn" target="_blank" href="<?php echo $file_pre_link; ?>" title="<?php echo $file_pre_title; ?>">
                <i class="<?php echo azin_opt( 'pre_prod_btn_icon' ); ?>" aria-hidden="true"></i>
                <?php echo $file_pre_title; ?>
            </a>
        </div>
        <?php } ?>
        <?php
    }

    //Additional product button
    azin_add_prod_btn( $id );
}

function azin_dl_box( $id ) {
    

    if ( rwmb_meta( 'file_dbox', '', $id ) ) { ?>

        <!--DL Box-->
        <div class="dlbox">

            <div class="dltitle">
                <i class="fal fa-download"></i>
                <?php echo azin_opt( 'text_dl' ); ?>
                <?php echo rwmb_meta( 'file_fname', '', $id ); ?>
            </div>

            <?php if ( azin_opt( 'show_dl_logged' ) && !is_user_logged_in() ) {?>

            <div class="dl-login-msg">

                <?php
                    if ( !azin_opt( 'ch_login_link' ) ) {
                        $login_link = 'href="#" onclick="openLogin()"';
                    } else {
                        $login_link = 'href="' .azin_opt( 'login_link' ).'"';
                    }
                ?>
                <?php printf(__( '<a %s>Login </a>or <a %s>register </a>to view download links.', 'azin-file' ), $login_link, azin_register_link() ); ?>
            </div>

            <?php } else { ?>

            <div class="links">
                <?php 
                $urls = rwmb_meta( 'file_furl', '', $id );
                $box_type = rwmb_meta( 'file_box_type', '', $id );
                if ( ! empty( $urls ) ) {
                    if ( $box_type=='box_part' || $box_type == '' ) {
                        foreach ( $urls as $url ) {
                            $url = trim ( $url );
                            if ( filter_var( $url, FILTER_VALIDATE_URL) === FALSE) {
                                echo '<div class="plain"><i class="fal fa-link"></i>'.$url.'</div>';
                            } else {
                            $url_name = str_replace( '%20', ' ', basename( $url) );
                            $url_name = str_replace( '-', ' ', $url_name); 
                            echo '<a href="'.$url.'" title="'.$url_name.'" class="flink"><i class="fal fa-chevron-left"></i>'.$url_name.'</a>';
                            }
                        }
                    } elseif ( $box_type=='box_single' ) {
                        foreach ( $urls as $url ) {
                            $url = trim ( $url );
                            if ( filter_var( $url, FILTER_VALIDATE_URL) ) {
                                echo '<a href="'.$url.'"';
                            } else {
                            echo 'title="'.$url.'" class="flink"><i class="fal fa-chevron-left"></i>'.$url.'</a>';
                            }
                        }
                    }
                } ?>
            </div>

            <?php } ?>

            <div class="row fdet">
                <div class="col-md-4 sdet">
                    <i class="fal fa-save"></i>
                    <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title=""
                        data-original-title="<?php echo azin_opt( 'text_size' ); ?>"><?php echo rwmb_meta( 'file_fsize', '', $id ); ?></span>
                </div>
                <div class="col-md-4 sdet">
                    <i class="fal fa-lock"></i>
                    <span aria-hidden="true" data-toggle="tooltip" data-placement="top" title=""
                        data-original-title="<?php echo azin_opt( 'text_pass' ); ?>">
                        <?php echo rwmb_meta( 'file_fpass', '', $id ); ?>
                    </span>
                </div>
                <div class="col-md-4 sdet">
                    <span class="dhelp" data-toggle="modal" data-target="#dhelp">
                        <i class="fal fa-question-circle"></i>
                        <span aria-hidden="true" data-toggle="tooltip" data-placement="top"
                            title=""
                            data-original-title="<?php echo azin_opt( 'text_hdl' ); ?>"><?php echo azin_opt( 'text_hdl' ); ?></span>
                    </span>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="dhelp">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <?php echo azin_opt( 'dl_help_title' ); ?>
                            </h4>
                            <button type="button" class="close" data-dismiss="modal">
                                <i class="fal fa-times" aria-hidden="true"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <?php echo do_shortcode( azin_opt( 'dl_help_text' ) ); ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal -->

        </div>
        <!--DL Box-->

    <?php }
}

function azin_msg_help( $show_title ) {

    $product_msg_title = rwmb_meta( 'file_msg_title', '', get_the_ID() );
    $product_msg_help = rwmb_meta( 'file_msg_help', '', get_the_ID() );
    $msg_title = ( ! empty( $product_msg_help ) ? $product_msg_title : azin_opt( 'msg_title' ) );
    $msg_text = ( ! empty( $product_msg_help ) ? $product_msg_help : azin_opt( 'msg_help' ) );

    if ( $show_title ) {
    ?>
        <strong>
            <span class="fal fa-info-circle"></span>
            <?php echo $msg_title; ?>
        </strong>
    <?php
    }
    
    echo do_shortcode( $msg_text ); ?>
<?php
}

// Azin_show_related_product
function azin_show_related_product( $id ) {
    
    if ( ! azin_opt( 'show_related_p' ) )
        return;

    $related_p_by = azin_opt( 'related_p_by' );

    if ( az_woo() ) {
        $post_type = 'product';
        if ( azin_opt( 'related_p_by' ) == 'download_tag' ) {
            $related_p_by = 'product_tag';
        } else {
            $related_p_by = 'product_cat';
        }
    } else {
        $post_type = 'download';
    }
        
    $custom_taxterms = wp_get_object_terms( $id,  $related_p_by, array( 'fields' => 'ids' ) );

    $args = array(
        'post_type' => $post_type,
        'post_status' => 'publish',
        'posts_per_page' => azin_opt( 'related_p_count' ),
        'orderby' => 'rand',
        'tax_query' => array(
            array(
                'taxonomy' =>  $related_p_by,
                'field' => 'id',
                'terms' => $custom_taxterms
            )
        ),
        'post__not_in' => array( $id ),
    );

    $query = new WP_Query( $args );

    if ( $query->found_posts < 1 )
        return;

    $block_args = array(
        'block_title'      => azin_opt( 'related_p_title' ),
        //'block_title_link' => '',
        'block_icon'       => 'fal fa-shopping-bag',
        'block_itemscount' => azin_opt( 'related_pcol_count' ),
        'block_itemplay'   => false,
        'block_itemloop'   => false,
        'block_query'      => $args,
        //'block_hide'	   => false,
        'block_post_type'  => $post_type
    );

    azin_carousel_block( $block_args );

}

// Azin_show_related_product_posts
function azin_show_related_product_posts( $id ) {
    
    if ( ! azin_opt( 'show_related_product_posts' ) )
        return;

    if ( azin_opt( 'related_product_posts_by' ) == 'tag' ) {

        $tag = az_woo() ? 'product_tag' : 'download_tag';

        $related_taxterms = wp_get_object_terms( $id, $tag, array( 'fields' => 'names' ) );

        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => azin_opt( 'related_product_posts_count' ),
            'orderby' => 'rand',
            //'fields'                    => 'ids',
            'no_found_rows'             => true,
            'update_post_term_cache'    => false,
            'tax_query' => array(
                array(
                    'taxonomy' => 'post_tag',
                    'field' => 'name',
                    'terms' => $related_taxterms
                )
            ),
            'post__not_in' => array ( $id ),
        );

    } else {

        $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => azin_opt( 'related_product_posts_count' ),
            'orderby' => 'rand',
            //'fields'                    => 'ids',
            'no_found_rows'             => true,
            'update_post_term_cache'    => false,
            'post__in' => rwmb_meta( 'file_related_posts_ids', '', $id )
        );

    }

    $query = new WP_Query( $args );

    if ( $query->found_posts < 1 )
        return;

    $block_args = array(
        'block_title'      => azin_opt( 'related_product_posts_title' ),
        //'block_title_link' => '',
        'block_icon'       => 'fal fa-file-alt',
        'block_itemscount' => azin_opt( 'related_product_posts_col_count' ),
        'block_itemplay'   => false,
        'block_itemloop'   => false,
        'block_query'      => $args,
        //'block_hide'	   => false,
        'block_post_type'  => $post_type
    );

    azin_carousel_block( $block_args );

}

//Azinfile show services
function az_show_services() {
    
    if ( azin_opt( 'show_services' ) ) {
        
        $classes  = 'row ser-row azin-ser-white-bg';
		$classes .= azin_opt( 'services_icon_top' ) ? ' azin-ser-icon-top' : ' azin-ser-icon-side';
		$classes .= azin_opt( 'show_services_mobile' ) ? ' hidden-mobile' : '';
    ?>
        <!-- start services -->
        <div class="<?php echo $classes ?>">

            <div class="col-3 ser-col">
                <?php if ( ! empty( azin_opt( 'ser_one_link' ) ) ) { ?>
                    <a href="<?php echo azin_opt( 'ser_one_link' ); ?>" title="<?php echo azin_opt( 'ser_one_title' ); ?>">
                <?php } ?>
                    <div class="ser-con">
                        <div class="col-md-3 col-12 ser-icon sone">
                            <i class="<?php echo azin_opt( 'ser_one_icon' ); ?>"></i>
                        </div>
                        <div class="col-md-9 col-12 ser-det">
                            <span class="ser-title"><?php echo azin_opt( 'ser_one_title' ); ?></span>
                            <span class="ser-desc"><?php echo azin_opt( 'ser_one_des' ); ?></span>
                        </div>
                    </div>
                <?php if ( ! empty( azin_opt( 'ser_one_link' ) ) ) { ?>
                    </a>
                <?php } ?>
            </div>

            <div class="col-3 ser-col">
                <?php if ( ! empty( azin_opt( 'ser_two_link' ) ) ) { ?>
                    <a href="<?php echo azin_opt( 'ser_two_link' ); ?>" title="<?php echo azin_opt( 'ser_two_title' ); ?>">
                <?php } ?>
                    <div class="ser-con">
                        <div class="col-md-3 col-12 ser-icon stwo">
                            <i class="<?php echo azin_opt( 'ser_two_icon' ); ?>"></i>
                        </div>
                        <div class="col-md-9 col-12 ser-det">
                            <span class="ser-title"><?php echo azin_opt( 'ser_two_title' ); ?></span>
                            <span class="ser-desc"><?php echo azin_opt( 'ser_two_des' ); ?></span>
                        </div>
                    </div>
                <?php if ( ! empty( azin_opt( 'ser_two_link' ) ) ) { ?>
                    </a>
                <?php } ?>
            </div>

            <div class="col-3 ser-col">
                <?php if ( ! empty( azin_opt( 'ser_three_link' ) ) ) { ?>
                    <a href="<?php echo azin_opt( 'ser_three_link' ); ?>" title="<?php echo azin_opt( 'ser_three_title' ); ?>">
                <?php } ?>
                    <div class="ser-con">
                        <div class="col-md-3 col-12 ser-icon sthree">
                            <i class="<?php echo azin_opt( 'ser_three_icon' ); ?>"></i>
                        </div>
                        <div class="col-md-9 col-12 ser-det">
                            <span class="ser-title"><?php echo azin_opt( 'ser_three_title' ); ?></span>
                            <span class="ser-desc"><?php echo azin_opt( 'ser_three_des' ); ?></span>
                        </div>
                    </div>
                <?php if ( ! empty( azin_opt( 'ser_three_link' ) ) ) { ?>
                    </a>
                <?php } ?>
            </div>

            <div class="col-3 ser-col">
                <?php if ( ! empty( azin_opt( 'ser_four_link' ) ) ) { ?>
                    <a href="<?php echo azin_opt( 'ser_four_link' ); ?>" title="<?php echo azin_opt( 'ser_four_title' ); ?>">
                <?php } ?>
                    <div class="ser-con">
                        <div class="col-md-3 col-12 ser-icon sfour">
                            <i class="<?php echo azin_opt( 'ser_four_icon' ); ?>"></i>
                        </div>
                        <div class="col-md-9 col-12 ser-det">
                            <span class="ser-title"><?php echo azin_opt( 'ser_four_title' ); ?></span>
                            <span class="ser-desc"><?php echo azin_opt( 'ser_four_des' ); ?></span>
                        </div>
                    </div>
                <?php if ( ! empty( azin_opt( 'ser_four_link' ) ) ) { ?>
                    </a>
                <?php } ?>
            </div>

        </div>
        <!-- end services -->
<?php
    }
}

//Azinfile show ads banner one
function azin_ads_banner_one() {
    
    if ( azin_opt( 'show_ads_banner1' ) ) { ?>
        <!-- start ads banner #1 -->
        <div class="row bnr-row">
            <?php

            if ( azin_opt( 'ads_banner1_replace' ) ) {

                //Banner One
                $bnr_args = array(
                    'bnr_code'      => azin_opt( 'banner1_one_code' ),
                    'not_on_mobile' => false,
                    'custom_class'  => ' col-md-4 ads-con'
                );
    
                azin_bnr_code( $bnr_args );

                //Banner Two
                $bnr_args = array(
                    'bnr_code'      => azin_opt( 'banner1_two_code' ),
                    'not_on_mobile' => false,
                    'custom_class'  => ' col-md-4 ads-con'
                );
    
                azin_bnr_code( $bnr_args );

                //Banner Three
                $bnr_args = array(
                    'bnr_code'      => azin_opt( 'banner1_three_code' ),
                    'not_on_mobile' => false,
                    'custom_class'  => ' col-md-4 ads-con'
                );
    
                azin_bnr_code( $bnr_args );

            } else {

                //Banner One
                $banner1_one_width = ( ! empty( azin_opt( 'banner1_one', 'width' ) ) ) ? azin_opt( 'banner1_one', 'width' ) : '840';
                $banner1_one_height = ( ! empty( azin_opt( 'banner1_one', 'height' ) ) ) ? azin_opt( 'banner1_one', 'height' ) : '150';
                $hover_title = azin_opt( 'banner1_hover_title' ) ? 'yes' : 'no';
                $target = azin_opt( 'banner1_one_newtab' ) ? ' target="_blank"' : '';
                $nofollow = azin_opt( 'banner1_one_nofollow' ) ? ' rel="nofollow"' : '';
                
                $bnr_args = array(
                    'img_src' => azin_to_https( azin_opt( 'banner1_one', 'url' ) ),
                    'img_link_url' => azin_opt( 'banner1_one_link' ),
                    'img_title' => azin_opt( 'banner1_one_title' ),
                    'link_target' => $target,
                    'link_rel' => $nofollow,
                    'hover_effect' => azin_opt( 'banner1_hover_effect' ),
                    'hover_title' => $hover_title,
                    'image_width' => $banner1_one_width,
                    'image_height' => $banner1_one_height,
                    'not_on_mobile' => false,
                    'custom_class' => ' col-md-4 ads-con'
                );

                azin_bnr_image( $bnr_args );

                //Banner Two
                $banner1_two_width = ( ! empty( azin_opt( 'banner1_two', 'width' ) ) ) ? azin_opt( 'banner1_two', 'width' ) : '840';
                $banner1_two_height = ( ! empty( azin_opt( 'banner1_two', 'height' ) ) ) ? azin_opt( 'banner1_two', 'height' ) : '150';
                $hover_title = azin_opt( 'banner1_hover_title' ) ? 'yes' : 'no';
                $target = azin_opt( 'banner1_two_newtab' ) ? ' target="_blank"' : '';
                $nofollow = azin_opt( 'banner1_two_nofollow' ) ? ' rel="nofollow"' : '';
                
                $bnr_args = array(
                    'img_src' => azin_to_https( azin_opt( 'banner1_two', 'url' ) ),
                    'img_link_url' => azin_opt( 'banner1_two_link' ),
                    'img_title' => azin_opt( 'banner1_two_title' ),
                    'link_target' => $target,
                    'link_rel' => $nofollow,
                    'hover_effect' => azin_opt( 'banner1_hover_effect' ),
                    'hover_title' => $hover_title,
                    'image_width' => $banner1_two_width,
                    'image_height' => $banner1_two_height,
                    'not_on_mobile' => false,
                    'custom_class' => ' col-md-4 ads-con'
                );

                azin_bnr_image( $bnr_args );

                //Banner Three
                $banner1_three_width = ( ! empty( azin_opt( 'banner1_three', 'width' ) ) ) ? azin_opt( 'banner1_three', 'width' ) : '840';
                $banner1_three_height = ( ! empty( azin_opt( 'banner1_three', 'height' ) ) ) ? azin_opt( 'banner1_three', 'height' ) : '150';
                $hover_title = azin_opt( 'banner1_hover_title' ) ? 'yes' : 'no';
                $target = azin_opt( 'banner1_three_newtab' ) ? ' target="_blank"' : '';
                $nofollow = azin_opt( 'banner1_three_nofollow' ) ? ' rel="nofollow"' : '';
                
                $bnr_args = array(
                    'img_src' => azin_to_https( azin_opt( 'banner1_three', 'url' ) ),
                    'img_link_url' => azin_opt( 'banner1_three_link' ),
                    'img_title' => azin_opt( 'banner1_three_title' ),
                    'link_target' => $target,
                    'link_rel' => $nofollow,
                    'hover_effect' => azin_opt( 'banner1_hover_effect' ),
                    'hover_title' => $hover_title,
                    'image_width' => $banner1_three_width,
                    'image_height' => $banner1_three_height,
                    'not_on_mobile' => false,
                    'custom_class' => ' col-md-4 ads-con'
                );

                azin_bnr_image( $bnr_args );

            }
                
                ?>

        </div>
        <!-- end ads banner #1 -->
<?php 
    }
}

//Azinfile show ads banner two
function azin_ads_banner_two() {
    
    if ( azin_opt( 'show_ads_banner2' ) ) { ?>
        <!-- start ads banner #2 -->
        <div class="row bnr-row">
            <?php

            if ( azin_opt( 'ads_banner2_replace' ) ) {

                //Banner One
                $bnr_args = array(
                    'bnr_code'      => azin_opt( 'banner2_one_code' ),
                    'not_on_mobile' => false,
                    'custom_class'  => ' col-md-4 ads-con'
                );

                azin_bnr_code( $bnr_args );

                //Banner Two
                $bnr_args = array(
                    'bnr_code'      => azin_opt( 'banner2_two_code' ),
                    'not_on_mobile' => false,
                    'custom_class'  => ' col-md-4 ads-con'
                );

                azin_bnr_code( $bnr_args );

                //Banner Three
                $bnr_args = array(
                    'bnr_code'      => azin_opt( 'banner2_three_code' ),
                    'not_on_mobile' => false,
                    'custom_class'  => ' col-md-4 ads-con'
                );

                azin_bnr_code( $bnr_args );

            } else {

                //Banner One
                $banner2_one_width = ( ! empty( azin_opt( 'banner2_one', 'width' ) ) ) ? azin_opt( 'banner2_one', 'width' ) : '840';
                $banner2_one_height = ( ! empty( azin_opt( 'banner2_one', 'height' ) ) ) ? azin_opt( 'banner2_one', 'height' ) : '250';
                $hover_title = azin_opt( 'banner2_hover_title' ) ? 'yes' : 'no';
                $target = azin_opt( 'banner2_one_newtab' ) ? ' target="_blank"' : '';
                $nofollow = azin_opt( 'banner2_one_nofollow' ) ? ' rel="nofollow"' : '';
                
                $bnr_args = array(
                    'img_src' => azin_to_https( azin_opt( 'banner2_one', 'url' ) ),
                    'img_link_url' => azin_opt( 'banner2_one_link' ),
                    'img_title' => azin_opt( 'banner2_one_title' ),
                    'link_target' => $target,
                    'link_rel' => $nofollow,
                    'hover_effect' => azin_opt( 'banner2_hover_effect' ),
                    'hover_title' => $hover_title,
                    'image_width' => $banner2_one_width,
                    'image_height' => $banner2_one_height,
                    'not_on_mobile' => false,
                    'custom_class' => ' col-md-4 ads-con'
                );

                azin_bnr_image( $bnr_args );

                //Banner Two
                $banner2_two_width = ( ! empty( azin_opt( 'banner2_two', 'width' ) ) ) ? azin_opt( 'banner2_two', 'width' ) : '840';
                $banner2_two_height = ( ! empty( azin_opt( 'banner2_two', 'height' ) ) ) ? azin_opt( 'banner2_two', 'height' ) : '250';
                $hover_title = azin_opt( 'banner2_hover_title' ) ? 'yes' : 'no';
                $target = azin_opt( 'banner2_two_newtab' ) ? ' target="_blank"' : '';
                $nofollow = azin_opt( 'banner2_two_nofollow' ) ? ' rel="nofollow"' : '';
                
                $bnr_args = array(
                    'img_src' => azin_to_https( azin_opt( 'banner2_two', 'url' ) ),
                    'img_link_url' => azin_opt( 'banner2_two_link' ),
                    'img_title' => azin_opt( 'banner2_two_title' ),
                    'link_target' => $target,
                    'link_rel' => $nofollow,
                    'hover_effect' => azin_opt( 'banner2_hover_effect' ),
                    'hover_title' => $hover_title,
                    'image_width' => $banner2_two_width,
                    'image_height' => $banner2_two_height,
                    'not_on_mobile' => false,
                    'custom_class' => ' col-md-4 ads-con'
                );

                azin_bnr_image( $bnr_args );

                //Banner Three
                $banner2_three_width = ( ! empty( azin_opt( 'banner2_three', 'width' ) ) ) ? azin_opt( 'banner2_three', 'width' ) : '840';
                $banner2_three_height = ( ! empty( azin_opt( 'banner2_three', 'height' ) ) ) ? azin_opt( 'banner2_three', 'height' ) : '250';
                $hover_title = azin_opt( 'banner2_hover_title' ) ? 'yes' : 'no';
                $target = azin_opt( 'banner2_three_newtab' ) ? ' target="_blank"' : '';
                $nofollow = azin_opt( 'banner2_three_nofollow' ) ? ' rel="nofollow"' : '';
                
                $bnr_args = array(
                    'img_src' => azin_to_https( azin_opt( 'banner2_three', 'url' ) ),
                    'img_link_url' => azin_opt( 'banner2_three_link' ),
                    'img_title' => azin_opt( 'banner2_three_title' ),
                    'link_target' => $target,
                    'link_rel' => $nofollow,
                    'hover_effect' => azin_opt( 'banner2_hover_effect' ),
                    'hover_title' => $hover_title,
                    'image_width' => $banner2_three_width,
                    'image_height' => $banner2_three_height,
                    'not_on_mobile' => false,
                    'custom_class' => ' col-md-4 ads-con'
                );

                azin_bnr_image( $bnr_args );

            }

            ?>

        </div>
        <!-- end ads banner #2 -->
<?php 
    }
}

//Azinfile product content
function azin_product_content( $id ) {
     ?>
    <div class="down-con" <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="description"<?php } ?>>
        <?php if ( azin_opt( 'text_summ' ) ) { ?>
        <div class="single-text">
            <?php } ?>
            <?php the_content(); ?>
            <?php
            $defaults = array(
                'before'           => '<div class="text-center apage-break">',
                'after'            => '</div>',
                'link_before'      => '',
                'link_after'       => '',
                'next_or_number'   => 'text',
                'separator'        => ' ',
                'nextpagelink'     => '<span class="btn azin-btn">' . __( 'Next page', 'azin-file' ) . '<i aria-hidden="true" class="fal fa-angle-left"></i></span>',
                'previouspagelink' => '<span class="btn azin-btn"><i aria-hidden="true" class="fal fa-angle-right"></i>' . __( 'Prev page', 'azin-file' ) . '</span>',
                'pagelink'         => '%',
                'echo'             => 1
            );
            wp_link_pages( $defaults); ?>
        <?php if ( azin_opt( 'text_summ' ) ) { ?>
            <p class="read-more">
                <span class="sbutton">
                    <?php echo azin_opt( 'text_read_more' ); ?>
                </span>
            </p>
        </div>
        <?php } ?>
        
        <?php azin_dl_box( $id ); ?>

        <?php
        if ( azin_opt( 'show_msg_help' ) && ! azin_opt( 'product_style_two' ) && ! ( azin_is_free( $id ) && azin_opt( 'msg_help_free_not' ) ) ) { ?>
            <div class="alert <?php echo azin_opt( 'msg_help_color' ) ?> msg-help col-12">
                <?php azin_msg_help( true ); ?>
            </div>
        <?php 
        } ?>
    </div>

    <footer class="col-12">
        <?php
        if ( azin_opt( 'show_post_tags' ) && !azin_opt( 'product_style_two' ) ) {
            if ( az_woo() ) {
                the_terms( $id, 'product_tag', '<div class="col-12 p-tags"><span class="fal fa-tags"></span>'.azin_opt( 'text_tags' ), '', '</div>' );
            } else {
                the_terms( $id, 'download_tag', '<div class="col-12 p-tags"><span class="fal fa-tags"></span>'. azin_opt( 'text_tags' ) , '', '</div>' );
            }
        }
        ?>
    </footer>
<?php
}

//Edd offer Schema
function az_edd_offer_schema( $id ) {
    echo az_schema_legend( $id );
    ?>
    <span itemprop="offers" itemscope itemtype="http://schema.org/Offer">
        <meta itemprop="priceCurrency" content="IRR">
        <meta itemprop="price" content="<?php echo (int)str_replace( ',', '', edd_get_download_price( $id ) ); ?>">
        <meta itemprop="priceValidUntil" content="<?php echo date( 'Y-m-d' ); ?>">
        <link itemprop="availability" href="http://schema.org/InStock" />
        <meta itemprop="url" content="<?php the_permalink(); ?>">
    </span>
<?php
}

function az_schema_legend( $id ) {
    $post_type = get_post_type( $id);
    $title = get_the_title( $id);
    $exp = get_the_excerpt( $id);
    $url = get_permalink( $id);
    $best = 5;
    $score = get_post_meta( $id, '_kksr_ratings', true) ? get_post_meta( $id, '_kksr_ratings', true) : 0;
    $snippet = '';
    if ( $score)
    {
        $votes = get_post_meta( $id, '_kksr_casts', true) ? get_post_meta( $id, '_kksr_casts', true) : 0;
        $avg = $score ? number_format((float)( $score / $votes) , 2, '.', '' ) : 0;
        $per = $score ? number_format((float)((( $score / $votes) / 5) * 100) , 2, '.', '' ) : 0;
        $snippet .= '
        <meta itemprop="name" content="' . $title . '">
        <meta itemprop="description" content="' . $exp . '">
        <meta itemprop="url" content="' . $url . '">
        ';
        if ( $post_type != 'post' )
        {
            $snippet .= '
            <div style="display: none;" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating">
            <meta itemprop="bestRating" content="5">
            <meta itemprop="ratingValue" content="' . $avg . '">
            <meta itemprop="ratingCount" content="' . $votes . '">
            </div>
            ';
        }
    }
    return $snippet;
}

//Azinfile product archive content
function azin_product_archive_content( $id, $col ) {
    
    $prod_class = '';

    if ( az_woo() ) {
        $product     = wc_get_product( $id );
        $prod_class .= ( $product->is_type( 'variable' ) ? ' prod-is-variable' : '' );
    }

    $prod_class .= ( azin_opt( 'mobile_col' ) == 1 ? ' mobile-col-one' : '' );

    ?>

    <div role="main" class="<?php echo $col . $prod_class; ?> pcon" id="post-<?php the_ID(); ?>">
        <?php
        $video    = rwmb_meta( 'file_video', '', $id );
        $aparat   = rwmb_meta( 'file_aparat', '', $id );
        $audio    = rwmb_meta( 'file_audio', '', $id );
        $file_pre = rwmb_meta( 'file_pre_type', '', $id );
        ?>
        
        <div class="product">
            <?php
            if ( ! az_elementor_edit_mode() && azin_opt( 'show_video_thumb' ) ) {
                if ( $file_pre == 'pre_video' && ! empty ( $video ) ) { ?>
                <div class="post-img">
                    <?php 
                    $poster = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), 'single-download' )[0];
                    echo do_shortcode( '[video src="'. $video .'" preload="none" poster="'. $poster .'"]' ); 
                    az_archive_badge( $id );
                    ?>
                </div>
            <?php } elseif ( $file_pre == 'pre_aparat' && ! empty ( $aparat ) && azin_opt( 'show_aparat_thumb' ) ) { ?>
                <div class="post-img">
                   <?php echo '<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}</style><div class="h_iframe-aparat_embed_frame"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'.$aparat.'/vt/frame" title="'.get_the_title( $id ).'" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>'; ?>
                    <?php az_archive_badge( $id ); ?>
                </div>
            <?php } elseif ( $file_pre == 'pre_music' && ! empty ( $audio ) && azin_opt( 'show_audio_thumb' )  ) { ?>
                <div class="post-img">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php p_img(); ?>
                    </a>
                    <?php az_archive_badge( $id ); ?>
                    <?php echo do_shortcode( '[audio src="'.$audio.'" preload="none"]' ); ?>
                </div>
            <?php } else { ?>
                <div class="post-img">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php p_img(); ?>
                    </a> 
                    <?php az_archive_badge( $id ); ?>
                </div>  
            <?php
                }
            } else { ?>
                <div class="post-img">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php p_img(); ?>
                    </a> 
                    <?php az_archive_badge( $id ); ?>
                </div>           
            <?php } ?>

            <?php azin_quick_access( $id ); ?>

            <div class="col-12 prod-name pt-name">
                <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                    <h2 title="<?php the_title(); ?>"><?php the_title(); ?></h2>
                </a>
            </div>

            <div class="col-12 price-st-two price-container">
                <?php
                    $price = ( az_woo() ? pw_price() : p_price( $id ) );
                    echo $price;
                ?>
            </div>
            
        </div>
    </div>
<?php
}

//Azinfile product block content
function azin_product_block_content( $id ) {
    $file_pre = rwmb_meta( 'file_pre_type', '', $id );
    $video    = rwmb_meta( 'file_video', '', $id );
    $aparat   = rwmb_meta( 'file_aparat', '', $id );
    $audio    = rwmb_meta( 'file_audio', '', $id );
   
?>
    <div class="item">

        <div class="product">
            <?php
            if ( ! az_elementor_edit_mode() && azin_opt( 'show_video_thumb' ) &&  azin_opt( 'show_video_thumb_block' ) ) {
                if ( $file_pre == 'pre_video' && ! empty ( $video ) ) { ?>
                <div class="post-img">
                    <?php 
                    $poster = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), 'single-download' )[0];
                    echo do_shortcode( '[video src="'. $video .'" preload="none" poster="'. $poster .'"]' ); 
                    az_archive_badge( $id );
                    ?>
                </div>
            <?php } elseif ( $file_pre == 'pre_aparat' && ! empty ( $aparat ) && azin_opt( 'show_aparat_thumb' ) ) { ?>
                <div class="post-img">
                   <?php echo '<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}</style><div class="h_iframe-aparat_embed_frame"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'.$aparat.'/vt/frame" title="'.get_the_title( $id ).'" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>'; ?>
                    <?php az_archive_badge( $id ); ?>
                </div>
            <?php } elseif ( $file_pre == 'pre_music' && ! empty ( $audio ) && azin_opt( 'show_audio_thumb' )  ) { ?>
                <div class="post-img">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php p_img(); ?>
                    </a>
                    <?php az_archive_badge( $id ); ?>
                    <?php echo do_shortcode( '[audio src="'.$audio.'" preload="none"]' ); ?>
                </div>
            <?php } else { ?>
                <div class="post-img">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php p_img(); ?>
                    </a> 
                    <?php az_archive_badge( $id ); ?>
                </div>  
            <?php
                }
            } else { ?>
                <div class="post-img">
                    <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                        <?php p_img(); ?>
                    </a> 
                    <?php az_archive_badge( $id ); ?>
                </div>           
            <?php } ?>

            <?php azin_quick_access( $id ); ?>

            <div class="col-12 prod-name pt-name">
                <a href="<?php the_permalink() ?>" title="<?php the_title(); ?>" <?php azin_link_target() ?>>
                    <h2 title="<?php the_title(); ?>"><?php the_title(); ?></h2>
                </a>
            </div>

            <div class="col-12 price-st-two price-container">
                <?php
                    $price = ( az_woo() ? pw_price() : p_price( $id ) );
                    echo $price;
                ?>
            </div>
            
        </div>

    </div>
<?php
}

// Check elementor edit mode
function az_elementor_edit_mode() {
    $elementor_edit_mode = false;
    if (did_action( 'elementor/loaded' ) ) {
        if ( ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) || ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) ) {
            $elementor_edit_mode = true;
        }
    }
    return $elementor_edit_mode;
}

// Mobile column count
function az_mobile_col() {
    return azin_opt( 'mobile_col' );
}

// Block_styles
function az_block_style() {
    $block_style = ( azin_opt( 'block_style_two' ) ? ' m-product-st-two' : ' m-product-st-one' );
    return $block_style;
}

// Check if user purchased product
function az_check_user_purchased( $id ) {
    
    if ( az_woo() ) {

        global $product;
        if ( is_user_logged_in() && ! $product->is_type( 'variable' ) ) {
            if ( azin_opt( 'show_bought_alert' ) && wc_customer_bought_product( '', get_current_user_id(), $id ) ) {
                $alert_text = azin_is_course( $id ) && azin_opt( 'change_bought_text_course' ) ? azin_opt( 'bought_alert_text_course' ) : azin_opt( 'bought_alert_text' );
                echo '<div class="alert '. azin_opt( 'bought_alert_color' ) .' azin-bought-alert col-12">
                <i class="'. azin_opt( 'bought_alert_icon' ) .'"></i>
                '. do_shortcode( $alert_text ) .'
                </div>';
            }
        }

    } else {

        $download = new EDD_Download( $id );
        $variable_pricing = $download->has_variable_prices();
            
        if ( is_user_logged_in() && ! $variable_pricing ) {
            if ( azin_opt( 'show_bought_alert' ) && edd_has_user_purchased( get_current_user_id(), $id ) ) {
                $alert_text = azin_is_course( $id ) && azin_opt( 'change_bought_text_course' ) ? azin_opt( 'bought_alert_text_course' ) : azin_opt( 'bought_alert_text' );
                echo '<div class="alert '. azin_opt( 'bought_alert_color' ) .' azin-bought-alert col-12">
                <i class="'. azin_opt( 'bought_alert_icon' ) .'"></i>
                '. do_shortcode( $alert_text ) .'
                </div>';
            }
        }

    }

}

// azin_quick_access
function azin_quick_access( $id ) {

    if ( ! azin_opt( 'show_quick_access_btns' ) )
        return;
    ?>
        <div class="azin-quick-access">

            <?php if ( azin_opt( 'show_btn_add_cart' ) ) { ?>
                <?php azin_archive_add_to_cart( $id ); ?>
            <?php } ?>

            <?php if ( azin_opt( 'show_btn_quick_view' ) ) { ?>
                <span data-azin-product-id="<?php echo $id; ?>" class="azin-quick-view-btn btn btn-light" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Quick View', 'azin-file' ); ?>">
                    <i class="fal fa-eye" aria-hidden="true"></i>
                </span>
            <?php } ?>

            <?php
            if( azin_opt( 'show_btn_like_product' ) ) {
                if( class_exists('YITH_WCWL') ) { ?>
                    <span class="azin-like-product-btn btn btn-light" data-toggle="tooltip" data-placement="top"  title="<?php _e( 'Add to Wishlist', 'azin-file'); ?>">
                        <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist product_id="'. $id .'" icon="fa-heart" already_in_wishslist_text="" product_added_text="" label="" browse_wishlist_text=""]') ); ?>
                    </span>
                <?php } elseif( class_exists('EDD_Wish_Lists') ) { ?>
                    <span class="azin-like-product-btn btn btn-light" data-toggle="tooltip" data-placement="top"  title="<?php _e( 'Add to Wishlist', 'azin-file'); ?>">
                        <?php edd_wl_load_wish_list_link( $id ); ?>
                    </span>
                <?php } 
            } ?>

        </div>
<?php 
}

// azin_link_target
function azin_link_target() {
    $link_target = azin_opt( 'post_product_link_target') ? 'target="_blank"' : 'target="_self"';
    echo $link_target;
}

//azin_carousel_block
function azin_carousel_block( $args ) {
    
    $block_title      = isset ( $args['block_title'] ) ? $args['block_title'] : '';
    $block_title_link = isset ( $args['block_title_link'] ) ? $args['block_title_link'] : '';
    $block_view_all   = isset ( $args['block_view_all'] ) ? $args['block_view_all'] : '';
    $block_view_link  = isset ( $args['block_view_link'] ) ? $args['block_view_link'] : '';
    $block_icon       = isset ( $args['block_icon'] ) ? $args['block_icon'] : '';
    $block_icon_img   = isset ( $args['block_icon_img'] ) ? $args['block_icon_img'] : '';
    $block_itemscount = isset ( $args['block_itemscount'] ) ? $args['block_itemscount'] : '';
    $block_itemplay   = isset ( $args['block_itemplay'] ) ? $args['block_itemplay'] : '';
    $block_query      = isset ( $args['block_query'] ) ? $args['block_query'] : '';
    $block_hide       = isset ( $args['block_hide'] ) ? $args['block_hide'] : '';
    $block_post_type  = isset ( $args['block_post_type'] ) ? $args['block_post_type'] : '';

    ?>

    <div class="m-product<?php echo az_block_style(); ?>">

        <div class="post-title">

            <?php echo ( ! empty( $block_title_link ) ? '<a href="'. $block_title_link .'">' : '<div>' ) ?>

                <?php if( ! empty( $block_icon_img ) ) { ?>
                    <img src="<?php echo $block_icon_img ?>" width="32" height="32" alt="<?php echo $block_title ?>" class="cust-icon">
                <?php } elseif ( ! empty( $block_icon ) ) { ?>
                    <i class="<?php echo $block_icon ?>" aria-hidden="true"></i>
                <?php } ?>

                <?php echo $block_title; ?>
                
                <?php echo ( ! empty( $block_title_link ) ? '</a>' : '</div>' ) ?>

            <?php if ( isset ( $args['block_view_all'] ) && $block_view_all && ! empty ( $block_view_link ) ) { ?>
                <a class="morebtn" href="<?php echo $block_view_link; ?>">
                    <?php echo azin_opt( 'text_more' ); ?>
                    <i class="fal fa-chevron-left"></i>
                </a>
            <?php } elseif ( ! empty ( $block_title_link ) ) { ?>
                <a class="morebtn" href="<?php echo $block_title_link; ?>">
                    <?php echo azin_opt( 'text_more' ); ?>
                    <i class="fal fa-chevron-left"></i>
                </a>
            <?php } ?>

        </div>

        <?php
        $blockpost = new WP_Query( $block_query );
        if ( $blockpost->have_posts() ) {
        ?>
            <div class="owl-carousel" data-mobile-col="<?php echo az_mobile_col(); ?>" data-itemscount="<?php echo $block_itemscount; ?>" data-itemplay="<?php echo $block_itemplay; ?>" data-dir="<?php azin_rtl(); ?>">
                <?php
                    while ( $blockpost->have_posts() ) : $blockpost->the_post();
                        
                        if ( $block_post_type == 'download') {
                            azin_product_block_content( get_the_ID() );
                        } elseif ( $block_post_type == 'product' ) {
                            global $product;
                            if ( $product->is_visible() ) {
                                azin_product_block_content( get_the_ID() );
                            }
                        } elseif ( $block_post_type == 'post' ) {
                            azin_post_block_content( get_the_ID() );
                        }
                        
                    endwhile;
                ?>
            </div>
        <?php
        } else {
            $no_prod_class = $block_hide ? ' not-azin-hide-section' : '';
            echo '<div class="not-found'. $no_prod_class .'">';
            if ( $block_post_type == 'post' ) {
                _e( 'No posts were found with the desired conditions.', 'azin-file' );
            } else {
                _e( 'No products were found with the desired conditions.', 'azin-file' );
            }
            echo '</div>';
        }
        wp_reset_postdata();
        ?>
    </div>
    <?php
}

function azin_footer_archive_desc() {

    global $wp_query;
    
    if ( azin_opt( 'show_first_text_cat' ) && $wp_query->get( 'paged' ) > 1 )
        return;
    ?>
    <!-- start category description -->
    <div class="container-fluid main-sec">
        <div class="container">
            <?php if ( azin_opt( 'show_archive_desc_title' ) ) { ?>
                <div class="main-title">
                    <?php
                        echo ! azin_opt( 'bread_style_two' ) ? '<h1>' : '<strong>';
                        single_cat_title();
                        echo ! azin_opt( 'bread_style_two' ) ? '</h1>' : '</strong>';
                    ?>
                </div>
            <?php } ?>
            <div class="main-page<?php if ( azin_opt( 'show_archive_desc_summ' ) ) { echo ' main-page-summ'; } ?>">
            <?php the_archive_description(); ?>
            <?php if ( azin_opt( 'show_archive_desc_summ' ) ) { ?>
                <p class="read-more">
                    <span class="sbutton">
                        <?php echo azin_opt( 'text_read_more' ); ?>
                    </span>
                </p>
            <?php } ?>
            </div>
        </div>
    </div>
    <!-- end category description -->
    <?php
}

//Additional product button
function azin_add_prod_btn( $id ) {

    if ( ! azin_opt( 'show_add_prod_btn' ) )
        return;

    $product_taxonomy = ( class_exists( 'WooCommerce' ) ? 'product_cat' : 'download_category' );

    if ( azin_opt( 'add_prod_btn_in_cats' ) && ! empty ( azin_opt( 'add_prod_btn_cats' ) ) && ! has_term( azin_opt( 'add_prod_btn_cats' ), $product_taxonomy ) )
        return;

    if ( azin_opt( 'add_prod_btn_not_cats' ) && ! empty ( azin_opt( 'add_prod_btn_ncats' ) ) && has_term( azin_opt( 'add_prod_btn_ncats' ), $product_taxonomy ) )
        return;

    $add_btn_title_single = rwmb_meta( 'file_add_btn_title', '', $id );
    $add_btn_link_single = rwmb_meta( 'file_add_btn_link', '', $id );

    if ( azin_opt( 'show_add_prod_single' ) ) {
        if ( ! empty ( $add_btn_title_single ) && ! empty ( $add_btn_link_single ) ) {
    ?>
        <div class="col-12 prod-extra-btn-con">
            <a class="btn <?php echo azin_opt( 'add_prod_btn_color' ); ?> prod-extra-btn" target="_blank" href="<?php echo $add_btn_link_single; ?>" title="<?php echo $add_btn_title_single; ?>">
                <i class="<?php echo azin_opt( 'add_prod_btn_icon' ); ?>" aria-hidden="true"></i>
                <?php echo $add_btn_title_single; ?>
            </a>
        </div>
    <?php
        }
    } else {
        $add_btn_title = ( ! empty( $add_btn_title_single ) ? $add_btn_title_single : azin_opt( 'add_prod_btn_title' ) );
        $add_btn_link = ( ! empty( $add_btn_link_single ) ? $add_btn_link_single : azin_opt( 'add_prod_btn_link' ) );
    ?>
    <?php if ( ! empty ( $add_btn_title ) && ! empty ( $add_btn_link ) ) { ?>
    <div class="col-12 prod-extra-btn-con">
        <a class="btn <?php echo azin_opt( 'add_prod_btn_color' ); ?> prod-extra-btn" target="_blank" href="<?php echo $add_btn_link; ?>" title="<?php echo $add_btn_title; ?>">
            <i class="<?php echo azin_opt( 'add_prod_btn_icon' ); ?>" aria-hidden="true"></i>
            <?php echo $add_btn_title; ?>
        </a>
    </div>
    <?php } ?>
    <?php
    }
}