<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

if ( az_woo() ) {
$args = array(
    'posts_per_page' => 5,
    'post_type' => 'product',
    'post_status' => 'publish',
    'post__in' => array_merge( array( 0 ), wc_get_product_ids_on_sale() ),
    'meta_query' => array(
     'relation' => 'AND',
     array(
         'key' => 'file_spsale',
         'value' => 1,
         'compare' => '='
     )
     ),
    'order' => 'DESC'  );

    if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
        $args['meta_query'] = array(
                    'relation' => 'AND',
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock'
                    )
                );
    }
    
$specialpost = new WP_Query( $args );
?>
<div class="scon">
    <div class="spslider-con woo-special">

    <?php if ( $specialpost->have_posts() ) { ?>
        <div class="slide-progress"></div>
        <div class="spslider owl-carousel" data-itemplay="true" data-itemtime="8000" data-dir="<?php azin_rtl(); ?>">
                <?php
                while ( $specialpost->have_posts() ) : $specialpost->the_post();             
                $product = wc_get_product( get_the_ID() );
                if ( $product->is_type( 'variable' ) ) {
                    $r_price = $product->get_variation_regular_price( 'min' ). get_woocommerce_currency_symbol();
                    $s_price = $product->get_variation_sale_price( 'min' ). get_woocommerce_currency_symbol();
                } else {
                    $r_price = $product->get_regular_price(). get_woocommerce_currency_symbol();
                    $s_price = $product->get_sale_price(). get_woocommerce_currency_symbol();
                } 
                ?>

                <div class="item row">
                    
                <?php if ( azin_opt( 'square_thumb' ) ) {
                    $spimg = 'col-md-3 col-12';
                    $spdesc = 'col-md-9 col-12';
                } elseif ( !azin_opt( 'square_thumb' ) && azin_opt( 'full_width_style' ) ) {
                    $spimg = 'col-md-4 col-12';
                    $spdesc = 'col-md-8 col-12';
                } else {
                    $spimg = 'col-md-5 col-12';
                    $spdesc = 'col-md-7 col-12';
                }
                ?>

                    <div class="<?php echo $spimg; ?> sp-img">
                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                            <?php p_img(); ?>
                        </a>
                    </div>

                    <div class="<?php echo $spdesc; ?> sp-desc">
                        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                            <div class="col-12 sp-stitle">
                                <?php _e( 'Amazing offer', 'azin-file' ); ?>
                            </div>
                            <div class="col-12 sp-title">
                                <i class="fal fa-chevron-left" aria-hidden="true"></i><?php the_title(); ?>
                            </div>
                            <div class="col-12 az-text-ac">
                            <span class="sp-rprice woo-rprice">
                                <?php echo wc_price( $r_price); ?>
                            </span>
                            <span class="sp-sprice">
                                <?php echo wc_price( $s_price); ?>
                            </span>
                            </div>
                            <div class="col-12 az-text-ac">
                                <span class="sp-discount"><?php echo disw_price( get_the_ID() ); ?></span>
                            </div>
                            <div class="col-12 sp-btn">
                                <?php
                                if ( $product->is_type( 'variable' ) ) {
                                    $children_ids = $product->get_children();
                                    $date = '';
                                    foreach ( $children_ids as $children_id ) {
                                        if ( ! empty( $date ) )
                                            break;
                                        $child_date = get_post_meta( $children_id, '_sale_price_dates_to', true );
                                        if ( ! empty( $child_date ) ) {
                                            $date = $child_date;
                                        }
                                    }
                                } else {
                                    $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true );
                                }
                                if ( $date > time() ) {
                                $date += 24*60*60;
                                $sale_price_date = ( $date ) ? date( 'Y/m/d', $date ) : '';
                                $date_diff = ( $date ) ? date( 'Y-m-d', $date ) : '';
                                $now = time(); // or your date as well
                                $your_date = strtotime($date_diff);
                                $diff = $your_date - $now;
                                $datediff = round($diff / (60 * 60 * 24));  ?>
                                <div class="salecount <?php echo azin_opt( 'sale_count_style' ) ?>" data-datediff="<?php echo $datediff; ?>" data-countdown="<?php echo $sale_price_date; ?>" data-dir="<?php echo (is_rtl())?'rtl':'ltr';?>" data-seconds="<?php _e( 'Seconds' , 'azin-file'); ?>" data-minutes="<?php _e( 'Minutes' , 'azin-file'); ?>" data-hours="<?php _e( 'Hours' , 'azin-file'); ?>" data-days="<?php _e( 'Days' , 'azin-file'); ?>" data-weeks="<?php _e( 'Weeks' , 'azin-file'); ?>"></div>
                            <?php } else { ?>
                                <div class="btn azin-btn">
                                    <i class="fal fa-shopping-cart" aria-hidden="true"></i>
                                    <?php _e( 'Buy product', 'azin-file' ); ?>
                                </div>
                            <?php } ?>
                            </div>
                        </a>
                    </div>
                    <i class="fal fa-stopwatch sp-icon"></i>
                </div>

                <?php endwhile; ?>
        </div>

    <?php  } else {

        echo '<div class="not-found">';
        _e( 'No products were found with the desired conditions.', 'azin-file' );
        echo '</div>';
        }

        wp_reset_postdata();
        ?>
    </div>
</div>
<?php
} else {
    $args =  array(
        'posts_per_page' => 5,
        'post_type' => 'download',
        'post_status' => 'publish',
        'meta_key' => 'file_spsale',
        'meta_value' => 1,
        'order' => 'DESC'  );
    
    $specialpost = new WP_Query( $args );
    ?>
    <div class="scon">
        <div class="spslider-con">
            <?php if ( $specialpost->have_posts() ) { ?>
    
            <div class="slide-progress"></div>
    
            <div class="spslider owl-carousel" data-itemplay="true" data-itemtime="8000" data-dir="<?php azin_rtl(); ?>">
    
                <?php while ( $specialpost->have_posts() ) : $specialpost->the_post(); ?>
    
                    <div class="item row">
                        
                        <?php if ( azin_opt( 'square_thumb' ) ) {
                            $spimg = 'col-md-3 col-12';
                            $spdesc = 'col-md-9 col-12';
                        } elseif ( !azin_opt( 'square_thumb' ) && azin_opt( 'full_width_style' ) ) {
                            $spimg = 'col-md-4 col-12';
                            $spdesc = 'col-md-8 col-12';
                        } else {
                            $spimg = 'col-md-5 col-12';
                            $spdesc = 'col-md-7 col-12';
                        }
                        ?>
                            <div class="<?php echo $spimg; ?> sp-img">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                                    <?php p_img(); ?>
                                </a>
                            </div>
    
                            <div class="<?php echo $spdesc; ?> sp-desc">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
                                    <div class="col-12 sp-stitle">
                                        <?php _e( 'Amazing offer', 'azin-file' ); ?>
                                    </div>
    
                                    <div class="col-12 sp-title">
                                        <i class="fal fa-chevron-left" aria-hidden="true"></i><?php the_title(); ?>
                                    </div>
    
                                    <div class="col-12 az-text-ac">
                                        <span class="sp-rprice woo-rprice">
                                            <span>
                                            <?php 
                                            $saleprice = rwmb_meta( 'file_saleprice', '' , get_the_ID() );
                                            if ( !empty ( $saleprice ) ) {
                                                if ( edd_get_currency() == 'RIAL' && azin_opt( 'toman_currency' ) ) {
                                                    $saleprice = edd_currency_filter( edd_format_amount( $saleprice * 10 ) );
                                                } else {
                                                    $saleprice = edd_currency_filter( edd_format_amount( $saleprice ) );
                                                }
                                                echo '<del>'. $saleprice .'</del>';
                                            }
                                            ?>
                                            </span>
                                        </span>
                                        <span class="sp-sprice">
                                            <?php 
                                                $price = edd_price( get_the_ID(), false );
                                                $price = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i",'<$1$2>', $price);
                                                echo $price;
                                            ?>
                                        </span>
                                    </div>
                                    
                                    <?php 
                                    if ( !empty ( $saleprice ) ) { 
                                    ?>
                                    <div class="col-12 az-text-ac">
                                        <span class="sp-discount">
                                            <?php echo dis_price( get_the_ID() ); ?>
                                        </span>
                                    </div>
                                    <?php 
                                    }
                                    ?>
    
                                    <div class="col-12 sp-btn">
                                        <div class="btn azin-btn">
                                            <i class="fal fa-shopping-cart" aria-hidden="true"></i>
                                            <?php _e( 'Buy product', 'azin-file' ); ?>
                                        </div>
                                    </div>
                                </a>
    
                            </div>
                            <i class="fal fa-stopwatch sp-icon"></i>
                    </div>
    
                <?php endwhile; ?>
            </div>
    
            <?php
            } else {
                echo '<div class="not-found">';
                _e( 'No products were found with the desired conditions.', 'azin-file' );
                echo '</div>';
            }
    
            wp_reset_postdata();
            ?>
        </div>
    </div>
<?php
}