<?php

if( class_exists( 'WeDevs_Dokan' ) ) { 
    remove_action( 'woocommerce_account_dashboard', 'dokan_set_go_to_vendor_dashboard_btn' );
}

add_action( 'woocommerce_account_dashboard', 'azin_dashboard_content' );
if( ! function_exists( 'azin_dashboard_content' ) ) {
    function azin_dashboard_content() {
         ?>
        
        <ul class="azin-dashboard-stats row">
            <li class="col-lg-3 col-md-6 col-12">
                <div class="azin-dashboard-stat-con azin-dashboard-green shadow-box">
                    <i class="fal fa-shopping-cart"></i>
                    <span class="col azin-stats-con d-flex">
                        <span class="azin-dashboard-stats-count">
                            <?php echo azin_get_customer_total_order( get_current_user_id() ); ?>
                        </span>
                        <span class="azin-dashboard-stats-title">
                            <?php _e( 'Total Orders', 'azin-file' ); ?>
                        </span>
                    </span>
                </div>
            </li>

            <li class="col-lg-3 col-md-6 col-12">
                <div class="azin-dashboard-stat-con azin-dashboard-yellow shadow-box">
                    <i class="fal fa-box-check"></i>
                    <span class="col azin-stats-con d-flex">
                        <span class="azin-dashboard-stats-count">
                            <?php echo azin_get_customer_completed_order( get_current_user_id() ); ?>
                        </span>
                        <span class="azin-dashboard-stats-title">
                            <?php _e( 'Completed orders', 'azin-file' ); ?>
                        </span>
                    </span>
                </div>
            </li>

            <?php if ( class_exists( 'WooWallet' ) ) { ?>
            <li class="col-lg-3 col-md-6 col-12">
                <div class="azin-dashboard-stat-con azin-dashboard-blue shadow-box">
                    <i class="fal fa-wallet"></i>
                    <span class="col azin-stats-con d-flex">
                        <span class="azin-dashboard-stats-count">
                            <?php
                            $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                            echo $wallet; ?>
                        </span>
                        <span class="azin-dashboard-stats-title">
                            <?php _e( 'Wallet Inventory', 'azin-file' ); ?>
                        </span>
                    </span>
                </div>
            </li>
            <?php } ?>

            <li class="col-lg-3 col-md-6 col-12">
                <div class="azin-dashboard-stat-con azin-dashboard-red shadow-box">
                    <i class="fal fa-user-plus"></i>
                    <span class="col azin-stats-con d-flex">
                        <span class="azin-dashboard-stats-count">
                            <?php echo azin_register_date( get_current_user_id() ); ?>
                        </span>
                        <span class="azin-dashboard-stats-title">
                            <?php _e( 'Registration date', 'azin-file' ); ?>
                        </span>
                    </span>
                </div>
            </li>

        </ul>
        
        <?php if ( azin_opt( 'show_dashboard_message' ) ) { ?>
            <div class="row azin-dashbord-message">
                <div class="col-12">
                    
                    <?php if ( ! empty( azin_opt( 'dashboard_message_one' ) ) ) { ?>
                        <div class="woocommerce-message" role="alert">
                            <?php echo do_shortcode( azin_opt( 'dashboard_message_one' ) ) ?>
                        </div>
                    <?php } ?>

                    <?php if ( ! empty( azin_opt( 'dashboard_message_two' ) ) ) { ?>
                        <div class="woocommerce-info" role="alert">
                            <?php echo do_shortcode( azin_opt( 'dashboard_message_two' ) ) ?>
                        </div>
                    <?php } ?>

                    <?php if ( ! empty( azin_opt( 'dashboard_message_three' ) ) ) { ?>
                        <div class="woocommerce-error" role="alert">
                            <?php echo do_shortcode( azin_opt( 'dashboard_message_three' ) ) ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>

        <ul class="azin-dashbord-items row">
            <?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) :
                if ( $endpoint != 'dashboard' ) { ?>
                <li class="col-sm-3 col-6 <?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>" class="shadow-box">
                        <?php echo esc_html( $label ); ?>
                    </a>
                </li>
            <?php } 
            endforeach; ?>
        
            <?php if ( class_exists('WUPPAutoloader') ) { ?>
                <li class="col-sm-3 col-6 woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--customer-logout">
                    <a href="<?php echo wp_logout_url( home_url() ); ?>" class="shadow-box">
                        <?php _e( 'Logout', 'azin-file'); ?>
                    </a>
                </li>
            <?php } ?>
        </ul>
<?php }
}

function azin_get_customer_total_order( $id ) {
    $customer_orders = get_posts( array(
        'numberposts' => - 1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $id,
        'post_type'   => array( 'shop_order' ),
        'post_status' => array( 'wc-completed' )
    ) );

    $total = 0;
    foreach ( $customer_orders as $customer_order ) {
        $order = wc_get_order( $customer_order );
        $total += $order->get_total();
    }

    $total = wc_price( $total );

    return $total;
}

function azin_get_customer_completed_order( $id ) {
    $customer_orders = get_posts( array(
        'numberposts' => - 1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $id,
        'post_type'   => array( 'shop_order' ),
        'post_status' => array( 'wc-completed' )
    ) );

    $total = 0;
    foreach ( $customer_orders as $customer_order ) {
        $order = wc_get_order( $customer_order );
        $total += 1;
    }

    $total = $total . __( ' Order(s)', 'azin-file' );

    return $total;
}

//Set template of Woocomemrce MyAccount
add_filter( 'page_template', 'my_account_page_template' );
function my_account_page_template( $page_template ) {
    $post_id = get_the_ID();
    if ( $post_id === (int)get_option('woocommerce_myaccount_page_id' ) ) {
        $page_template = get_stylesheet_directory() . '/my-account.php'; 
    }
    return $page_template;
}

function azin_before_account_navigation() {
    $before = '<div class="row"><div class="col-lg-3 col-12 dashboard-con"><div class="dashboard-menu-con">';
    $user = wp_get_current_user(); 
    $edit_profile = get_option( 'woocommerce_myaccount_edit_account_endpoint', 'edit-account' );
    $before .= '<div class="azin-user-avatar-container">';
    $before .= '<a href="' . esc_url( azin_myaccount_link() . $edit_profile ) .'" class="azin-edit-profile" title="'. __( 'Edit Profile', 'azin-file') .'">';
	$before .= get_avatar( get_current_user_id() , 120, '', $user->display_name );
    $before .= '<i class="azin-edit-profile-icon fal fa-user-edit" aria-hidden="true"></i>';
    $before .= '</a>';
    $before .= '</div>';
    $before .='<span class="side-uname">'. $user->display_name .'</span>';
	if ( class_exists( 'WooWallet' ) )
	{
        $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
        $before .= '<span class="m-wallet">'. __( 'Wallet balance: ', 'azin-file' ) . $wallet .'</span>';
    }
    echo $before;
}
function azin_after_account_navigation() {
    echo '</div></div>';
}
add_action( 'woocommerce_before_account_navigation', 'azin_before_account_navigation' );
add_action( 'woocommerce_after_account_navigation', 'azin_after_account_navigation' );

//Add Affiliate link to my account page
if ( class_exists( 'Affiliate_WP' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'affiliate_one_more_link' );
    function affiliate_one_more_link( $menu_links ) {
        $new = array( 'affiliate-wp' => __( 'Affiliate', 'azin-file') ); 
        $menu_links = array_slice( $menu_links, 0, 5, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'affiliate_hook_endpoint', 10, 4 );
    function affiliate_hook_endpoint( $url, $endpoint, $value, $permalink ) {
        if ( $endpoint === 'affiliate-wp' ) {
            $url = esc_url( affwp_get_affiliate_area_page_url() );
        }
        return $url;
    }
}

//Add thrid custom link to my account page
if ( azin_opt( 'dashboard_link_three' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'azin_dashboard_link_three' );
    function azin_dashboard_link_three( $menu_links ) {
        
        $new = array( 'azin-dashboard-link-three' => azin_opt( 'dashboard_link_three_title' ) ); 
        $menu_links = array_slice( $menu_links, 0, 1, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'azin_dashboard_link_three_endpoint', 10, 4 );
    function azin_dashboard_link_three_endpoint( $url, $endpoint, $value, $permalink ) {
        
        if ( $endpoint === 'azin-dashboard-link-three' ) {
            $url = esc_url( azin_opt( 'dashboard_link_three_url' ) );
        }
        return $url;
    }
}

//Add second custom link to my account page
if ( azin_opt( 'dashboard_link_two' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'azin_dashboard_link_two' );
    function azin_dashboard_link_two( $menu_links ) {
        
        $new = array( 'azin-dashboard-link-two' => azin_opt( 'dashboard_link_two_title' ) ); 
        $menu_links = array_slice( $menu_links, 0, 1, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'azin_dashboard_link_two_endpoint', 10, 4 );
    function azin_dashboard_link_two_endpoint( $url, $endpoint, $value, $permalink ) {
        
        if ( $endpoint === 'azin-dashboard-link-two' ) {
            $url = esc_url( azin_opt( 'dashboard_link_two_url' ) );
        }
        return $url;
    }
}

//Add first custom link to my account page
if ( azin_opt( 'dashboard_link_one' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'azin_dashboard_link_one' );
    function azin_dashboard_link_one( $menu_links ) {
        
        $new = array( 'azin-dashboard-link-one' => azin_opt( 'dashboard_link_one_title' ) ); 
        $menu_links = array_slice( $menu_links, 0, 1, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'azin_dashboard_link_one_endpoint', 10, 4 );
    function azin_dashboard_link_one_endpoint( $url, $endpoint, $value, $permalink ) {
        
        if ( $endpoint === 'azin-dashboard-link-one' ) {
            $url = esc_url( azin_opt( 'dashboard_link_one_url' ) );
        }
        return $url;
    }
}

//Add Wishlist link to my account page
if ( class_exists('YITH_WCWL') ) {
    add_filter ( 'woocommerce_account_menu_items', 'azin_wishlist_link' );
    add_filter( 'woocommerce_get_endpoint_url', 'azin_wishlist_link_endpoint', 5, 4 );
}

function azin_wishlist_link( $menu_links ){
    $new = array( 'azin-wishlist-link' => __( 'Wishlist' , 'azin-file') ); 
    $menu_links = array_slice( $menu_links, 0, 5, true ) 
    + $new 
    + array_slice( $menu_links, 1, NULL, true );
    return $menu_links;
}

function azin_wishlist_link_endpoint( $url, $endpoint, $value, $permalink ){
    if( $endpoint === 'azin-wishlist-link' ) {
        if ( class_exists('YITH_WCWL') ) {
            $url = esc_url( YITH_WCWL()->get_wishlist_url() );
        }
    }
    return $url;
}

add_filter( 'page_template', 'azin_whishlist_page_template' );
function azin_whishlist_page_template( $page_template )
{
    global $post;
    $post_id = $post->ID;

    $whishlist_page_id = (int) get_option( 'yith_wcwl_wishlist_page_id' );

    if ( $post_id === $whishlist_page_id ) {
        $page_template = get_stylesheet_directory() . '/tpls/user-panel.php';
    }

    return $page_template;
}

//azin_user_avatar_form
add_action( 'woocommerce_before_edit_account_form', 'azin_user_avatar_form' );
function azin_user_avatar_form() {
    if ( ! azin_opt( 'change_user_avatar' ) )
        return;
    echo '<h2>'. __( 'Change profile picture', 'azin-file' ) .'</h2>';
    echo do_shortcode( '[azin-user-avatars]' );
}

add_action( 'woocommerce_edit_account_form_start', 'azin_edit_account_form_start' );
function azin_edit_account_form_start() {
    echo '<h2>'. __( 'Account details', 'azin-file' ) .'</h2>';
}