<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
   // Exit if accessed directly
   if ( ! defined( 'ABSPATH' ) )
    exit;

// Creating the widget
   class azin_add_product_widget extends WP_Widget {
   
        function __construct() {

            parent::__construct(
            
            // Base ID of your widget
            'azin_add_product_widget',
            
            // Widget name will appear in UI
            __( 'Buy product (AzinFile)', 'azin-file' ),
            
            // Widget description
            array( 'description' => __( 'Display product shopping guide and purchase link on the product page', 'azin-file' ), )
            
            );

        }
   
   // Creating widget front-end
   // This is where the action happens
   public function widget( $args, $instance ) {
    
        if ( is_singular( 'download' ) || is_singular( 'product' ) ) {
        
            $title = apply_filters( 'widget_title', $instance['title'] );
    
            // before and after widget arguments are defined by themes
    
            echo $args['before_widget'];
    
            if ( ! empty( $title ) )
    
            echo $args['before_title'] . $title . $args['after_title'];
    
            // This is where you run the code and display the output

            do_action ( 'azin_before_add_product_widget_msg' );

            echo '<div class="msg-help msg-help-widget">';
                azin_msg_help( false );
            echo '</div>';

            do_action ( 'azin_before_add_product_widget' );

            az_check_user_purchased( get_the_ID() );

            if ( az_woo() ) {

                azin_product_sale_timer( get_the_ID() );

                az_product_price_woo( get_the_ID() );

                az_add_product_woo( get_the_ID() );

            } else {

                az_product_price_edd( get_the_ID() );

                az_add_product_edd( get_the_ID() );
            }

            do_action ( 'azin_after_add_product_widget' );
    
            echo $args['after_widget'];
        }
   }
   
   // Widget Backend
   public function form( $instance ) {
   
        if ( isset( $instance[ 'title' ] ) ) {
        
            $title = $instance[ 'title' ];
        
        } else {
   
            $title = __( 'Buy product', 'azin-file' );
        }
   
   // Widget admin form
   ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <?php _e( 'This widget has no special settings and displays the purchase link and shopping guide in the theme settings section in the widgets area.', 'azin-file'); ?>
        </p>
<?php
   }
   
    
   
   // Updating widget replacing old instances with new
   public function update( $new_instance, $old_instance ) {
   
        $instance = array();
        
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        
        return $instance;
   
   }
   
   } // Class wpb_widget ends here
   
    
   
   // Register and load the widget
   function azin_add_product_load_widget() {
   
        register_widget( 'azin_add_product_widget' );
   
   }
   
   add_action( 'widgets_init', 'azin_add_product_load_widget' );   