<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
     exit;

// Creating the widget
class azin_course_progress extends WP_Widget {
   
     function __construct() {
          parent::__construct(
          // Base ID of your widget
          'azin_course_progress',
          // Widget name will appear in UI
          __( 'Course progress percentage (AzinFile)', 'azin-file' ),
          // Widget description
          array( 'description' => __( 'Display Course progress percentage on the course page', 'azin-file' ), )
          );

     }
   
     // Creating widget front-end
     // This is where the action happens
     public function widget( $args, $instance ) {
          
          if ( ( is_singular( 'download' ) || is_singular( 'product' ) ) && azin_is_course( get_the_ID() ) ) {
               
          $title = apply_filters( 'widget_title', $instance['title'] );
          $progress_color = empty( $instance['progress_color'] ) ? 'bg-info' : $instance['progress_color'];

          $course_progress = rwmb_meta( 'file_course_progress', '', get_the_ID() );

          if ( empty( $course_progress ) ) 
               return;
          
          // before and after widget arguments are defined by themes

          echo $args['before_widget'];

          if ( ! empty( $title ) )
               echo $args['before_title'] . $title . $args['after_title'];

          do_action( 'azin_before_course_progress' );
          
          ?>
               <div class="azin-course-progress-title">
                    <?php _e( 'Course progress percentage: ', 'azin-file' );
                    echo is_rtl() ? $course_progress . '٪' : $course_progress . '%'; ?>
               </div>
               <div class="azin-course-progress progress">
                    <div class="progress-bar progress-bar-striped progress-bar-animated <?php echo $progress_color; ?>" role="progressbar" style="width: <?php echo $course_progress; ?>%" aria-valuenow="<?php echo $course_progress; ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
          <?php

          do_action( 'azin_after_course_progress' );

          echo $args['after_widget'];
          }
     }
   
     // Widget Backend
     public function form( $instance ) {

          $title          = isset( $instance[ 'title' ] ) ? $instance[ 'title' ] : __( 'Course progress percentage', 'azin-file' );
          $progress_color = isset( $instance[ 'progress_color' ] ) ? $instance[ 'progress_color' ] : 'bg-info';
          // Widget admin form
          ?>
          <p>
               <?php _e( 'This widget displays Course progress percentage in the widgets area.', 'azin-file'); ?>
          </p>
          <p>
               <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
               <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
          </p>

          <label for="<?php echo $this->get_field_id( 'progress_color' ); ?>">
                <?php _e( 'Progress bar color', 'azin-file'); ?>
          </label><br />

          <select class="widefat" name="<?php echo $this->get_field_name( 'progress_color' ); ?>" id="<?php echo $this->get_field_id( 'progress_color' ); ?>">
               <option value="bg-info" <?php selected( $progress_color, 'bg-info' ); ?>>
               <?php _e( 'Blue', 'azin-file'); ?>
               </option>
               <option value="bg-warning" <?php selected( $progress_color, 'bg-warning' ); ?>>
               <?php _e( 'Yellow', 'azin-file'); ?>
               </option>
               <option value="bg-success" <?php selected( $progress_color, 'bg-success' ); ?>>
               <?php _e( 'Green', 'azin-file'); ?>
               </option>
               <option value="bg-danger" <?php selected( $progress_color, 'bg-danger' ); ?>>
               <?php _e( 'Red', 'azin-file'); ?>
               </option>
          </select>
     <?php
     }
   
     // Updating widget replacing old instances with new
     public function update( $new_instance, $old_instance ) {

          $instance = array();

          $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

          $instance['progress_color'] = strip_tags( $new_instance['progress_color'] );

          return $instance;
     }
   
} // Class wpb_widget ends here

// Register and load the widget
function azin_course_progress_load_widget() {
     register_widget( 'azin_course_progress' );
}
add_action( 'widgets_init', 'azin_course_progress_load_widget' );   