<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
     exit;

// Creating the widget
class azin_product_badges extends WP_Widget {
   
     function __construct() {
          parent::__construct(
          // Base ID of your widget
          'azin_product_badges',
          // Widget name will appear in UI
          __( 'Product badges (AzinFile)', 'azin-file' ),
          // Widget description
          array( 'description' => __( 'Display product badges on the product page', 'azin-file' ), )
          );

     }
   
     // Creating widget front-end
     // This is where the action happens
     public function widget( $args, $instance ) {
          

          if ( is_singular( 'download' ) || is_singular( 'product' ) ) {
               
          $title = apply_filters( 'widget_title', $instance['title'] );

          $product_badges = rwmb_meta( 'file_product_badges', '', get_the_ID() );

          if ( empty( azin_product_badges() ) || empty( $product_badges ) ) 
               return;
          
          // before and after widget arguments are defined by themes

          echo $args['before_widget'];

          if ( ! empty( $title ) )
               echo $args['before_title'] . $title . $args['after_title'];

          do_action( 'azin_before_product_badges' );
          
          echo '<ul class="az-product-badges '. azin_opt( 'product_badges_style' ) .'">';

          foreach ( $product_badges as $product_badge ) :
               if ( azin_opt( $product_badge ) ) {
                    $badge_title = azin_opt( $product_badge . '_title' );
                    $badge_bg    = azin_opt( $product_badge . '_bg' );
                    $badge_icon  = azin_opt( $product_badge . '_icon' );
                    $badge_image = azin_opt( $product_badge . '_image', 'url' );
               ?>
                    <li class="az-product-badge">
                         <span title="<?php echo $badge_title ?>" data-toggle="tooltip" data-placement="top" style="background-color:<?php echo $badge_bg ?>">
                              <?php if ( empty ( $badge_image ) ) { ?>
                                   <i class="<?php echo $badge_icon ?>"></i>
                              <?php } else { ?>
                                   <img src="<?php echo $badge_image ?>" alt="<?php echo $badge_title ?>" title="<?php echo $badge_title ?>" />
                              <?php } ?>
                         </span>
                    </li>
               <?php
               }
          endforeach;

          echo '</ul>';

          do_action( 'azin_after_product_badges' );

          echo $args['after_widget'];
          }
     }
   
     // Widget Backend
     public function form( $instance ) {
          if ( isset( $instance[ 'title' ] ) ) {

               $title = $instance[ 'title' ];

          } else {

               $title = __( 'Product Badges', 'azin-file' );
          }

          // Widget admin form
          ?>
          <p>
               <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
               <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
          </p>
          <p>
               <?php _e( 'This widget displays product badges in the widgets area.', 'azin-file'); ?>
          </p>
     <?php
     }
   
     // Updating widget replacing old instances with new
     public function update( $new_instance, $old_instance ) {
          $instance = array();
          $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
          return $instance;
     }
   
} // Class wpb_widget ends here

// Register and load the widget
function azin_product_badges_load_widget() {
     register_widget( 'azin_product_badges' );
}
add_action( 'widgets_init', 'azin_product_badges_load_widget' );   