<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
   // Exit if accessed directly
   if ( ! defined( 'ABSPATH' ) )
    exit;

// Creating the widget
   class azin_product_tags_widget extends WP_Widget {
   
        function __construct() {

            parent::__construct(
            
            // Base ID of your widget
            'azin_product_tags_widget',
            
            // Widget name will appear in UI
            __( 'Product Page Tags (AzinFile)', 'azin-file' ),
            
            // Widget description
            array( 'description' => __( 'Display product tags on the product page', 'azin-file' ), )
            
            );

        }
   
   // Creating widget front-end
   // This is where the action happens
   public function widget( $args, $instance ) {
    
        if ( is_singular( 'download' ) || is_singular( 'product' ) ) {
        
            $title = apply_filters( 'widget_title', $instance['title'] );
    
            // before and after widget arguments are defined by themes
    
            echo $args['before_widget'];
    
            if ( ! empty( $title ) )
    
            echo $args['before_title'] . $title . $args['after_title'];
    
            // This is where you run the code and display the  
            ?>
            <div class="product-tags-widget">
                <?php
                    if ( az_woo() ) {
                        the_terms( get_the_ID(), 'product_tag', '<div class="p-tags">', '', '</div>' );
                    } else {
                        the_terms( get_the_ID(), 'download_tag', '<div class="p-tags">', '', '</div>' );
                    }
                ?>
            </div>
            <?php
    
            echo $args['after_widget'];
        }
   }
   
   // Widget Backend
   public function form( $instance ) {
   
        if ( isset( $instance[ 'title' ] ) ) {
        
            $title = $instance[ 'title' ];
        
        } else {
   
            $title = __( 'Product tags', 'azin-file' );
        }
   
   // Widget admin form
   ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <p>
            <?php _e( 'This widget has no special settings and displays the current product tags in the widgets area.', 'azin-file'); ?>
        </p>
<?php
   }
   
    
   
   // Updating widget replacing old instances with new
   public function update( $new_instance, $old_instance ) {
   
        $instance = array();
        
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        
        return $instance;
   
   }
   
   } // Class wpb_widget ends here
   
    
   
   // Register and load the widget
   function azin_product_tags_load_widget() {
   
        register_widget( 'azin_product_tags_widget' );
   
   }
   
   add_action( 'widgets_init', 'azin_product_tags_load_widget' );   