<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
   // Exit if accessed directly
   if ( ! defined( 'ABSPATH' ) )
    exit;

// Creating the widget
   
   class fnews_widget extends WP_Widget {
   
   function __construct() {
   
   parent::__construct(
   
   // Base ID of your widget
   
   'fnews_widget',
   
    
   
   // Widget name will appear in UI
   
   __( 'Feedburner Newsletter (AzinFile)', 'azin-file' ),
   
    
   
   // Widget description
   
   array( 'description' => __( 'Subscription form to the Feedburner newsletter', 'azin-file' ), )
   
   );
   
   }
   
    
   
   // Creating widget front-end
   
   // This is where the action happens
   
   public function widget( $args, $instance ) {
   
   $title = apply_filters( 'widget_title', $instance['title'] );
   
   // before and after widget arguments are defined by themes
   
   echo $args['before_widget'];
   
   if ( ! empty( $title) ) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

   $feed_url = $instance['feed_url'];
   
   $feed_msg = $instance['feed_msg'];
   
   // This is where you run the code and display the output
   
   echo '<div class="fnews">
   <div class="news-icon"><i class="fal fa-envelope"></i></div>
   <form action="https://feedburner.google.com/fb/a/mailverify" method="post" target="popupwindow" onsubmit="window.open(\'https://feedburner.google.com/fb/a/mailverify?uri='.$feed_url.'\', \'popupwindow\', \'scrollbars=yes,width=550,height=520\' );return true" class="form-inline feed-form">
   
     <div class="form-group">
   
       <label class="sr-only" for="feedemail">'. __( 'Email', 'azin-file') .'</label>
   
       <div class="input-group">
   
       <input type="text" name="email" id="feedemail" class="form-control" placeholder="'. __( 'Your Email...', 'azin-file') .'" required="required"/>
   
       <input type="hidden" value="'.$feed_url.'" name="uri"/>
   
       <input type="hidden" name="loc" value="en_US"/>
   
       <div class="input-group-append"><button type="submit" class="btn btn-success news-btn">'. __( 'Subscribe', 'azin-file') .'</button></div>
   
       </div>
   
       </div>
   
   </form>
   
   <div class="feed-msg">'.$feed_msg.'</div>
   
   </div>';
   
   echo $args['after_widget'];
   
   }
   
    
   
   // Widget Backend
   
   public function form( $instance ) {
   
   if ( isset( $instance[ 'title' ] ) ) {
   
   $title = $instance[ 'title' ];
   
   }
   
   else {
   
   $title = __( 'Subscribe to newsletter', 'azin-file' );
   
   }
   
   if ( isset( $instance[ 'feed_url' ] ) ) {
   
   $feed_url = $instance[ 'feed_url' ];
   
   }
   
   if ( isset( $instance[ 'feed_msg' ] ) ) {
   
   $feed_msg = $instance[ 'feed_msg' ];
   
   }
   
   // Widget admin form
   
   ?>
<p>
   <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
   <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" /><br /><br />
   <label for="<?php echo $this->get_field_id( 'feed_url' ); ?>"><?php _e( 'Feedburner name: (Your username without http://feeds.feedburner.com/)', 'azin-file' ); ?></label>
   <input id="<?php echo $this->get_field_id( 'feed_url' ); ?>" name="<?php echo $this->get_field_name( 'feed_url' ); ?>" type="text" value="<?php
   if ( ! empty( $feed_url) ) {
   echo esc_attr( $feed_url);} ?>" /><br /><br />
   <label for="<?php echo $this->get_field_id( 'feed_msg' ); ?>"><?php _e( 'Message:', 'azin-file' ); ?></label>
   <textarea id="<?php echo $this->get_field_id( 'feed_msg' ); ?>" name="<?php echo $this->get_field_name( 'feed_msg' ); ?>" cols="20" rows="3"><?php if ( ! empty( $feed_msg) ) { echo esc_attr( $feed_msg);} ?></textarea>
</p>
<?php
   }
   
    
   
   // Updating widget replacing old instances with new
   
   public function update( $new_instance, $old_instance ) {
   
   $instance = array();
   
   $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
   
   $instance['feed_url'] = ( ! empty( $new_instance['feed_url'] ) ) ? strip_tags( $new_instance['feed_url'] ) : '';
   
   $instance['feed_msg'] = ( ! empty( $new_instance['feed_msg'] ) ) ? strip_tags( $new_instance['feed_msg'] ) : '';
   
   return $instance;
   
   }
   
   } // Class wpb_widget ends here
   
    
   
   // Register and load the widget
   
   function fnews_load_widget() {
   
   register_widget( 'fnews_widget' );
   
   }
   
   add_action( 'widgets_init', 'fnews_load_widget' );   