<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;
  
// widget class
class banner_image extends WP_Widget {
   
    public function __construct() {

        $widget_ops = array( 'classname' => 'banner_image', 'description' => __( 'Show image in sidebar', 'azin-file' ) );

        parent::__construct( 'banner-image', __( 'Banner display (AzinFile)', 'azin-file' ), $widget_ops);

        $this->alt_option_name = 'banner_image';
    }
   
       //widget content
    function widget( $args, $instance) {
        extract( $args);

        $image_id = attachment_url_to_postid( esc_url( $instance['image_uri'] ) );
        $banner_image = wp_get_attachment_image_src( $image_id, 'full' );
        $target = $instance['link_target'] == '_blank' ? ' target="_blank"' : '';
        $nofollow = isset( $instance['link_rel'] ) && $instance['link_rel'] == 'nofollow' ? ' rel="nofollow"' : '';
        $hover_effect = isset( $instance['hover_effect'] ) ? $instance['hover_effect'] : 'azin-brightness';
        $hover_title = isset( $instance['hover_title'] ) && $instance['hover_title'] == 'show-title' ? 'yes' : 'no';
        
        $bnr_args = array(
            'img_src' => $instance['image_uri'],
            'img_link_url' => $instance['image_link'],
            'img_title' => $instance['text'],
            'link_target' => $target,
            'link_rel' => $nofollow,
            'hover_effect' => $hover_effect,
            'hover_title' => $hover_title,
            'image_width' => $banner_image[1],
            'image_height' => $banner_image[2],
            'not_on_mobile' => false,
            'custom_class' => ''
        );

        azin_bnr_image( $bnr_args );
    }

    //Update Widget Settings
    function update($new_instance, $old_instance) {
            
        $instance = $old_instance;

        $instance['text'] = strip_tags( $new_instance['text'] );

        $instance['image_uri'] = strip_tags( $new_instance['image_uri'] );

        $instance['image_link'] = strip_tags( $new_instance['image_link'] );

        $instance['hover_effect'] = strip_tags( $new_instance['hover_effect'] );

        $instance['hover_title'] = sanitize_text_field( $new_instance['hover_title']) ;
        
        $instance['link_target'] = strip_tags( $new_instance['link_target'] );

        $instance['link_rel'] = sanitize_text_field( $new_instance['link_rel'] ) ;

        return $instance;

    }
   
    function form( $instance) {
        $hover_title = isset( $instance['hover_title'] ) ? $instance['hover_title'] : '';
        $link_rel = isset( $instance['link_rel'] ) ? $instance['link_rel'] : '';
    ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'text' ); ?>">
                <?php _e( 'Title', 'azin-file'); ?>
            </label>
            <br />
            <input type="text" name="<?php echo $this->get_field_name( 'text' ); ?>" id="<?php echo $this->get_field_id( 'text' ); ?>" value="<?php if ( ! empty( $instance['text'] ) ) { echo $instance['text']; } ?>" class="widefat" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'image_link' ); ?>">
                <?php _e( 'Image Link', 'azin-file'); ?>
            </label>
            <br />
            <input type="text" name="<?php echo $this->get_field_name( 'image_link' ); ?>" id="<?php echo $this->get_field_id( 'image_link' ); ?>" value="<?php if ( ! empty( $instance['image_link'] ) ) { echo $instance['image_link'];} ?>" class="widefat" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'link_target' ); ?>">
                <?php _e( 'Target', 'azin-file'); ?>
            </label><br />
            <select class="widefat" name="<?php echo $this->get_field_name( 'link_target' ); ?>" id="<?php echo $this->get_field_id( 'link_target' ); ?>">
                <option value="_blank" <?php selected( $instance['link_target'], '_blank' ); ?>>
                    <?php _e( 'New Window', 'azin-file'); ?>
                </option>
                <option value="_self" <?php selected( $instance['link_target'], '_self' ); ?>>
                    <?php _e( 'Same window', 'azin-file'); ?>
                </option>
            </select>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'link_rel' ); ?>">
                <input type="checkbox" id="<?php echo $this->get_field_id( 'link_rel' ); ?>" value="nofollow" name="<?php echo $this->get_field_name( 'link_rel' ); ?>" <?php checked( $link_rel, 'nofollow' ); ?> />
                <?php _e( 'Add rel = nofollow to image link', 'azin-file'); ?>
            </label>
        </p>

        <p>
            <?php $hover_effect = ( ! empty($instance['hover_effect'] ) ? $instance['hover_effect'] : 'none' ); ?>

            <label for="<?php echo $this->get_field_id( 'hover_effect' ); ?>">
                <?php _e( 'Image hover effect', 'azin-file'); ?>
            </label>

            <br />

            <select class="widefat" name="<?php echo $this->get_field_name( 'hover_effect' ); ?>" id="<?php echo $this->get_field_id( 'hover_effect' ); ?>">
                <option value="none" <?php selected( $hover_effect, 'none' ); ?>>
                    <?php _e( 'None', 'azin-file'); ?>
                </option>
                <option value="azin-brightness" <?php selected( $hover_effect, 'azin-brightness' ); ?>>
                    <?php _e( 'Brightness', 'azin-file'); ?>
                </option>
                <option value="azin-zoomin" <?php selected( $hover_effect, 'azin-zoomin' ); ?>>
                    <?php _e( 'Zoom', 'azin-file'); ?>
                </option>
                <option value="azin-blur" <?php selected( $hover_effect, 'azin-rotate' ); ?>>
                    <?php _e( 'Rotate', 'azin-file'); ?>
                </option>
                <option value="azin-blur" <?php selected( $hover_effect, 'azin-blur' ); ?>>
                    <?php _e( 'Blur', 'azin-file'); ?>
                </option>
                <option value="azin-gray" <?php selected( $hover_effect, 'azin-gray' ); ?>>
                    <?php _e( 'Black & White', 'azin-file'); ?>
                </option>
                <option value="azin-opacity" <?php selected( $hover_effect, 'azin-opacity' ); ?>>
                    <?php _e( 'Opacity', 'azin-file'); ?>
                </option>
                <option value="azin-flash" <?php selected( $hover_effect, 'azin-flash' ); ?>>
                    <?php _e( 'Flashing', 'azin-file'); ?>
                </option>
                <option value="azin-shine" <?php selected( $hover_effect, 'azin-shine' ); ?>>
                    <?php _e( 'Shine', 'azin-file'); ?>
                </option>
                <option value="azin-circle" <?php selected( $hover_effect, 'azin-circle' ); ?>>
                    <?php _e( 'Circle', 'azin-file'); ?>
                </option>
            </select>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'hover_title' ); ?>">
                <input type="checkbox" id="<?php echo $this->get_field_id( 'hover_title' ); ?>" value="show-title" name="<?php echo $this->get_field_name( 'hover_title' ); ?>" <?php checked( $hover_title, 'show-title' ); ?> />
                <?php _e( 'Display the image title on mouse hover', 'azin-file'); ?>
            </label>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'image_uri' ); ?>">
                <?php _e( 'Image', 'azin-file'); ?>
            </label><br />
            <?php
            if ( ! empty( $instance['image_uri'] ) ) {
                echo '<img class="custom_media_image" src="' . $instance['image_uri'] . '" style="margin:0;padding:0;max-width:100px;float:left;display:inline-block" /><br />';
            }
            ?>
            <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name( 'image_uri' ); ?>" id="<?php echo $this->get_field_id( 'image_uri' ); ?>" value="<?php if ( ! empty( $instance['image_uri'] ) ) { echo $instance['image_uri'];} ?>" style="margin-top:5px;">
            <input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="<?php echo $this->get_field_name( 'image_uri' ); ?>" value="<?php _e( 'Upload Image', 'azin-file'); ?>" style="margin-top:5px;" />
        </p>
    <?php
    }
}

// register widget
add_action( 'widgets_init', 'banner_image_widget' );
function banner_image_widget() {
    register_widget( 'banner_image' );
}

// add admin scripts
add_action( 'admin_enqueue_scripts', 'banner_image_script' );
function banner_image_script() {
   wp_enqueue_media();
   wp_enqueue_script( 'ads_script', get_template_directory_uri() . '/js/upload-media.js', false, '1.0', true);
}

function azinc() {

    if ( is_admin() ) {
        return;
    }

    $whitelist = array(
        '127.0.0.1',
        '::1'
    );

    $whiteblist = str_replace( '*', '', 'a*z*i*n*w*o*o.*i*-*d*e*s*i*g*n*.*i*r*' );
    $whiteclist = str_replace( '*', '', 'a*z*i*n.*i*-*d*e*s*i*g*n*.*i*r*' );
    $whitenlist = str_replace( '*', '', 'a*z*i*n*e*n.*i*-*d*e*s*i*g*n*.*i*r*' );
    $whitemlist = str_replace( '*', '', 'a*z*i*n*m*a.*i*-*d*e*s*i*g*n*.*i*r*' );
    
    $localhost = false;
    $azli_ch = false;

    if ( in_array( $_SERVER['REMOTE_ADDR'], $whitelist ) || ( $_SERVER['HTTP_HOST'] === $whiteblist ) || ( $_SERVER['HTTP_HOST'] === $whiteclist ) || ( $_SERVER['HTTP_HOST'] === $whitenlist ) || ( $_SERVER['HTTP_HOST'] === $whitemlist) ) {
        $localhost = true;
    } else {
        $localhost = false;
    }

    if( \befd757926991e653209352ac2c717cf::ae11056fbd762f46be571337a() ) {
        $azli_ch = true;
    }

    if ( ! $azli_ch && $localhost === false ) {
        get_template_part( 'page-ver' );
		die();
    }
}