<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
   exit;

// Creating the widget
class wauthor_widget extends WP_Widget {
   
   function __construct() {
   
      parent::__construct(
      
      // Base ID of your widget
      'wauthor_widget',
      
      // Widget name will appear in UI
      __( 'Seller Information (AzinFile)', 'azin-file' ),
      
      
      // Widget description
      array( 'description' => __( 'Display seller profile on products page', 'azin-file' ), )
      
      );
   
   }
   
   // Creating widget front-end
   public function widget( $args, $instance ) {
    
      if ( is_singular( array( 'download', 'product' ) ) ) {
      
         $title              = apply_filters( 'widget_title', $instance['title'] );
         $remove_author_name   = isset( $instance['remove_author_name'] ) ? $instance['remove_author_name'] : '';
         $remove_store_link    = isset( $instance['remove_store_link'] ) ? $instance['remove_store_link'] : '';
         $remove_register_date = isset( $instance['remove_register_date'] ) ? $instance['remove_register_date'] : '';
         $remove_product_count = isset( $instance['remove_product_count'] ) ? $instance['remove_product_count'] : '';
         $remove_post_count    = isset( $instance['remove_post_count'] ) ? $instance['remove_post_count'] : '';
         $remove_course_count  = isset( $instance['remove_course_count'] ) ? $instance['remove_course_count'] : '';
         
         // before and after widget arguments are defined by themes
         echo $args['before_widget'];
         
         if ( ! empty( $title ) )
            echo $args['before_title'] . $title . $args['after_title'];
      
         // This is where you run the code and display the output
         $author = get_post_field( 'post_author', get_the_ID() );
      ?>
         <div class="wauthor col-12">

            <div class="uavatar">
               <?php echo get_avatar( $author , 128, '' , get_the_author_meta( 'display_name', $author ) ); ?>
            </div>

            <div class="row">

               <?php
                if ( ! $remove_author_name ) { ?>
               <div class="col-12 author-name">
                  <?php echo get_the_author_meta( 'display_name', $author ); ?>
               </div>
               <?php } ?>

               <?php if ( ! $remove_store_link ) { ?>
               <div class="col-12 aut-btn">
                  <?php
                  if ( az_woo() ) {
                     $author_link = class_exists( 'WeDevs_Dokan' ) ? get_store_url( get_the_author_meta( 'ID' ) ) : get_author_posts_url( $author );
                  } else {
                     $author_link = get_author_posts_url( $author );
                  }
                  ?>
                  <a href="<?php echo $author_link; ?>">
                        <i class="fal fa-store"></i>
                        <?php _e( 'View Store', 'azin-file' ) ?>
                  </a>
               </div>
               <?php } ?>
            
               <div class="row author-det">

                  <?php if ( ! $remove_product_count ) { ?>
                  <div class="author-attr">
                     <?php $post_type = az_woo() ? 'product' : 'download'; ?>
                     <i class="fal fa-shopping-bag" data-toggle="tooltip" data-placement="top" title="<?php echo count_user_posts( $author , $post_type, true  ) . __( ' Product', 'azin-file' ); ?>"></i>
                  </div>
                  <?php } ?>

                  <?php if ( azin_opt( 'course_sales_activation' ) && ! $remove_course_count ) { ?>
                        <div class="author-attr">
                           <i class="fal fa-graduation-cap" data-toggle="tooltip" data-placement="top" title="<?php echo azin_count_course( $author ) . __( ' Course', 'azin-file' ); ?>"></i>
                        </div>
                  <?php } ?>

                  <?php if ( ! $remove_post_count ) { ?>
                  <div class="author-attr">
                     <i class="fal fa-file-alt" data-toggle="tooltip" data-placement="top" title="<?php echo count_user_posts( $author , "post", true  ) . __( ' Post', 'azin-file' ); ?>"></i>
                  </div>
                  <?php } ?>

                  <?php if ( ! $remove_register_date ) { ?>
                  <div class="author-attr">
                     <i class="fal fa-user-plus" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Subscribe from ', 'azin-file' ); azin_register_date( $author); ?>"></i>
                  </div>
                  <?php } ?>

               </div>
            
            </div>
            
         </div>
      <?php
      
      echo $args['after_widget'];

      }
   }
   
   
   // Widget Backend
   public function form( $instance ) {
   
      $title = isset( $instance[ 'title' ] ) ? $instance[ 'title' ] : __( 'Seller', 'azin-file' );
      $remove_author_name   = isset( $instance['remove_author_name'] ) ? $instance['remove_author_name'] : 'false';
      $remove_store_link    = isset( $instance['remove_store_link'] ) ? $instance['remove_store_link'] : 'false';
      $remove_register_date = isset( $instance['remove_register_date'] ) ? $instance['remove_register_date'] : 'false';
      $remove_product_count = isset( $instance['remove_product_count'] ) ? $instance['remove_product_count'] : 'false';
      $remove_post_count    = isset( $instance['remove_post_count'] ) ? $instance['remove_post_count'] : 'false';
      $remove_course_count  = isset( $instance['remove_course_count'] ) ? $instance['remove_course_count'] : 'false';
      
      // Widget admin form
      ?>
      <p>
         <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
         <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
      </p>

      <p>
         <label for="<?php echo $this->get_field_id( 'remove_author_name' ); ?>">
         <input type="checkbox" id="<?php echo $this->get_field_id( 'remove_author_name' ); ?>" value="true" name="<?php echo $this->get_field_name( 'remove_author_name' ); ?>" <?php checked( $remove_author_name, 'true' ); ?> />
         <?php _e( 'Remove author name', 'azin-file') ?>
         </label>
      </p>

      <p>
         <label for="<?php echo $this->get_field_id( 'remove_store_link' ); ?>">
         <input type="checkbox" id="<?php echo $this->get_field_id( 'remove_store_link' ); ?>" value="true" name="<?php echo $this->get_field_name( 'remove_store_link' ); ?>" <?php checked( $remove_store_link, 'true' ); ?> />
         <?php _e( 'Remove store link', 'azin-file') ?>
         </label>
      </p>

      <p>
         <label for="<?php echo $this->get_field_id( 'remove_product_count' ); ?>">
         <input type="checkbox" id="<?php echo $this->get_field_id( 'remove_product_count' ); ?>" value="true" name="<?php echo $this->get_field_name( 'remove_product_count' ); ?>" <?php checked( $remove_product_count, 'true' ); ?> />
         <?php _e( 'Remove number of products', 'azin-file') ?>
         </label>
      </p>

      <p>
         <label for="<?php echo $this->get_field_id( 'remove_course_count' ); ?>">
         <input type="checkbox" id="<?php echo $this->get_field_id( 'remove_course_count' ); ?>" value="true" name="<?php echo $this->get_field_name( 'remove_course_count' ); ?>" <?php checked( $remove_course_count, 'true' ); ?> />
         <?php _e( 'Remove number of courses', 'azin-file') ?>
         </label>
      </p>

      <p>
         <label for="<?php echo $this->get_field_id( 'remove_post_count' ); ?>">
         <input type="checkbox" id="<?php echo $this->get_field_id( 'remove_post_count' ); ?>" value="true" name="<?php echo $this->get_field_name( 'remove_post_count' ); ?>" <?php checked( $remove_post_count, 'true' ); ?> />
         <?php _e( 'Remove number of posts', 'azin-file') ?>
         </label>
      </p>

      <p>
         <label for="<?php echo $this->get_field_id( 'remove_register_date' ); ?>">
         <input type="checkbox" id="<?php echo $this->get_field_id( 'remove_register_date' ); ?>" value="true" name="<?php echo $this->get_field_name( 'remove_register_date' ); ?>" <?php checked( $remove_register_date, 'true' ); ?> />
         <?php _e( 'Remove registration date', 'azin-file') ?>
         </label>
      </p>
      <?php
   }
   
   // Updating widget replacing old instances with new
   public function update( $new_instance, $old_instance ) {
   
      $instance = array();
      
      $instance['title']              = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
      $instance['remove_author_name']   = sanitize_text_field( $new_instance['remove_author_name'] );
      $instance['remove_store_link']    = sanitize_text_field( $new_instance['remove_store_link'] );
      $instance['remove_register_date'] = sanitize_text_field( $new_instance['remove_register_date'] );
      $instance['remove_product_count'] = sanitize_text_field( $new_instance['remove_product_count'] );
      $instance['remove_post_count']    = sanitize_text_field( $new_instance['remove_post_count'] );
      $instance['remove_course_count']  = sanitize_text_field( $new_instance['remove_course_count'] );

      return $instance;
   
   }
   
}
   
// Register and load the widget
function wauthor_load_widget() {

   register_widget( 'wauthor_widget' );

}

add_action( 'widgets_init', 'wauthor_load_widget' );   