<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
exit;

// Creating the widget
   class azin_woo_product_attributes_widget extends WP_Widget {
   
        function __construct() {
            parent::__construct(
            // Base ID of your widget
            'azin_woo_product_attributes_widget',
            // Widget name will appear in UI
            __( 'Woocommerce Product Attributes (AzinFile)', 'azin-file' ),
            // Widget description
            array( 'description' => __( 'Display woocommerce product attributes on the product page', 'azin-file' ), )
            );

        }
   
   // Creating widget front-end
   // This is where the action happens
   public function widget( $args, $instance ) {

        if ( ! is_singular( 'product' ) )
               return;

         $title = apply_filters( 'widget_title', $instance['title'] );

         if ( ! $number = absint( $instance['number'] ) ) {
               $number = '';
         }

        $product_attributes = azin_get_product_attributes ( get_the_ID() , $number );
          
        if ( empty( $product_attributes ) )
               return;

          // before and after widget arguments are defined by themes

          echo $args['before_widget'];

          if ( ! empty( $title ) )
    
          echo $args['before_title'] . $title . $args['after_title'];

          // This is where you run the code and display the output
          echo $product_attributes;

          echo $args['after_widget'];
   }
   
   // Widget Backend
   public function form( $instance ) {

      $title   = isset( $instance[ 'title' ] ) ? $instance[ 'title' ] : __( 'Product attributes', 'azin-file' );
      $number  = isset( $instance['number'] ) ? absint( $instance['number'] ) : '';

     // Widget admin form
     ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of attributes:', 'azin-file' ); ?></label>
            <input class="tiny-text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" step="1" min="0" value="<?php echo $number; ?>" size="3" />
        </p>
     <?php
     }
   
   // Updating widget replacing old instances with new
   public function update( $new_instance, $old_instance ) {

        $instance = array();

        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['number'] = (int) $new_instance['number'];
        
        return $instance;
   }
   
   } // Class wpb_widget ends here

   // Register and load the widget
   function azin_woo_product_attributes_load_widget() {
        register_widget( 'azin_woo_product_attributes_widget' );
   }
   add_action( 'widgets_init', 'azin_woo_product_attributes_load_widget' );   