<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
   // Exit if accessed directly
   
   if ( ! defined( 'ABSPATH' ) )
    exit;

class WOO_Viewed_downloads_widget extends WP_Widget {

   	public function __construct() {
   		$widget_ops = array( 'classname' => 'woo-viewed-downloads_widget', 'description' => __( 'Display Viewed products', 'azin-file' ) );
   		parent::__construct( 'woo-viewed-downloads', __( 'Viewed products (AzinFile)', 'azin-file' ), $widget_ops);
   		$this->alt_option_name = 'woo-viewed-downloads_widget';
   	}

      function widget( $args, $instance) {

         extract( $args );
         $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? __( 'Viewed products', 'azin-file' ) : $instance['title'], $instance, $this->id_base);	

         if ( !$number = absint( $instance['number'] ) ) {
            $number = 5;
         }

         $viewed_ids = ! empty( $_COOKIE['azin_recently_viewed'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['azin_recently_viewed'] ) ) : array();
         $viewed_ids = array_reverse( array_filter( array_map( 'absint', $viewed_ids ) ) );

         if ( empty( $viewed_ids ) )
         return;

         $args = array(
            'posts_per_page' => $number,
            'no_found_rows'  => 1,
            'post_status'    => 'publish',
            'post_type'      => 'product',
            'post__in'       => $viewed_ids,
            'orderby'        => 'post__in',
         );
         
         $viewd_products = get_posts( $args );

         global $post;
         global $product;
        
        
         //save the current post
         $temp = $post;
         echo $before_widget;
         // Widget title
         echo $before_title;
         echo $instance["title"];
         echo $after_title; ?>
        <ul class="azin-list-item">
         <?php if ( $viewd_products ) {
   		foreach( $viewd_products as $post ) {
            setup_postdata( $post );
   		?>
<li class="edd-recent-post-item">
   <div class="post-image">
      <a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
         <?php if ( has_post_thumbnail() ) :  ?>
         <?php the_post_thumbnail( 'widget-img' ); ?>
         <?php else: ?>
         <img width="64" height="64" src="<?php echo esc_url( get_template_directory_uri() ); ?>/images/mthumb.png" alt="<?php the_title_attribute(); ?>" class="post-tumb"/>
         <?php endif; ?>
      </a>
   </div>
   <div class="w-details">
      <a href="<?php the_permalink(); ?>" rel="bookmark" title="<?php the_title_attribute(); ?>" <?php azin_link_target() ?>>
      <?php the_title(); ?>
      </a>
      <br />
      <span class="w-price">
         <?php $product = new WC_Product( get_the_ID() ); 
												echo $product->get_price_html(); ?>
      </span>
   </div>
</li>
<?php
   }
    $post=$temp;
   }
   else
   {
      echo azin_opt( 'text_not_found' );
   }
    wp_reset_postdata();
        echo "</ul>\n";
   echo $after_widget;
   }
   public function update( $new_instance, $old_instance ) {
   $instance = $old_instance;
   $instance['title'] = sanitize_text_field( $new_instance['title'] );
   $instance['number'] = (int) $new_instance['number'];
   return $instance;
   }
   public function form( $instance ) {
   $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
   $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
   ?>
<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'azin-file' ); ?></label>
   <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
</p>
<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:', 'azin-file' ); ?></label>
   <input class="tiny-text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="number" step="1" min="1" value="<?php echo $number; ?>" size="3" />
</p>
<?php
   }
   }
   // register WOO Viewed downloads Widget
   add_action( 'widgets_init', function() {return register_widget("WOO_Viewed_downloads_widget");} );
      