<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Order products by stock status
if( azin_opt( 'stock_order' ) )
    require_once AZ_DIR . '/includes/order-class.php';

//Remove azinfile user panel hooks
if ( ! azin_opt( 'remove_myacc_hooks' ) )
    require_once AZ_DIR . '/includes/udash.php';

//Grant access to new file for pre customers
if ( azin_opt( 'grant_download_access' ) )
    require_once AZ_DIR . '/includes/woo/azin-grant-access.php';

//Add order tracking code column to user panel orders 
if ( azin_opt( 'order_tracking_code' ) )
    require_once AZ_DIR . '/includes/woo/tracking-code.php';

//Dokan Support
if ( class_exists( 'WeDevs_Dokan' ) )
    require_once AZ_DIR . '/includes/dokan.php';

//Woo External Products Open New Tab
if ( azin_opt( 'external_new_tab' ) )
    require_once AZ_DIR . '/includes/woo/external.php';

//Add woocommerce scripts for azinfile quickview
add_action( 'wp_footer', 'azin_quick_view_scripts', 10 );
function azin_quick_view_scripts() {
    
    if ( is_admin() )
        return;

    if ( ! is_singular('product') && azin_opt( 'show_btn_quick_view' ) ) {
        wp_enqueue_script( 'wc-add-to-cart-variation' );
        if ( version_compare( WC()->version, '3.0.0', '>=' ) ) {
            wp_enqueue_script( 'wc-single-product' );
        }
    }
}

//Woocommerce product price
function pw_price() {
    global $product;
    
    if( $product->is_in_stock() ) {
        return $product->get_price_html();
    } else {
        return '<span class="prod-out-stock">'. azin_opt( 'text_not_stock' ) .'</span>';
    }
}

//Change number or products per row to 3
add_filter( 'loop_shop_columns', 'loop_columns', 999);
if ( !function_exists( 'loop_columns' ) ) {
	function loop_columns() {
		return 3; // 3 products per row
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );
function new_loop_shop_per_page( $cols ) {
  $cols = get_option( 'posts_per_page' );
  return $cols;
}

//Remove each style one by one
add_filter( 'woocommerce_enqueue_styles', 'jk_dequeue_styles' );
function jk_dequeue_styles( $enqueue_styles ) {
	unset( $enqueue_styles['woocommerce-general-rtl-css'] );
	return $enqueue_styles;
}

//Free Price
add_filter( 'woocommerce_get_price_html', 'aprice_free_zero_empty', 100, 2 );
function aprice_free_zero_empty( $price, $product ) {
    
    if (rwmb_meta( 'file_coming','', $product->get_id() ) ) {
        $price= "<span>".azin_opt( 'text_coming_soon' )."</span>";
    } else {
        if ( !$product->is_type( 'variable' ) && ( ( '' == $product->get_price() && azin_opt( 'free_price' ) ) || ( 0 == $product->get_price() && azin_opt( 'free_price' ) ) ) ) {
            $price = '<span class="woocommerce-Price-amount amount">'.azin_opt( 'text_free' ).'</span>';
        } 
    }
    return $price;
}

//Change several of the breadcrumb defaults
add_filter( 'woocommerce_breadcrumb_defaults', 'az_woocommerce_breadcrumbs' );
function az_woocommerce_breadcrumbs() {
    return array(
        'delimiter'   => '<span class="separator"> » </span>',
        'wrap_before' => '<nav class="breadcrumbs" itemprop="breadcrumb">',
        'wrap_after'  => '</nav>',
        'before'      => '',
        'after'       => '',
        'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
    );
}

//Remove the breadcrumbs 
add_action( 'init', 'woo_remove_wc_breadcrumbs' );
function woo_remove_wc_breadcrumbs() {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
}

//Add Woocommerce star rating top of the product page
function waproduct_add_star_rating( $id ) 
{   
    
    global $woocommerce;
    $product = wc_get_product( $id );
    $average = $product->get_average_rating();
    $review_count = $product->get_review_count();
    echo '<div class="star-rating"><span style="width:'.floor( ( $average / 5 ) * 100 ) . '%"></span></div>';

    if ( azin_opt( 'site_schema' ) ) {
        $StructuredData = new WC_Structured_Data();
        $StructuredData->generate_product_data( $product );
    }
}

//Show cart contents / total Ajax
add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
    
	ob_start();
    $cart_count = WC()->cart->get_cart_contents_count();
	?>
    <span class="edd-cart-quantity">
        <?php echo $cart_count; ?>
    </span>
	<?php
	$fragments['span.edd-cart-quantity'] = ob_get_clean();
	return $fragments;
}

//Total Sales of woocommerce products
function az_woo_get_total_sales() {
    $total_orders = wc_orders_count( 'completed' );
    return $total_orders;
}

//Total Sales of woocommerce products
function az_woo_get_total_purchased_products() {
    global $wpdb;
  
    $result = $wpdb->get_row("
        SELECT SUM(pm.meta_value) AS total_sales
        FROM $wpdb->posts AS p
        LEFT JOIN $wpdb->postmeta AS pm ON (p.ID = pm.post_id AND pm.meta_key = 'total_sales') 
        WHERE p.post_type = 'product'
    ");
  
    return $result->total_sales;
}

//Woo dis price
function disw_price ( $id) {
    $product = wc_get_product( $id );
    if ( $product->is_type( 'variable' ) ) {
        $r_price = $product->get_variation_regular_price( 'min' );
        $s_price = $product->get_variation_sale_price( 'min' );
        if ( $r_price == $s_price) {
            $r_price = $product->get_variation_regular_price( 'max' );
            $s_price = $product->get_variation_sale_price( 'max' );
        }
    } else {
        $r_price = $product->get_regular_price();
        $s_price = $product->get_sale_price();
    }
    $d_price = (int)$r_price - (int)$s_price;
    $t_price = round(( $d_price/$r_price)*100);

    if(is_rtl()) {
        $t_price ='<span>٪'. $t_price . __( ' Discount', 'azin-file').'</span>';
    } else {
        $t_price ='<span>'. $t_price . '%' . __( ' Discount', 'azin-file').'</span>';
    }
 
    return $t_price;
}

//Woo dis price product
function disw_price_prod ( $id ) {

    if ( ! azin_opt( 'show_prod_dis' ) )
        return;

    $product = wc_get_product( $id );
    if ( $product->is_type( 'variable' ) ) {
        $r_price = $product->get_variation_regular_price( 'min' );
        $s_price = $product->get_variation_sale_price( 'min' );
        if ( $r_price == $s_price) {
            $r_price = $product->get_variation_regular_price( 'max' );
            $s_price = $product->get_variation_sale_price( 'max' );
        }
    } else {
        $r_price = $product->get_regular_price();
        $s_price = $product->get_sale_price();
    }
    $d_price = (int)$r_price - (int)$s_price;
    $t_price = round(( $d_price/$r_price)*100);

    if( is_rtl() ) {
        $t_price = '<span class="prod-dis">٪'. $t_price . __( ' Discount', 'azin-file').'</span>';
    } else {
        $t_price = '<span class="prod-dis">'. $t_price . '%' . __( ' Discount', 'azin-file').'</span>';
    }
 
    return $t_price;   
}

//Woo dis price product
function dis_price_archive ( $id ) {

    $product = wc_get_product( $id );

    if ( ! azin_opt( 'show_archive_dis' ) || ! $product->is_on_sale() )
        return;
    
    if ( $product->is_type( 'variable' ) ) {
        $r_price = $product->get_variation_regular_price( 'min' );
        $s_price = $product->get_variation_sale_price( 'min' );
        if ( $r_price == $s_price) {
            $r_price = $product->get_variation_regular_price( 'max' );
            $s_price = $product->get_variation_sale_price( 'max' );
        }
    } else {
        $r_price = $product->get_regular_price();
        $s_price = $product->get_sale_price();
    }
    $d_price = (int)$r_price - (int)$s_price;
    $t_price = round(( $d_price/$r_price)*100);

    if( is_rtl() ) {
        $t_price = '٪'. $t_price;
    } else {
        $t_price = $t_price . '%';
    }

    return $t_price;
}

//Check product is free
function azin_woo_free( $id ) {
    $product = wc_get_product( $id );
    if ( '' === $product->get_price() || 0 == $product->get_price() && defined( 'SOMDN_PATH' ) ) {
        return true;
    } else {
        return false;
    }
}

//Get myaccount_page_url
function get_myaccount_link() {
    $myaccount_page_url = '';
    $myaccount_page = (int)get_option( 'woocommerce_myaccount_page_id' );

    if ( $myaccount_page ) {
        $myaccount_page_url = get_permalink( $myaccount_page );
    }

    return $myaccount_page_url;
}

//Add WooCommerce the_excerpt before the_content
add_filter( 'the_content', 'azin_before_woo_content' );
function azin_before_woo_content( $content) {
    global $post;
    if ( is_product() && ! empty( $post->post_excerpt) )
    {
        $beforecontent = '<blockquote class="prod-excerpt blockquote">';
        $beforecontent .= '<i class="fal fa-pen-square" aria-hidden="true"></i>';
        $beforecontent .= $post->post_excerpt;
        $beforecontent .= '</blockquote>';
        $content = $beforecontent . $content;
        return $content;
    } else {
        return $content;
    }
}

//Adds extra post classes for products
function az_product_classes( $product_id ) {

    $product = wc_get_product( $product_id );
    
	$classes[] = $product->get_stock_status();
    
    $classes[] = azin_opt( 'product_style_two' ) ? 'main-product-style-two' : 'main-product-style-one';
    
	if ( $product->is_on_sale() ) {
		$classes[] = 'sale';
	}
	if ( $product->is_featured() ) {
		$classes[] = 'featured';
	}
	if ( $product->is_downloadable() ) {
		$classes[] = 'downloadable';
	}
	if ( $product->is_virtual() ) {
		$classes[] = 'virtual';
	}
	if ( $product->is_sold_individually() ) {
		$classes[] = 'sold-individually';
	}
	if ( $product->is_taxable() ) {
		$classes[] = 'taxable';
	}
	if ( $product->is_shipping_taxable() ) {
		$classes[] = 'shipping-taxable';
	}
	if ( $product->is_purchasable() ) {
		$classes[] = 'purchasable';
	}
	if ( $product->get_type() ) {
		$classes[] = 'product-type-' . $product->get_type();
	}
	if ( $product->is_type( 'variable' ) && $product->get_default_attributes() ) {
		$classes[] = 'has-default-attributes';
    }
    if ( $product->is_type( 'variable' ) ) {
		$classes[] = 'product-type-variable';
    }
    if ( azin_is_course( $product_id ) ) {
		$classes[] = 'product-type-course';
    }
    if ( azin_opt( 'remove_price_range') && azin_opt( 'remove_dub_price_range') ){
        $classes[] = remove_dub_price_range( $product );
    }
    
	return $classes;
}

//azin_woo_before_order_con
if ( azin_opt( 'remove_product_order' ) ) {
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
} else {
    add_action( 'woocommerce_before_shop_loop', 'azin_woo_before_order_con', 19 );
    add_action( 'woocommerce_before_shop_loop', 'azin_woo_after_order', 35 );
}

function azin_woo_before_order_con() {  ?>

    <div class="col-12 woocommerce-ordering-con">

    <i class="fal fa-sort-amount-up-alt sort-icon" aria-hidden="true"></i>
    
    <ul class="azin-order-products">
    <?php
    if( isset( $_GET['orderby'] ) ) {
        $orderby = $_GET['orderby'];
    } elseif( is_search() ) {
        $orderby = 'relevance';
    } else {
        $orderby = get_option( 'woocommerce_default_catalog_orderby' );
    }
    ?>

    <?php if ( is_search() ) { ?>
    <li class="order-item<?php echo ( $orderby == 'relevance' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'relevance' ); ?>">
            <?php _e( 'Relevance' , 'azin-file'); ?>
        </a>
    </li>
    <?php } elseif ( $orderby == 'menu_order' || $orderby == '' ) { ?>
    <li class="order-item<?php echo ( $orderby == 'menu_order' || $orderby == '' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'menu_order' ); ?>">
            <?php _e( 'Default' , 'azin-file'); ?>
        </a>
    </li>
    <?php } ?>

    <li class="order-item<?php echo ( $orderby == 'date' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'date' ); ?>">
            <?php _e( 'Latest' , 'azin-file'); ?>
        </a>
    </li>

    <li class="order-item<?php echo ( $orderby == 'rating' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'rating' ); ?>">
            <?php _e( 'Rating' , 'azin-file'); ?>
        </a>
    </li>

    <li class="order-item<?php echo ( $orderby == 'popularity' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'popularity' ); ?>">
            <?php _e( 'Popularity' , 'azin-file'); ?>
        </a>
    </li>

    <li class="order-item<?php echo ( $orderby == 'price' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'price' ); ?>">
            <?php _e( 'Low Price' , 'azin-file'); ?>
        </a>
    </li>

    <li class="order-item<?php echo ( $orderby == 'price-desc' ? ' is-active' : '' ); ?>">
        <a rel="nofollow" href="<?php echo azin_order_get_link( 'price-desc' ); ?>">
            <?php _e( 'High Price' , 'azin-file'); ?>
        </a>
    </li>

    </ul>
<?php }

//Azin order get link
function azin_order_get_link( $order_type ) {
    $base_link = azin_shop_page_link( true );
    $link = remove_query_arg( 'orderby', $base_link );

    if( $order_type != 'menu_order' ) {
        $link = add_query_arg( 'orderby', $order_type, $link );
        $link = str_replace( '%2C', ',', $link );
    }

    return $link;
}

//azin_woo_after_order
function azin_woo_after_order() { ?>
</div>
<?php }

//azin Get base shop page link
if ( ! function_exists( 'azin_shop_page_link' ) ) {
	function azin_shop_page_link( $keep_query = false, $taxonomy = '' ) {
		// Base Link decided by current page
		$link = '';
        
		if ( class_exists( 'Automattic\Jetpack\Constants' ) && Automattic\Jetpack\Constants::is_defined( 'SHOP_IS_ON_FRONT' ) ) {
			$link = home_url();
		} elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) || is_shop() ) {
			$link = get_permalink( wc_get_page_id( 'shop' ) );
		} elseif ( is_product_category() ) {
			$link = get_term_link( get_query_var( 'product_cat' ), 'product_cat' );
		} elseif ( is_product_tag() ) {
			$link = get_term_link( get_query_var( 'product_tag' ), 'product_tag' );
		} elseif ( get_queried_object() ) {
			$queried_object = get_queried_object();

			if ( property_exists( $queried_object, 'taxonomy' ) ) {
				$link = get_term_link( $queried_object->slug, $queried_object->taxonomy );
			}
		}

		if ( $keep_query ) {

			// Min/Max
			if ( isset( $_GET['min_price'] ) ) {
				$link = add_query_arg( 'min_price', wc_clean( $_GET['min_price'] ), $link );
			}

			if ( isset( $_GET['max_price'] ) ) {
				$link = add_query_arg( 'max_price', wc_clean( $_GET['max_price'] ), $link );
			}

			// Orderby
			if ( isset( $_GET['orderby'] ) ) {
				$link = add_query_arg( 'orderby', wc_clean( $_GET['orderby'] ), $link );
			}

			if ( isset( $_GET['stock_status'] ) ) {
				$link = add_query_arg( 'stock_status', wc_clean( $_GET['stock_status'] ), $link );
			}

            if ( isset( $_GET['product_brand'] ) ) {
				$link = add_query_arg( 'product_brand', wc_clean( $_GET['product_brand'] ), $link );
			}

			if ( isset( $_GET['per_row'] ) ) {
				$link = add_query_arg( 'per_row', wc_clean( $_GET['per_row'] ), $link );
			}

			if ( isset( $_GET['per_page'] ) ) {
				$link = add_query_arg( 'per_page', wc_clean( $_GET['per_page'] ), $link );
			}

			if ( isset( $_GET['shop_view'] ) ) {
				$link = add_query_arg( 'shop_view', wc_clean( $_GET['shop_view'] ), $link );
			}

			if ( isset( $_GET['shortcode'] ) ) {
				$link = add_query_arg( 'shortcode', wc_clean( $_GET['shortcode'] ), $link );
			}

			/**
			 * Search Arg.
			 * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
			 */
			if ( get_search_query() ) {
				$link = add_query_arg( 's', rawurlencode( wp_specialchars_decode( get_search_query() ) ), $link );
			}

			// Post Type Arg
			if ( isset( $_GET['post_type'] ) ) {
				$link = add_query_arg( 'post_type', wc_clean( wp_unslash( $_GET['post_type'] ) ), $link );

				// Prevent post type and page id when pretty permalinks are disabled.
				if ( is_shop() ) {
					$link = remove_query_arg( 'page_id', $link );
				}
			}

			// Min Rating Arg
			if ( isset( $_GET['min_rating'] ) ) {
				$link = add_query_arg( 'min_rating', wc_clean( $_GET['min_rating'] ), $link );
			}

			// All current filters
			if ( $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes() ) {
				foreach ( $_chosen_attributes as $name => $data ) {
					if ( $name === $taxonomy ) {
						continue;
					}
					$filter_name = sanitize_title( str_replace( 'pa_', '', $name ) );
					if ( ! empty( $data['terms'] ) ) {
						$link = add_query_arg( 'filter_' . $filter_name, implode( ',', $data['terms'] ), $link );
					}
					if ( 'or' == $data['query_type'] ) {
						$link = add_query_arg( 'query_type_' . $filter_name, 'or', $link );
					}
				}
			}
		}

		$link = apply_filters( 'azin_shop_page_link', $link, $keep_query, $taxonomy );

		if ( is_string( $link ) ) {
			return $link;
		} else {
			return '';
		}
	}
}

//WooCommerce Show Product Image at Checkout Page
add_filter( 'woocommerce_cart_item_name', 'azin_product_image_on_checkout', 10, 3 );
function azin_product_image_on_checkout( $name, $cart_item, $cart_item_key ) {
    /* Return if not checkout page */
    if ( ! is_checkout() ) {
        return $name;
    }
    /* Get product object */
    $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
    /* Get product thumbnail */
    $thumbnail = $_product->get_image('thumbnail');
    $image = '<div class="azin-ch-product-image">'
                . $thumbnail .
            '</div>'; 
    /* Prepend image to name and return it */
    return $image . $name;
}

//azin before cart
add_action('woocommerce_before_cart', 'azin_before_cart');
function azin_before_cart() {
    echo '<div class="azin-cart-content-wrapper row">';
}

//azin after cart
add_action('woocommerce_after_cart', 'azin_after_cart');
function azin_after_cart() {  
    echo '</div>';
}

//azin empty cart
add_action('woocommerce_cart_is_empty', 'azin_empty_cart');
function azin_empty_cart() { ?>
    <div class="azin-empty-cart">
        <i class="fal fa-shopping-cart empty-cart-icon" aria-hidden="true"></i>
        <div class="azin-empty-cart-text">
            <?php _e( 'Before proceed to checkout you must add some products to your shopping cart.', 'azin-file'); ?>
            <br>
            <?php _e( 'You will find a lot of interesting products on our "Shop" page.', 'azin-file'); ?>
        </div>
    </div>
<?php }

//Remove address item from woo menu
if( azin_opt( 'remove_address' ) ) {
    add_filter( 'woocommerce_account_menu_items', 'az_remove_my_account_address_items' );
}
function az_remove_my_account_address_items( $items ) {
    unset( $items['edit-address'] );
    return $items;
}

if ( azin_opt( 'remove_extra_fields' ) ) {
    add_filter( 'woocommerce_checkout_fields', 'azin_remove_extra_field_physical' );
}
function azin_remove_extra_field_physical( $fields ) {

    if ( ! WC()->cart->needs_shipping() ) {
        unset( $fields['billing']['billing_address_1'] );
        unset( $fields['billing']['billing_address_2'] );
        unset( $fields['billing']['billing_company'] );
        unset( $fields['billing']['billing_city'] );
        unset( $fields['billing']['billing_postcode'] );
        unset( $fields['billing']['billing_country'] );
        unset( $fields['billing']['billing_state'] );

        add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );
    }

    return $fields;
}

//Price settings for wooCommerce variable products
add_filter( 'woocommerce_variable_price_html', 'azin_variable_product_price', 10, 2 );
function azin_variable_product_price( $price, $product ) {
    if( ! azin_opt( 'remove_price_range' ) )
        return $price;

        // Product Price
        $prod_prices = array( $product->get_variation_price( 'min', true ), 
        $product->get_variation_price( 'max', true ) );

        if( azin_opt( 'show_max_price' ) || $prod_prices[0] == 0 ) {
            $prod_price = $prod_prices[0] !== $prod_prices[1] ? $prod_prices[1] : $prod_prices[1];
        } else {
            $prod_price = $prod_prices[0] !== $prod_prices[1] ? $prod_prices[0] : $prod_prices[0];
        }

        // Regular Price
        $regular_prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
        sort( $regular_prices );

        if( azin_opt( 'show_max_price' ) || $regular_prices[0] == 0 ) {
            $regular_price = $regular_prices[0] !== $regular_prices[1] ? $regular_prices[1] : $regular_prices[1];
        } else {
            $regular_price = $regular_prices[0] !== $regular_prices[1] ? $regular_prices[0] : $regular_prices[0];
        }

        if ( $prod_price !== $regular_price ) {
            $prod_price = wc_format_sale_price( wc_price( $regular_price ), wc_price( $prod_price ) );
        } else {
            $prod_price = wc_price( $regular_price );
        }

        return $prod_price;

}

//Remove wallet checkout styles
add_action( 'wp_enqueue_scripts', 'remove_wallet_stylesheet', 22 );
function remove_wallet_stylesheet() {
    if ( ! class_exists( 'WooCommerce' ) ) 
        return;
    if( is_checkout() ) {
        wp_deregister_script('jquery-ui-tooltip');
        wp_dequeue_script('jquery-ui-tooltip');
        wp_deregister_style('woo-wallet-payment-jquery-ui');
        wp_dequeue_style('woo-wallet-payment-jquery-ui');
    }
}

//Ajax add to cart on archives
function azin_add_to_cart( $product ) {

    if ( ! azin_opt( 'show_hover_btns' ) ) 
        return;

    $coming = get_post_meta( $product->get_id(), 'azin_coming', true );

    if( ! $product->is_purchasable() || ! $product->is_in_stock() || $coming || ( ! $product->is_type( 'variable' ) && azin_opt( 'show_zero_call' ) && ('' === $product->get_price() || 0 == $product->get_price() ) ) ) { ?>
        <a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy<?php if( azin_opt( 'show_hover_btns_fixed' ) ) { echo ' btn-buy-fixed'; } if( azin_opt( 'hover_btns_fixed_mobile' ) ) { echo ' btn-buy-fixed-mobile'; } ?> button" <?php azin_link_target() ?>>
            <i class="fal fa-eye" aria-hidden="true"></i>
            <?php 
            if ( azin_is_course( $product->get_id() ) ) {
                _e( 'View Product', 'azin-file' );
            } else {
                _e( 'View Course', 'azin-file' );
            }
            ?>
	    </a>
    <?php

    } elseif ( azin_opt( 'show_count_archive' ) && ( get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' ) && ( $product->is_type( 'simple' ) ) ) {
        azin_archive_add_cart();
    }
}

//azin_custom_product_tab_one
if ( azin_opt( 'custom_product_tab_one' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_custom_product_tab_one' );
}
function azin_custom_product_tab_one( $tab ) {
    
    $tab_title = rwmb_meta ( 'file_tab_one_title', '', get_the_ID() );

    if( empty( $tab_title ) )
        return $tab;
    
    $tab_icon = rwmb_meta ( 'file_tab_one_icon', '', get_the_ID() );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_custom_tab_one'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_custom_product_tab_content_one'
    );

    return $tab;
}
    
function azin_custom_product_tab_content_one() {

    $tab_content = '';

    /*if ( azin_opt( 'product_tab_scroll' ) ) {
        $tab_title = rwmb_meta ( 'file_tab_one_title', '', get_the_ID() );
        $tab_content .= '<h2>'. $tab_title .'</h2>';
    }*/

    $content = rwmb_meta ( 'file_tab_one_content', '', get_the_ID() );

    $tab_content .= azin_output_content( $content );

    echo $tab_content;
}

//azin_custom_product_tab_two
if ( azin_opt( 'custom_product_tab_two' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_custom_product_tab_two' );
}
function azin_custom_product_tab_two( $tab ) {
    
    $tab_title = rwmb_meta ( 'file_tab_two_title', '', get_the_ID() );

    if( empty( $tab_title ) )
        return $tab;
    
    $tab_icon = rwmb_meta ( 'file_tab_two_icon', '', get_the_ID() );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_custom_tab_two'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_custom_product_tab_content_two'
    );

    return $tab;
}
    
function azin_custom_product_tab_content_two() {

    $tab_content = '';

    /*if ( azin_opt( 'product_tab_scroll' ) ) {
        $tab_title = rwmb_meta ( 'file_tab_two_title', '', get_the_ID() );
        $tab_content .= '<h2>'. $tab_title .'</h2>';
    }*/

    $content = rwmb_meta ( 'file_tab_two_content', '', get_the_ID() );

    $tab_content .= azin_output_content( $content );

    echo $tab_content;
}

//azin_custom_product_tab_three
if ( azin_opt( 'custom_product_tab_three' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_custom_product_tab_three' );
}
function azin_custom_product_tab_three( $tab ) {
    
    $tab_title = rwmb_meta ( 'file_tab_three_title', '', get_the_ID() );

    if( empty( $tab_title ) )
        return $tab;
    
    $tab_icon = rwmb_meta ( 'file_tab_three_icon', '', get_the_ID() );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_custom_tab_three'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_custom_product_tab_content_three'
    );

    return $tab;
}
    
function azin_custom_product_tab_content_three() {

    $tab_content = '';

    /*if ( azin_opt( 'product_tab_scroll' ) ) {
        $tab_title = rwmb_meta ( 'file_tab_three_title', '', get_the_ID() );
        $tab_content .= '<h2>'. $tab_title .'</h2>';
    }*/

    $content = rwmb_meta ( 'file_tab_three_content', '', get_the_ID() );

    $tab_content .= azin_output_content( $content );

    echo $tab_content;
}

//azin_product_faq_tab
if ( azin_opt( 'show_faq_product_tab' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_product_faq_tab' );
}
function azin_product_faq_tab( $tab ) {
    
    $show_faq  = rwmb_meta ( 'file_show_faq', '', get_the_ID() );
    $tab_title = azin_opt( 'faq_product_tab_title' );
    $tab_icon  = azin_opt( 'faq_product_tab_icon' );
    $faqs      = rwmb_meta( 'file_faqs', '', get_the_ID() );

    if( ! $show_faq || empty( $faqs ) )
        return $tab;
    
    $tab_icon = azin_opt( 'faq_product_tab_icon' );

    $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_product_faq_tab'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_product_faq_tab_content'
    );

    return $tab;
}
    
function azin_product_faq_tab_content() {

    $faqs = rwmb_meta( 'file_faqs', '', get_the_ID() );

    /*if ( azin_opt( 'product_tab_scroll' ) ) {
        $tab_title = rwmb_meta ( 'file_tab_three_title', '', get_the_ID() );
        $tab_content .= '<h2>'. $tab_title .'</h2>';
    }*/
    $count = 1;
    $faqnumber = 1;

    echo '<div id="accordion" class="azin-faq-accordion">';

    foreach ( $faqs as $faq ) {
        if ( $count % 2 != 0 ){
        ?>
            <div class="card">
                <div class="card-header" id="heading<?php echo $faqnumber; ?>">
					<h5 class="mb-0">
						<button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse<?php echo $faqnumber; ?>" aria-expanded="false" aria-controls="collapse<?php echo $faqnumber; ?>">
                            <?php echo $faq ?>
						</button>
					</h5>
                </div>

                <div id="collapse<?php echo $faqnumber; ?>" class="collapse" aria-labelledby="heading<?php echo $faqnumber; ?>" data-parent="#accordion" style="">
					<div class="card-body azin-accordion-body">
            <?php
            $faqnumber++;
        } else {
            echo $faq;
        ?>
                    </div>
                </div>
            </div>
        
        <?php
        }
        $count++;
    }
    echo '</div>';
}

//azin_add_prod_tab_one
if ( azin_opt( 'show_add_prod_tab_one' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_add_prod_tab_one' );
}
function azin_add_prod_tab_one( $tab ) {
    

    if ( azin_opt( 'tab_one_in_cats' ) && ! empty ( azin_opt( 'add_prod_tab_one_cats' ) ) && ! has_term( azin_opt( 'add_prod_tab_one_cats' ), 'product_cat' ) )
        return $tab;

    $tab_title = azin_opt( 'add_prod_tab_one_title' );

    if( empty( $tab_title ) )
        return $tab;

    $tab_icon = azin_opt( 'add_prod_tab_one_icon' );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon '. $tab_icon .'"></i> '. $tab_title;
    
    $tab['azin_add_prod_tab_one'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_add_prod_tab_one_content'
    );

    return $tab;
}
    
function azin_add_prod_tab_one_content() {
    
    $tab_content = do_shortcode( azin_opt( 'add_prod_tab_one_content' ) );

    echo $tab_content;
}

//azin_add_prod_tab_two
if ( azin_opt( 'show_add_prod_tab_two' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_add_prod_tab_two' );
}
function azin_add_prod_tab_two( $tab ) {
    

    if ( azin_opt( 'tab_two_in_cats' ) && ! empty ( azin_opt( 'add_prod_tab_two_cats' ) ) && ! has_term( azin_opt( 'add_prod_tab_two_cats' ), 'product_cat' ) )
        return $tab;

    $tab_title = azin_opt( 'add_prod_tab_two_title' );

    if( empty( $tab_title ) )
        return $tab;

    $tab_icon = azin_opt( 'add_prod_tab_two_icon' );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon '. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_add_prod_tab_two'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_add_prod_tab_two_content'
    );

    return $tab;
}
    
function azin_add_prod_tab_two_content() {
    
    $tab_content = do_shortcode( azin_opt( 'add_prod_tab_two_content' ) );

    echo $tab_content;
}

//azin_add_prod_tab_three
if ( azin_opt( 'show_add_prod_tab_three' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_add_prod_tab_three' );
}
function azin_add_prod_tab_three( $tab ) {
    

    if ( azin_opt( 'tab_three_in_cats' ) && ! empty ( azin_opt( 'add_prod_tab_three_cats' ) ) && ! has_term( azin_opt( 'add_prod_tab_three_cats' ), 'product_cat' ) )
        return $tab;

    $tab_title = azin_opt( 'add_prod_tab_three_title' );

    if( empty( $tab_title ) )
        return $tab;

    $tab_icon = azin_opt( 'add_prod_tab_three_icon' );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon '. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_add_prod_tab_three'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_add_prod_tab_three_content'
    );

    return $tab;
}
    
function azin_add_prod_tab_three_content() {
    
    $tab_content = do_shortcode( azin_opt( 'add_prod_tab_three_content' ) );

    echo $tab_content;
}

//azin_add_prod_tab_four
if ( azin_opt( 'show_add_prod_tab_four' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_add_prod_tab_four' );
}
function azin_add_prod_tab_four( $tab ) {
    

    if ( azin_opt( 'tab_four_in_cats' ) && ! empty ( azin_opt( 'add_prod_tab_four_cats' ) ) && ! has_term( azin_opt( 'add_prod_tab_four_cats' ), 'product_cat' ) )
        return $tab;

    $tab_title = azin_opt( 'add_prod_tab_four_title' );

    if( empty( $tab_title ) )
        return $tab;

    $tab_icon = azin_opt( 'add_prod_tab_four_icon' );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon '. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_add_prod_tab_four'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_add_prod_tab_four_content'
    );

    return $tab;
}
    
function azin_add_prod_tab_four_content() {
    
    $tab_content = do_shortcode( azin_opt( 'add_prod_tab_four_content' ) );

    echo $tab_content;
}

//azin_add_prod_tab_five
if ( azin_opt( 'show_add_prod_tab_five' ) ) {
    add_filter( 'woocommerce_product_tabs', 'azin_add_prod_tab_five' );
}
function azin_add_prod_tab_five( $tab ) {
    

    if ( azin_opt( 'tab_five_in_cats' ) && ! empty ( azin_opt( 'add_prod_tab_five_cats' ) ) && ! has_term( azin_opt( 'add_prod_tab_five_cats' ), 'product_cat' ) )
        return $tab;

    $tab_title = azin_opt( 'add_prod_tab_five_title' );

    if( empty( $tab_title ) )
        return $tab;

    $tab_icon = azin_opt( 'add_prod_tab_five_icon' );

    if( ! empty( $tab_icon ) && $tab_icon != 'none' )
        $tab_title = '<i class="azin-tab-icon '. $tab_icon .'"></i> '. $tab_title;

    $tab['azin_add_prod_tab_five'] = array(
        'title'     => $tab_title,
        'priority'  => 20,
        'callback'  => 'azin_add_prod_tab_five_content'
    );

    return $tab;
}
    
function azin_add_prod_tab_five_content() {
    
    $tab_content = do_shortcode( azin_opt( 'add_prod_tab_five_content' ) );

    echo $tab_content;
}

//WooCommerce Check if User Has Purchased Product
function azin_check_user_purchased_product( $product_id, $user_id ) {
    if ( wc_customer_bought_product( '', $user_id, $product_id ) ) {
       return true;
    } else {
        return false;
    }
}

//Change Cross Sell Display Place
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display', 10 );
add_action( 'woocommerce_before_cart_collaterals', 'woocommerce_cross_sell_display', 10 );

// Display Only 3 Cross Sells instead of default 4
add_filter( 'woocommerce_cross_sells_total', 'azin_change_cross_sells_product_no' );
function azin_change_cross_sells_product_no( $columns ) {
    return 3;
}

//Ajax add to cart on archives
function azin_archive_add_to_cart( $id ) {

    
    $product = wc_get_product( $id );

    if( $product->is_type( 'variable' ) || ! $product->is_purchasable() || ! $product->is_in_stock() || ( ! $product->is_type( 'variable' ) && azin_opt( 'free_price' ) && ('' === $product->get_price() || 0 == $product->get_price() ) ) ) { ?>
        <span class="azin-add-cart-btn btn btn-light" data-toggle="tooltip" data-placement="top" title="<?php _e( 'View Product', 'azin-file' ); ?>">
            <a href="<?php the_permalink(); ?>" rel="nofollow" <?php azin_link_target() ?>>
                <i class="fal fa-shopping-bag" aria-hidden="true"></i>
            </a>
        </span>
    <?php
    } elseif ( get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' ) {

        $icon  = azin_is_course ( $product->get_id() ) ? 'fa-graduation-cap' : 'fa-cart-plus';
        $title = azin_is_course ( $product->get_id() ) ? __( 'Buy this course', 'azin-file' ) : __( 'Add to cart', 'azin-file' );
        echo '<span class="azin-add-cart-btn btn btn-light" data-toggle="tooltip" data-placement="top" title="'. $title .'">';

        echo apply_filters(
            'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
            sprintf(
                '<a href="%s" data-quantity="%s" class="%s" %s>
                <i class="fal '. $icon .'" aria-hidden="true"></i>
                </a>',
                esc_url( $product->add_to_cart_url() ),
                esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
                esc_attr( implode( ' ', array_filter( array(
                    'product_type_' . $product->get_type(),
                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                    $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
                ) ) ) ),
                wc_implode_html_attributes( array(
                    'data-product_id'  => $product->get_id(),
                    'data-product_sku' => $product->get_sku(),
                    'aria-label'       => $product->add_to_cart_description(),
                    'rel'              => 'nofollow',
                ) )
            ),
            $product
        );

        echo '</span>';
        
    } elseif ( azin_is_course( $product->get_id() ) ) { ?>
        <span class="azin-add-cart-btn btn btn-light" data-toggle="tooltip" data-placement="top" title="<?php _e( 'View Course', 'azin-file' ); ?>">
            <a href="<?php the_permalink(); ?>" rel="nofollow" <?php azin_link_target() ?>>
                <i class="fal fa-graduation-cap" aria-hidden="true"></i>
            </a>
        </span>
    <?php
    } else { ?>
        <span class="azin-add-cart-btn btn btn-light" data-toggle="tooltip" data-placement="top" title="<?php _e( 'View Product', 'azin-file' ); ?>">
            <a href="<?php the_permalink(); ?>" rel="nofollow" <?php azin_link_target() ?>>
                <i class="fal fa-shopping-bag" aria-hidden="true"></i>
            </a>
        </span>
    <?php
    }
}

if( class_exists('YITH_WCWL') ){

    //Get YITH Wishlist product's count
    if ( ! function_exists( 'yith_wcwl_get_items_count' ) ) {
        function yith_wcwl_get_items_count() {
        ob_start();
            echo esc_html( yith_wcwl_count_all_products() );
        return ob_get_clean();
        }
        add_shortcode( 'yith_wcwl_items_count', 'yith_wcwl_get_items_count' );
    }

    if ( ! function_exists( 'yith_wcwl_ajax_update_count' ) ) {
        function yith_wcwl_ajax_update_count() {
        wp_send_json( array(
            'count' => yith_wcwl_count_all_products()
        ) );
        }
  
        add_action( 'wp_ajax_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
        add_action( 'wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
    }

    if ( ! function_exists( 'yith_wcwl_enqueue_custom_script' ) ) {
        function yith_wcwl_enqueue_custom_script() {
        wp_add_inline_script(
            'jquery-yith-wcwl',
            "
            jQuery( function( $ ) {
                $( document ).on( 'added_to_wishlist removed_from_wishlist', function() {
                $.get( yith_wcwl_l10n.ajax_url, {
                    action: 'yith_wcwl_update_wishlist_count'
                }, function( data ) {
                    $('.azin-yith-wcwl-btn .wish-amount').html( data.count );
                } );
                } );
            } );
            "
        );
        }
        add_action( 'wp_enqueue_scripts', 'yith_wcwl_enqueue_custom_script', 20 );
    } 
    
    function azin_remove_yith_wcwl_text(){
        update_option( 'yith_wcwl_browse_wishlist_text', '' );
        update_option( 'yith_wcwl_add_to_wishlist_text', '' );
        update_option( 'yith_wcwl_product_added_text', '' );
    }
    add_action( 'init', 'azin_remove_yith_wcwl_text' );
}

//Azin get product attributes
function azin_get_product_attributes( $id, $attr_count ) {

    $product = wc_get_product( $id );

	$product_attributes = array();

	// Display weight and dimensions before attribute list.
	/*$display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

	if ( $display_dimensions && $product->has_weight() ) {
		$product_attributes['weight'] = array(
			'label' => __( 'Weight', 'woocommerce' ),
			'value' => wc_format_weight( $product->get_weight() ),
		);
	}

	if ( $display_dimensions && $product->has_dimensions() ) {
		$product_attributes['dimensions'] = array(
			'label' => __( 'Dimensions', 'woocommerce' ),
			'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
		);
	}*/

	// Add product attributes to list.
	$attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );

    $i = 0;

	foreach ( $attributes as $attribute ) {

        if ( ! empty ( $attr_count ) && $i == $attr_count ) { 
                break;
            }

		$values = array();

		if ( $attribute->is_taxonomy() ) {
			$attribute_taxonomy = $attribute->get_taxonomy_object();
			$attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

			foreach ( $attribute_values as $attribute_value ) {
				$value_name = esc_html( $attribute_value->name );

				$values[] = $value_name;
			}
		} else {
			$values = $attribute->get_options();

			foreach ( $values as &$value ) {
				$value = make_clickable( esc_html( $value ) );
			}
		}

		$product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
			'label' => wc_attribute_label( $attribute->get_name() ),
			'value' => apply_filters( 'woocommerce_attribute', wptexturize( implode( ', ', $values ) ), $attribute, $values ),
		);

        $i++;
	}

	/**
	 * Hook: woocommerce_display_product_attributes.
	 * $product_attributes Array of atributes to display; label, value.
	 *  $product Showing attributes for this product.
    */
	$product_attributes = apply_filters( 'woocommerce_display_product_attributes', $product_attributes, $product );

	if ( ! $product_attributes ) {
        return;
    }

    $output = '';

	foreach ( $product_attributes as $product_attribute_key => $product_attribute ) :
        $output .= '<div class="prod-row prod-attr col-12">';
            $output .= '<div class="attr"><span class="attr-text">'. wp_kses_post( $product_attribute['label'] ) .'</span></div>';
            $output .= '<div class="attr-value"><span>'. wp_kses_post( $product_attribute['value'] ) .'</span></div>';
        $output .= '</div>';
	endforeach;

    return $output;
}

//woocommerce_is_sold_individually
if ( azin_opt( 'product_sold_individually' ) ) {
    add_filter( 'woocommerce_is_sold_individually', '__return_true' );
}

//Group Downloadable products by product ID
add_filter( 'woocommerce_customer_get_downloadable_products', 'azin_group_downloadable_products' );
function azin_group_downloadable_products( array $downloads ) {

    if ( azin_opt( 'remove_myacc_hooks' ) )
        return $downloads;

    $unique_downloads = [];

    foreach ( $downloads as $download ) {
        $list = [
            'download_url' => $download['download_url'],
            'file_name'    => $download['file']['name']
        ];

        if ( array_key_exists( $download['product_id'], $unique_downloads ) ) {
            $unique_downloads[ $download['product_id'] ]['list'][] = $list;
            continue;
        }

        $data = $download;
        $data['list'] = [ $list ];
        $unique_downloads[ $download['product_id'] ] = $data;
    }

    return $unique_downloads;
}

//Ajax Load More
if( azin_opt( 'ajax_prod' ) ) {
    add_action('woocommerce_after_shop_loop', 'azin_product_load_more', 11);
}
function azin_product_load_more() { ?>
    <div class="col-12 load-more">
        <div class="page-load-status">
            <p class="infinite-scroll-request"><i class="fal fa-spinner-third fa-spin" aria-hidden="true"></i></p>
        </div>
        <span id="load-more-button" class="load-more-button btn azin-btn btn-lg"><?php _e( 'Load More Products', 'azin-file') ?></span>
    </div>
<?php }

//Get Woocomemrce MyAccount Link
function azin_myaccount_link() {

    $myaccount_page_url = '';

    if( class_exists( 'WooCommerce' ) ) {
        $myaccount_page_url = '';
        $myaccount_page = (int)get_option('woocommerce_myaccount_page_id' );

        if ( $myaccount_page ) {
            $myaccount_page_url = get_permalink( $myaccount_page );
        }
    } else {
        $myaccount_page_url = "#";
    }

    return $myaccount_page_url;
}

//azin_override_default_template for product quantity
add_filter('woocommerce_locate_template', 'azin_override_default_template', 9999, 3);
function azin_override_default_template( $template, $template_name, $template_path ) {		
    if ( $template_name == 'global/quantity-input.php' ) {
        $template = AZ_DIR . '/includes/quantity.php';
    }		
    return $template;
}

//Azin track product views.
add_action( 'template_redirect', 'azin_track_product_view', 20 );
if( ! function_exists( 'azin_track_product_view' ) ) {
    function azin_track_product_view() {
        if ( ! is_singular( 'product' ) ) {
            return;
        }

        global $post;

        if ( empty( $_COOKIE['azin_recently_viewed'] ) ) {
            $viewed_products = array();
        } else {
            $viewed_products = wp_parse_id_list( (array) explode( '|', wp_unslash( $_COOKIE['azin_recently_viewed'] ) ) );
        }

        // Unset if already in viewed products list.
        $keys = array_flip( $viewed_products );

        if ( isset( $keys[ $post->ID ] ) ) {
            unset( $viewed_products[ $keys[ $post->ID ] ] );
        }

        $viewed_products[] = $post->ID;

        if ( count( $viewed_products ) > 15 ) {
            array_shift( $viewed_products );
        }

        // Store for session only.
        wc_setcookie( 'azin_recently_viewed', implode( '|', $viewed_products ) );
    }
}

//Show Product Category Description
//remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description' );
//remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description' );
if ( azin_opt( 'show_archive_desc_top' ) ) {
    add_action('woocommerce_before_shop_loop', 'azin_archive_description', 18);
    //add_action('azin_before_no_products_found', 'azin_archive_description', 18);
}

//Change additional information tab title
add_filter( 'woocommerce_product_tabs', 'azin_rename_tabs', 98 );
function azin_rename_tabs( $tabs ) {
    global $product;
    if( $product->has_attributes() || $product->has_dimensions() || $product->has_weight() ) {

        if ( azin_is_course( get_the_ID() ) ) {
            $tabs['additional_information']['title'] = __( 'Course Features', 'azin-file' );
        } else {
            $tabs['additional_information']['title'] = __( 'Product Features', 'azin-file' );
        }
        
    }
    // Additional information tab - shows attributes.
    if ( $product && ( ! $product->has_attributes() && azin_opt( 'remove_dimensions' ) ) ) {
        unset( $tabs['additional_information'] );
    }

    if ( class_exists( 'WeDevs_Dokan' ) && azin_opt( 'course_sales_activation' ) && azin_is_course( get_the_ID() ) ) {
        $tabs['seller']['title'] = __( 'Teacher information', 'azin-file' );
    }

    return $tabs;
}

//Hides the product’s weight and dimension in the single product page.
if( azin_opt( 'remove_dimensions' ) ) {
    add_filter( 'wc_product_enable_dimensions_display', '__return_false' );
}

function azin_product_sale_timer( $id ) {

    $product = wc_get_product( $id );

    if ( $product->is_type( 'variable' ) ) {
        $children_ids = $product->get_children();
        $date = '';
        foreach ( $children_ids as $children_id ) {
            if ( ! empty( $date ) )
                break;
            $child_date = get_post_meta( $children_id, '_sale_price_dates_to', true );
            if ( ! empty( $child_date ) ) {
                $date = $child_date;
            }
        }
    } else {
        $date = get_post_meta( $id, '_sale_price_dates_to', true );
    }

    if ( $date > time() ) {
        $date += 24*60*60;
        $sale_price_date = ( $date ) ? date( 'Y/m/d', $date) : '';
        $date_diff = ( $date ) ? date( 'Y-m-d', $date ) : '';
        $now = time(); // or your date as well
        $your_date = strtotime( $date_diff );
        $diff = $your_date - $now;
        $datediff = round( $diff / ( 60 * 60 * 24 ) ); ?>
    <div class="az-product-sale-timer salecount <?php echo azin_opt( 'sale_count_style' ) ?>" data-datediff="<?php echo $datediff; ?>" data-countdown="<?php echo $sale_price_date; ?>" data-dir="<?php echo (is_rtl())?'rtl':'ltr';?>" data-seconds="<?php _e( 'Seconds' , 'azin-file'); ?>" data-minutes="<?php _e( 'Minutes' , 'azin-file'); ?>" data-hours="<?php _e( 'Hours' , 'azin-file'); ?>" data-days="<?php _e( 'Days' , 'azin-file'); ?>" data-weeks="<?php _e( 'Weeks' , 'azin-file'); ?>"></div>
    <?php
    }
}

// azin_purchased_download_links_tab
add_filter( 'woocommerce_product_tabs', 'azin_purchased_download_links_tab' );
function azin_purchased_download_links_tab( $tab ) {

    global $product;

    if ( ! azin_opt( 'show_purchased_tab' ) || ! wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) )
        return $tab;

    $tab_title = ! empty ( azin_opt( 'purchased_tab_title' ) ) ? azin_opt( 'purchased_tab_title' ) : __( 'Product download', 'azin-file' );

    $tab_title = azin_is_course( $product->get_id() ) && azin_opt( 'change_purchased_text_course' ) ? azin_opt( 'purchased_course_tab_title' ) : $tab_title;
    
    $tab['azin_purchased'] = array(
        'title'     => $tab_title,
        'priority'  => 10,
        'callback'  => 'azin_purchased_download_links_content'
    );

    return $tab;
}

// azin_purchased_download_links_content
function azin_purchased_download_links_content() {
    
    global $product;
    $downloads = array();
    $user_id   = get_current_user_id();
    $downloads = wc_get_customer_available_downloads( $user_id );
    $tab_content = azin_is_course( $product->get_id() ) && azin_opt( 'change_purchased_text_course' ) ? azin_opt( 'purchased_course_tab_content' ) : azin_opt( 'purchased_tab_content' );

    echo '<div class="azin-purchased-tab-content">';
        echo do_shortcode( $tab_content );
    echo '</div>';

    if ( ! empty( $downloads ) ) {
        echo '<ul class="azin-download-list col-12">';
        foreach ( $downloads as $download ) {
            if ( $download['product_id'] === $product->get_id() ) {
                echo '<li>';
                    echo '<a class="azin-download-list-file" href="' . $download['download_url'] . '">' . esc_html( $download['download_name'] ) . '</a>';
                echo '</li>';
            }
        }
        echo '</ul>';
    }
}

//azin_single_add_to_cart_text
add_filter( 'woocommerce_product_single_add_to_cart_text', 'azin_single_add_to_cart_text' ); 
function azin_single_add_to_cart_text() {
    global $product;
    if ( $product->is_type( 'external' ) ) {
        return ! empty ( $product->get_button_text() ) ? $product->get_button_text() : azin_opt( 'text_add_shop' );
    } else {
        return azin_is_course( get_the_id() ) ? azin_opt( 'text_buy_course' ) : azin_opt( 'text_add_shop' ); 
    }
}

//remove_dub_price_range
function remove_dub_price_range( $product ) {

    $variable_class = '';

    if( azin_opt( 'remove_dub_price_range' ) && $product->is_type( 'variable' ) ) {
        $min_var_reg_price = $product->get_variation_regular_price( 'min', true );
        $min_var_sale_price = $product->get_variation_sale_price( 'min', true );
        $max_var_reg_price = $product->get_variation_regular_price( 'max', true );
        $max_var_sale_price = $product->get_variation_sale_price( 'max', true );
        if ( ! ( $min_var_reg_price == $max_var_reg_price ) || ! ( $min_var_sale_price == $max_var_sale_price ) ) {
            $variable_class = 'remove-dub-variable';
        }
    }

    return $variable_class;
}

//Set template of Cart & Checkout pages
if ( azin_opt( 'show_checkout_steps' ) ) {
    add_filter( 'page_template', 'azin_cart_checkout_page_template' );
}
function azin_cart_checkout_page_template( $page_template ) {
    if ( is_cart() || is_checkout() ) {
        $page_template = get_stylesheet_directory() . '/tpls/cart.php'; 
    }
    return $page_template;
}

//Azin Checkout Steps
add_action( 'azin_before_cart_check', 'azin_checkout_steps', 10 );
if( ! function_exists( 'azin_checkout_steps' ) ) {
	function azin_checkout_steps() {
		?>

        <div class="azin-checkout-steps shadow-box">
            <div class="row d-flex justify-content-center">
                <div class="progressbar-con col-12">
                    <ul id="progressbar" class="text-center">
                        <li class="active step azin-step-cart"></li>
                        <li class="<?php echo ( is_checkout() ) ? 'active ' : ''; ?>step azin-step-checkout"></li>
                        <li class="<?php echo ( is_checkout() && is_order_received_page() ) ? 'active ' : ''; ?>step azin-step-complete"></li>
                    </ul>
                </div>
            </div>
            <div class="row justify-content-between">
                <div class="col d-flex justify-content-center">
                    <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php _e( 'Shopping cart', 'azin-file'); ?>">
                        <?php _e( '1. Shopping cart', 'azin-file'); ?>
                    </a>
                </div>
                <div class="col d-flex justify-content-center">
                    <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" title="<?php _e( 'Checkout', 'azin-file'); ?>">
                        <?php _e( '2. Checkout', 'azin-file'); ?>
                    </a>
                </div>
                <div class="col d-flex justify-content-center">
                    <?php _e( '3. Order complete', 'azin-file'); ?>
                </div>
            </div>
        </div>
    

		<?php
	}
}

if ( azin_opt( 'show_up_sells_top' ) ) {
    remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
    add_action( 'azin_before_single_product_summary', 'woocommerce_upsell_display', 2 );
}