<?php
// For displaying in Order page columns.
add_filter( 'manage_edit-shop_order_columns', 'azin_set_tracking_column' );
function azin_set_tracking_column($columns) {
    $columns['tracking_column'] = azin_opt( 'order_tracking_code_title' );
    return $columns;
}

// Add the data to the custom columns for the order post type:
add_action( 'manage_shop_order_posts_custom_column' , 'azin_custom_shop_order_column', 10, 2 );
function azin_custom_shop_order_column( $column, $post_id ) {
    switch ( $column ) {
        case 'tracking_column' :
            echo esc_html( get_post_meta( $post_id, 'tracking_column', true ) );
            break;
    }
}

// For display and saving in order details page.
add_action( 'add_meta_boxes', 'azin_tracking_code_meta_box' );
function azin_tracking_code_meta_box() {
    add_meta_box(
        'tracking_column', //ID
        azin_opt( 'order_tracking_code_title' ), //Title
		'azin_shop_order_display_callback', //callback
		'shop_order', //WP_Screen
        'side', //Context
        'default' //Priority
    );
}

// For displaying it correctly
function azin_shop_order_display_callback( $post ) {
    $value = get_post_meta( $post->ID, 'tracking_column', true );
    echo '<textarea style="width:100%" id="tracking_column" name="tracking_column">' . esc_attr( $value ) . '</textarea>';
}

// Saving the input data
function azin_save_tracking_code_meta_box_data( $post_id ) {
	
    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    // Check the user's permissions.
    if ( isset( $_POST['post_type'] ) && 'shop_order' == $_POST['post_type'] ) {
        if ( ! current_user_can( 'edit_shop_order', $post_id ) ) {
            return;
        }
    }

    // Make sure that it is set.
    if ( ! isset( $_POST['tracking_column'] ) ) {
        return;
    }

    // Sanitize user input.
    $my_data = sanitize_text_field( $_POST['tracking_column'] );

    // Update the meta field in the database.
    update_post_meta( $post_id, 'tracking_column', $my_data );
}
add_action( 'save_post', 'azin_save_tracking_code_meta_box_data' );

//Showing the info on My orders page

//New column on My orders page
add_filter( 'woocommerce_account_orders_columns', 'azin_add_account_orders_column', 1, 1 );
function azin_add_account_orders_column( $columns ){
    $columns['tracking-column'] = azin_opt( 'order_tracking_code_title' );

    return $columns;
}

add_action( 'woocommerce_my_account_my_orders_column_tracking-column', 'azin_add_account_orders_column_rows' );
function azin_add_account_orders_column_rows( $order ) {
    // Example with a custom field
    if ( $value = $order->get_meta( 'tracking_column' ) ) {
		?>
		<span class="azin-order-tracking-code">
			<span class="azin-order-tracking-text" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Click to copy the code', 'azin-file' ); ?>">
				<?php echo esc_html( $value ) ?>
			</span>
			<span class="link-copy"><?php _e( 'Code copied!', 'azin-file' ) ?></span>
        </span>
	<?php
    }
}

// Showing tracking code on View order page and on Thank you page
add_action( 'woocommerce_thankyou', 'azin_tracking_on_thankyou_page', 2 );
add_action( 'woocommerce_view_order', 'azin_tracking_on_thankyou_page', 2 );
function azin_tracking_on_thankyou_page( $order_id ){
    $tracking_code = get_post_meta( $order_id, 'tracking_column', true );
    if ( ! empty ( $tracking_code ) ) {  ?>
    <table class="woocommerce-table shop_table azin-order-tracking-code-table">
        <tbody>        
            <tr>
                <th>
                    <?php echo azin_opt( 'order_tracking_code_title' ) . ': ' ?>
                </th>
                <td>
                    <span class="azin-order-tracking-code">
                        <span class="azin-order-tracking-text" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Click to copy the code', 'azin-file' ); ?>">
                            <?php echo esc_html( $tracking_code ) ?>
                        </span>
                        <span class="link-copy"><?php _e( 'Code copied!', 'azin-file' ) ?></span>
                    </span>
                </td>
            </tr>
        </tbody>
    </table>
<?php }
}

add_action ( 'wp_footer', 'azin_copy_tracking_script' );
function azin_copy_tracking_script(){
	if ( is_user_logged_in() && is_account_page() ) { ?>
		<script>
			jQuery(function (e) {
			jQuery(document).on("click", ".azin-order-tracking-code", function () {
				var e = jQuery("<input>");
				jQuery("body").append(e), e.val(jQuery(this).find('.azin-order-tracking-text').html()).select(), document.execCommand("copy"), e.remove(), jQuery(".link-copy").fadeIn().delay(2e3).fadeOut(600)
			})
			})
		</script>
	<?php
	}
}
