jQuery( function ( $ ) {
	'use strict';

	var frame;

	$( 'body' ).on( 'click', '.rwmb-file-input-select', function ( e ) {
		e.preventDefault();
		var $el = $( this );

		// Create a frame only if needed
		if ( ! frame ) {
			frame = wp.media( {
				className: 'media-frame rwmb-file-frame',
				multiple: false,
				title: rwmbFileInput.frameTitle
			} );
		}

		// Open media uploader
		frame.open();

		// Remove all attached 'select' event
		frame.off( 'select' );

		// Handle selection
		frame.on( 'select', function () {
			var url = frame.state().get( 'selection' ).first().toJSON().url;
			$el.siblings( 'input' ).val( url ).siblings( 'a' ).removeClass( 'hidden' );
		} );
	} );

	// Clear selected images
	$( 'body' ).on( 'click', '.rwmb-file-input-remove', function ( e ) {
		e.preventDefault();
		$( this ).addClass( 'hidden' ).siblings( 'input' ).val( '' );
	} );
    $(document).ready(function () {
    var i = $("input[type=radio][name=file_pre_type]:checked").val();
    if (i == 'pre_slides' ) {
            $( '.az_aparat_text_input' ).hide();
            $( '.az_image_file_input' ).show();
            $( '.az_video_file_input' ).hide();
            $( '.az_music_file_input' ).hide();
        }
        else if (i == 'pre_video' ) {
            $( '.az_aparat_text_input' ).hide();
            $( '.az_image_file_input' ).hide();
            $( '.az_video_file_input' ).show();
            $( '.az_music_file_input' ).hide();
        }
        else if (i == 'pre_music' ) {
            $( '.az_aparat_text_input' ).hide();
            $( '.az_image_file_input' ).hide();
            $( '.az_video_file_input' ).hide();
            $( '.az_music_file_input' ).show();
        }
        else if (i == 'pre_aparat' ) {
            $( '.az_aparat_text_input' ).show();
            $( '.az_image_file_input' ).hide();
            $( '.az_video_file_input' ).hide();
            $( '.az_music_file_input' ).hide();
        }
    });
    $( 'input[type=radio][name=file_pre_type]' ).change(function() {
        if (this.value == 'pre_slides' ) {
            $( '.az_aparat_text_input' ).hide();
            $( '.az_image_file_input' ).show();
            $( '.az_video_file_input' ).hide();
            $( '.az_music_file_input' ).hide();
        }
        else if (this.value == 'pre_video' ) {
            $( '.az_aparat_text_input' ).hide();
            $( '.az_image_file_input' ).hide();
            $( '.az_video_file_input' ).show();
            $( '.az_music_file_input' ).hide();
        }
        else if (this.value == 'pre_music' ) {
            $( '.az_aparat_text_input' ).hide();
            $( '.az_image_file_input' ).hide();
            $( '.az_video_file_input' ).hide();
            $( '.az_music_file_input' ).show();
        }
        else if (this.value == 'pre_aparat' ) {
            $( '.az_aparat_text_input' ).show();
            $( '.az_image_file_input' ).hide();
            $( '.az_video_file_input' ).hide();
            $( '.az_music_file_input' ).hide();
        }
    });
} );