<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

get_header();

azin_wrapper_start();
?>

<div class="row main<?php side_type(); ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

    <?php 
    $author = get_user_by( 'slug', get_query_var( 'vendor' ) );

    if ( ! $author ) {
        $url = $_SERVER['REQUEST_URI'];
        $page_id = EDD_FES()->helper->get_option( 'fes-vendor-page', false );
        $page = get_page( $page_id );
        $page_name = ! empty( $page->post_name ) ? $page->post_name : EDD_FES()->vendors->get_vendor_constant_name( false, false );
        $permalink = '/'. trailingslashit( $page_name ) ;
        
        if ( ! empty ( $_SERVER['REQUEST_URI'] ) && ! empty( $url ) ) {
            $string = str_replace( $permalink, '', $url );
            $author = get_user_by( 'slug', untrailingslashit ( $string ) );
        }
    }
    ?>

    <div class="col-lg-9 col-12<?php if ( azin_opt( 'side_type' ) == 2 ) { echo ' right-side'; } if ( azin_opt( 'sticky_side' ) ) { echo ' pcol'; }?>">
        <div class="author-page">
            <div class="row">

                <?php if ( azin_opt( 'show_author_box_avatar' ) ) { ?>
                <div class="col-md-2 col-12 uavatar">
                    <?php echo get_avatar( $author->ID , 128, '', $author->display_name ); ?>
                </div>
                <?php } ?>
                
                <div class="<?php echo azin_opt( 'show_author_box_avatar' ) ? 'col-md-10 col-12' : 'col-12'; ?>">

                    <?php if ( azin_opt( 'show_author_box_name' ) ) { ?>
                    <div class="row author-name">
                        <?php echo $author->display_name; ?>
                    </div>
                    <?php } ?>

                    <?php if ( azin_opt( 'show_author_box_bio' ) ) { ?>
                    <div class="row author-bio">
                        <?php echo $author->description; ?>
                    </div>
                    <?php } ?>
                    
                    <div class="row author-det">
                        <div class="col-12 author-attr">

                            <?php if ( azin_opt( 'show_author_box_products' ) ) { ?>
                            <?php $post_type = az_woo() ? 'product' : 'download'; ?>
                            <i class="fal fa-shopping-bag author-icon" data-toggle="tooltip" data-placement="top" title="<?php echo count_user_posts( $author->ID , $post_type, true  ) . __( ' Product', 'azin-file' ); ?>"></i>
                            <?php } ?>

                            <?php if ( azin_opt( 'course_sales_activation' ) && azin_opt( 'show_author_box_courses' ) ) { ?>
                            <i class="fal fa-graduation-cap author-icon" data-toggle="tooltip" data-placement="top" title="<?php echo azin_count_course( $author->ID ) . __( ' Course', 'azin-file' ); ?>"></i>
                            <?php } ?>

                            <?php if ( azin_opt( 'show_author_box_posts' ) ) { ?>
                            <i class="fal fa-file-alt author-icon" data-toggle="tooltip" data-placement="top" title="<?php echo count_user_posts( $author->ID , "post", true  ) . __( ' Post', 'azin-file' ) ?>"></i>
                            <?php } ?>

                            <?php if ( azin_opt( 'show_author_box_regdate' ) ) { ?>
                            <i class="fal fa-user-plus author-icon"  data-toggle="tooltip" data-placement="top" title="<?php _e( 'Subscribe from ', 'azin-file' ); azin_register_date( $author->ID); ?>"></i>
                            <?php } ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        <?php
        //Block Products
        $post_type = az_woo() ? 'product' : 'download';

        $args = array(
            'posts_per_page' => 8,
            'post_type'      => $post_type,
            'post_status'    => 'publish',
            'author'         => $author->ID,
            'meta_query' => array(
                'relation' => 'OR',
                array(
                'key'     => 'file_training_course',
                'compare' => 'NOT LIKE',
                'value'   => 1
                ),
                array(
                'key' => 'file_training_course',
                'compare' => 'NOT EXISTS',
                )
            ),
            'order'          => 'DESC'  
        );

        $query = new WP_Query( $args );

        if ( $query->have_posts() ) {
        
            $block_link = get_author_posts_url( $author->ID , $author->user_nicename ).'?post_type='. $post_type;
        
            $block_args = array(
                'block_title'      => __( 'Products', 'azin-file' ),
                'block_title_link' => $block_link,
                'block_icon'       => 'fal fa-shopping-bag',
                'block_itemscount' => azin_opt( 'related_pcol_count' ),
                'block_itemplay'   => false,
                'block_itemloop'   => false,
                'block_query'      => $args,
                'block_post_type'  => $post_type
            );
        
            azin_carousel_block( $block_args );
        }

        //Block Courses
        $post_type = az_woo() ? 'product' : 'download';

        $args = array(
            'posts_per_page' => 8,
            'post_type'      => $post_type,
            'post_status'    => 'publish',
            'author'         => $author->ID,
            'meta_key'    => 'file_training_course',
            'meta_value'  => 1,
            'order'          => 'DESC'
        );

        $query = new WP_Query( $args );

        if ( $query->have_posts() ) {
        
            $block_link = get_author_posts_url( $author->ID , $author->user_nicename ).'?post_type='. $post_type;
        
            $block_args = array(
                'block_title'      => __( 'Courses', 'azin-file' ),
                'block_title_link' => $block_link,
                'block_icon'       => 'fal fa-graduation-cap',
                'block_itemscount' => azin_opt( 'related_pcol_count' ),
                'block_itemplay'   => false,
                'block_itemloop'   => false,
                'block_query'      => $args,
                'block_post_type'  => $post_type
            );
        
            azin_carousel_block( $block_args );
        }

        //Block Posts        
        $args = array(
            'posts_per_page' => 8,
            'post_type'      => 'post',
            'post_status'    => 'publish',
            'author'         => $author->ID,
            'order'          => 'DESC'
        );

        $query = new WP_Query( $args );

        if ( $query->have_posts() ) {
        
            $block_link = get_author_posts_url( $author->ID , $author->user_nicename ).'?post_type=post';
        
            $block_args = array(
                'block_title'      => __( 'Posts', 'azin-file' ),
                'block_title_link' => $block_link,
                'block_icon'       => 'fal fa-file-alt',
                'block_itemscount' => azin_opt( 'related_scol_count' ),
                'block_itemplay'   => false,
                'block_itemloop'   => false,
                'block_query'      => $args,
                'block_post_type'  => 'post'
            );
        
            azin_carousel_block( $block_args );
        }
        ?>

    </div>

    <aside class="col-lg-3 side-bar<?php echo az_show_side_mobile(); if ( azin_opt( 'sticky_side' ) ) { echo ' side-sticky'; }?>">
        <?php get_template_part( 'right-sidebar' ); ?>
    </aside>

</div>

<?php
azin_wrapper_end();

get_footer();