<!doctype html>
<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: https://azinfile.i-design.ir/
Author Website: i-design.ir
*/

require_once get_template_directory() . '/includes/dynamic_style.php';
?>
<html <?php language_attributes(); ?>>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <?php if( ! azin_opt( 'dis_mobile_color' ) ) { ?>
        <meta name="theme-color" content="<?php echo ( azin_opt( 'ch_mobile_color' ) ? azin_opt( 'mobile_bar_color' ) : azin_opt( 'custom_color' ) ); ?>" />
    <?php } ?>
    <title>
        <?php bloginfo( 'name' ); ?> | <?php is_front_page() ? bloginfo( 'description' ) : wp_title( '' ); ?>
    </title>
    <link rel="shortcut icon" href="<?php echo azin_to_https( azin_opt( 'site_favicon', 'url' ) ); ?>" type="image/x-icon" />
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo esc_url( get_template_directory_uri() ); ?>/css/bootstrap-rtl.min.css">
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo esc_url( get_template_directory_uri() ); ?>/css/fontawesome.min.css">
    <link rel="stylesheet" media="screen" type="text/css" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo esc_url( get_template_directory_uri() ); ?>/css/<?php echo azin_opt( 'theme_font' );  ?>.css" />
    
    <?php custom_styles(); ?>
</head>

<body>
    <div class="container-fluid">
        <div class="row">
            <div class="container under">

                <h1>
                    <a href="<?php echo azin_logo_link(); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" rel="home">
                        <?php 
                            $logo_width = ( ! empty( azin_opt( 'site_logo_retina', 'width' ) ) ) ? azin_opt( 'site_logo_retina', 'width' ) : '280';
                            $logo_height = ( ! empty( azin_opt( 'site_logo_retina', 'height' ) ) ) ? azin_opt( 'site_logo_retina', 'height' ) : '120';
                        ?>
                        <img class="skip-lazy" src="<?php echo azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ); ?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" />
                    </a>
                </h1>

                <h2>
                    <?php _e( 'Register version', 'azin-file' ); ?>
                </h2>

                <h3 style="font-size:18px;margin:20px auto;display:table">
                    <?php _e( 'Please activate theme with your license key to all features work.' , 'azin-file' ) ?>
                </h3>

                <a class="btn azin-btn" style="margin:10px auto;display:table" href="<?php echo admin_url( 'themes.php?page=acc9f31c9a0ce63faa56ff47f6724bf', '' ); ?>">
                    <?php _e( 'Register version', 'azin-file' ); ?>
                </a>

            </div>
        </div>
    </div>
</body>

</html>