<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;
get_header();

azin_wrapper_start();

$no_side = false;
if ( az_woo() ) {
    if( is_cart() || is_checkout() ) {
        $no_side = true;
    }
} else {
    $purchase_page = edd_get_option( 'purchase_page', '' );
    if ( get_the_ID() == $purchase_page ) {
        $no_side = true;
    }
}

$page_class = '';

if ( $no_side == true ) {
    $page_class .= ' wside col-12';
} else {
    $page_class .= p_sidebar( get_the_ID() );
}

if ( azin_opt( 'sticky_side' ) ) {
    $page_class .= ' pcol';
}

$lock_page_content = rwmb_meta( 'file_lock_page_content', '', get_the_ID() ) == 1 ? true : false;
?>
        
<div class="row main<?php side_type(); ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

    <article class="<?php echo $page_class;  ?>">

        <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
            <div role="main" class="scon" id="post-<?php the_ID(); ?>">
                <div class="s-product">

                    <?php if ( ! azin_opt( 'bread_style_two' ) ) { ?>
                        <h1 class="post-title">
                            <?php the_title(); ?>
                        </h1>
                    <?php } ?>

                    <div class="page-con entry-content">

                        <?php
                            
                        if ( ! is_user_logged_in() && $lock_page_content ) {
                            azin_locked_content();
                        } else {

                        ?>

                        <?php the_content(); ?>
                        <?php
                            $defaults = array(
                                'before'           => '<div class="text-center apage-break">',
                                'after'            => '</div>',
                                'link_before'      => '',
                                'link_after'       => '',
                                'next_or_number'   => 'text',
                                'separator'        => ' ',
                                'nextpagelink'     => '<span class="btn azin-btn">' . __( 'Next page', 'azin-file' ) . '<i aria-hidden="true" class="fal fa-angle-left"></i></span>',
                                'previouspagelink' => '<span class="btn azin-btn"><i aria-hidden="true" class="fal fa-angle-right"></i>' . __( 'Prev page', 'azin-file' ) . '</span>',
                                'pagelink'         => '%',
                                'echo'             => 1
                            );
                            wp_link_pages( $defaults);
                        }
                        ?>

                    </div>
                </div>
            </div>
        <?php endwhile; ?>

            <?php
            if ( ! is_user_logged_in() && $lock_page_content ) {
                //do nothing
            } else {
                //Start Comments
                if ( comments_open() ) : ?>
                <div class="comments-con">
                    <div class="comments-list col-12">
                        <?php comments_template(); ?>
                    </div>
                </div>
                <?php endif;
                //End Comments
            } ?>

        <?php endif; ?>

    </article>

    <?php  ?>

    <?php
    if ( $no_side == true ) {
        //Do Nothing!
    } elseif ( ( rwmb_meta( 'file_wside' ) != 1 ) && ( rwmb_meta( 'file_wside' ) != 'noside' ) ) { ?>
        <aside class="col-lg-3 side-bar<?php echo az_show_side_mobile(); if ( azin_opt( 'sticky_side' ) ) { echo ' side-sticky'; }?>">
            <?php get_template_part( 'right-sidebar' ); ?>
        </aside>
    <?php } ?>

</div>

<?php
azin_wrapper_end();

get_footer();