<?php
/**
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Azinfile
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright ( c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once get_template_directory() . '/plugins/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'tgmpa_register_required_plugins' );

function tgmpa_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	*/
	$az_data[] = '';
	

	if ( is_rtl() ) {
		if ( azin_opt( 'woo_mode' ) ) {
			$plugins = array(
				// This is an example of how to include a plugin from the WordPress Plugin Repository.
				array(
					'name'      => __( 'WooCommerce', 'azin-file' ),
					'slug'      => 'woocommerce',
					'required'  => true,
				),
				array(
					'name'      => __( 'Persian WooCommerce', 'azin-file' ),
					'slug'      => 'persian-woocommerce',
					'required'  => true,
				),
				array(
					'name'      =>  __( 'Elementor Page Builder', 'azin-file' ),
					'slug'      => 'elementor',
					'required'  => true,
				),
				array(
					'name'      =>  __( 'Free Downloads WooCommerce', 'azin-file' ),
					'slug'      => 'download-now-for-woocommerce',
					'required'  => false,
				),
			);
		} else {
			$plugins = array(
				// This is an example of how to include a plugin from the WordPress Plugin Repository.
				array(
					'name'      => __( 'Easy Digital Downloads', 'azin-file' ),
					'slug'      => 'easy-digital-downloads',
					'required'  => true,
				),
				array(
					'name'      =>  __( 'Elementor Page Builder', 'azin-file' ),
					'slug'      => 'elementor',
					'required'  => false,
				),
				array(
				'version'       => '1.4',
				'name'          => __( 'EDD Customer Dashboard', 'azin-file' ), // The plugin name.
				'slug'          => 'EDD-Customer-Dashboard', // The plugin slug (typically the folder name).
				'source'        => get_template_directory() . '/plugins/EDD-Customer-Dashboard.zip', // The plugin source.
				),
				array(
					'name'      => __( 'EDD - Auto Register', 'azin-file' ),
					'slug'      => 'edd-auto-register',
					'required'  => true,
				),
				array(
					'name'      => __( 'EDD Free Link', 'azin-file' ),
					'slug'      => 'easy-digital-downloads-free-link',
					'required'  => false,
				),
			);
		}
	} else {
		if ( azin_opt( 'woo_mode' ) ) {
			$plugins = array(
				// This is an example of how to include a plugin from the WordPress Plugin Repository.
				array(
					'name'      => __( 'WooCommerce', 'azin-file' ),
					'slug'      => 'woocommerce',
					'required'  => true,
				),
				array(
					'name'      =>  __( 'Elementor Page Builder', 'azin-file' ),
					'slug'      => 'elementor',
					'required'  => true,
				),
				array(
					'name'      =>  __( 'Free Downloads WooCommerce', 'azin-file' ),
					'slug'      => 'download-now-for-woocommerce',
					'required'  => false,
				),
			);
		} else {
			$plugins = array(
				// This is an example of how to include a plugin from the WordPress Plugin Repository.
				array(
					'name'      => __( 'Easy Digital Downloads', 'azin-file' ),
					'slug'      => 'easy-digital-downloads',
					'required'  => true,
				),
				array(
					'name'      =>  __( 'Elementor Page Builder', 'azin-file' ),
					'slug'      => 'elementor',
					'required'  => false,
				),
				array(
				'version'       => '1.3.6',
				'name'          => __( 'EDD Customer Dashboard', 'azin-file' ), // The plugin name.
				'slug'          => 'EDD-Customer-Dashboard', // The plugin slug (typically the folder name).
				'source'        => get_template_directory() . '/plugins/EDD-Customer-Dashboard.zip', // The plugin source.
				),
				array(
					'name'      => __( 'EDD - Auto Register', 'azin-file' ),
					'slug'      => 'edd-auto-register',
					'required'  => true,
				),
				array(
					'name'      => __( 'EDD Free Link', 'azin-file' ),
					'slug'      => 'easy-digital-downloads-free-link',
					'required'  => false,
				),
			);
		}
	}

	
	
	$config = array(
		'id'           => 'azin_tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.
		
		'strings'      => array(
			'page_title'                      => __( 'Install Required Plugins', 'azin-file' ),
			'menu_title'                      => __( 'Install Plugins', 'azin-file' ),
			
			'installing'                      => __( 'Installing Plugin: %s', 'azin-file' ),
			
			'updating'                        => __( 'Updating Plugin: %s', 'azin-file' ),
			'oops'                            => __( 'Something went wrong with the plugin API.', 'azin-file' ),
			'notice_can_install_required'     => _n_noop(
				
				'This theme requires the following plugin: %1$s.',
				'This theme requires the following plugins: %1$s.',
				'azin-file'
			),
			'notice_can_install_recommended'  => _n_noop(
				
				'This theme recommends the following plugin: %1$s.',
				'This theme recommends the following plugins: %1$s.',
				'azin-file'
			),
			'notice_ask_to_update'            => _n_noop(
				
				'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
				'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
				'azin-file'
			),
			'notice_ask_to_update_maybe'      => _n_noop(
				
				'There is an update available for: %1$s.',
				'There are updates available for the following plugins: %1$s.',
				'azin-file'
			),
			'notice_can_activate_required'    => _n_noop(
				
				'The following required plugin is currently inactive: %1$s.',
				'The following required plugins are currently inactive: %1$s.',
				'azin-file'
			),
			'notice_can_activate_recommended' => _n_noop(
				
				'The following recommended plugin is currently inactive: %1$s.',
				'The following recommended plugins are currently inactive: %1$s.',
				'azin-file'
			),
			'install_link'                    => _n_noop(
				'Begin installing plugin',
				'Begin installing plugins',
				'azin-file'
			),
			'update_link' 					  => _n_noop(
				'Begin updating plugin',
				'Begin updating plugins',
				'azin-file'
			),
			'activate_link'                   => _n_noop(
				'Begin activating plugin',
				'Begin activating plugins',
				'azin-file'
			),
			'return'                          => __( 'Return to Required Plugins Installer', 'azin-file' ),
			'plugin_activated'                => __( 'Plugin activated successfully.', 'azin-file' ),
			'activated_successfully'          => __( 'The following plugin was activated successfully:', 'azin-file' ),
			
			'plugin_already_active'           => __( 'No action taken. Plugin %1$s was already active.', 'azin-file' ),
			
			'plugin_needs_higher_version'     => __( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'azin-file' ),
			
			'complete'                        => __( 'All plugins installed and activated successfully. %1$s', 'azin-file' ),
			'dismiss'                         => __( 'Dismiss this notice', 'azin-file' ),
			'notice_cannot_install_activate'  => __( 'There are one or more required or recommended plugins to install, update or activate.', 'azin-file' ),
			'contact_admin'                   => __( 'Please contact the administrator of this site for help.', 'azin-file' ),

			'nag_type'                        => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		),
	);

	tgmpa( $plugins, $config );
}
