<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

get_header();

azin_wrapper_start();

$p_page_class = ( azin_opt( 'product_style_two' ) ? ' main-product-style-two' : ' main-product-style-one' );
?>

<div class="row main<?php side_type(); echo $p_page_class; ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

    <?php
        $download = new EDD_Download( get_the_ID() );
        $variable_pricing = $download->has_variable_prices();
        $product_class  = ( ! azin_opt( 'product_style_two' ) && azin_opt( 'remove_product_sidebar' ) ) ? 'col-12' : 'col-lg-9 col-12';
        $product_class .= $variable_pricing ? ' variable-product' : ' simple-product';
        $product_class .= azin_opt( 'square_thumb' ) ? ' product-square-thumb': '';
        $product_class .= azin_opt( 'side_type' ) == 2 ? ' right-side': '';
        $product_class .= azin_opt( 'sticky_side' ) ? ' pcol': '';
        $product_class .= azin_is_course( get_the_ID() ) ? ' product-type-course': '';
    ?>

    <div class="<?php echo $product_class; ?>">

        <?php
        az_product_head_banner( get_the_ID() );

        if ( azin_opt( 'show_services_prod' ) && azin_opt( 'single_type' ) == 1 ) {
            az_show_services();
        } elseif ( azin_opt( 'show_services_prod' ) && azin_opt( 'single_type' ) == 2 && ! azin_opt( 'product_style_two' ) ) {
            az_show_services();
        }

        if ( have_posts() ) :

            //Start Product tab style one
            if ( azin_opt( 'single_type' ) == 1 ) { ?>

                <?php while ( have_posts() ) : the_post(); ?>

                    <article <?php if ( azin_opt( 'site_schema' ) ) {?>itemscope itemtype="http://schema.org/Product" <?php } ?>>

                        <?php if ( azin_opt( 'site_schema' ) ) { ?>
                            <meta itemprop="name" content="<?php the_title(); ?>">
                            <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
                            <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>">
                        <?php 
                            az_edd_offer_schema( $id );
                        } ?>

                        <div role="main" class="scon" id="post-<?php the_ID(); ?>">
                            <div class="s-product">

                            <?php az_header_style_one_edd( get_the_ID() ); ?>

                                <div class="row product-details">

                                    <?php
                                        if ( azin_opt( 'product_style_two' ) ) {
                                            $prodimg = 'col-12 product-style-two-pre';
                                            $proddet = '';
                                        } elseif ( azin_opt( 'square_thumb' ) && azin_opt( 'full_width_style' ) ) {
                                            $prodimg = 'col-lg-4 col-md-6 col-12';
                                            $proddet = 'col-lg-8 col-md-6 col-12 square-thumb';
                                        } elseif ( azin_opt( 'square_thumb' ) ) {
                                            $prodimg = 'col-lg-4 col-md-6 col-12';
                                            $proddet = 'col-lg-8 col-md-6 col-12 square-thumb';
                                        } else {
                                            $prodimg = 'col-lg-7 col-md-8 col-12';
                                            $proddet = 'col-lg-5 col-md-4 col-12';
                                        }
                                    ?>

                                    <div class="<?php echo $prodimg; ?> prod-img si-img">
                                            
                                        <?php
                                            az_product_badge( get_the_ID() );
                                            az_product_preview( get_the_ID(), false );
                                        ?>

                                    </div>

                                    

                                    <?php 
                                    if ( !azin_opt( 'product_style_two' ) ) { ?>

                                        <div class="<?php echo $proddet; ?> prod-det">

                                        <?php
                                        az_product_fields( get_the_ID() );

                                        do_action( 'azin_after_product_fields' );

                                        az_check_user_purchased( get_the_ID() );

                                        az_product_price_edd( get_the_ID() );

                                        az_add_product_edd( get_the_ID() );

                                        do_action( 'azin_after_add_product' );
                                        ?>

                                        </div>
                                        
                                    <?php } ?>

                                    <div class="col-12 entry-content">
                                        <?php azin_product_content( get_the_ID() ); ?>
                                    </div>

                                </div>

                            </div>
                        </div>

                    </article>

                    <?php if ( ! azin_opt( 'product_style_two' ) ) :
                        azin_show_related_product( get_the_ID() );

                        azin_show_related_product_posts( get_the_ID() );
                    endif; ?>

                <?php endwhile; ?>

                <?php az_product_foot_banner(); ?>

                <?php
                if ( comments_open() ) : ?>
                    <div class="comments-con">
                        <div class="comments-list col-12">
                            <?php comments_template(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                
            <?php
            //Start Product tab style two
            } else { ?>

                <?php while ( have_posts() ) : the_post(); ?>

                    <article <?php if ( azin_opt( 'site_schema' ) ) {?>itemscope itemtype="http://schema.org/Product" <?php } ?>>

                        <?php if ( azin_opt( 'site_schema' ) ) { ?>
                            <meta itemprop="name" content="<?php the_title(); ?>">
                            <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
                            <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>">
                        <?php 
                            az_edd_offer_schema( $id );
                        } ?>

                        <div role="main" class="scon" id="post-<?php the_ID(); ?>">

                            <div class="s-product">

                                <?php az_header_style_one_edd( get_the_ID() ); ?>
                                
                                <div class="row product-details">

                                    <?php
                                        if ( azin_opt( 'product_style_two' ) ) {
                                            $prodimg = 'col-12 product-style-two-pre';
                                            $proddet = '';
                                        } elseif ( azin_opt( 'square_thumb' ) && azin_opt( 'full_width_style' ) ) {
                                            $prodimg = 'col-lg-4 col-md-6 col-12';
                                            $proddet = 'col-lg-8 col-md-6 col-12 square-thumb';
                                        } elseif ( azin_opt( 'square_thumb' ) ) {
                                            $prodimg = 'col-lg-4 col-md-6 col-12';
                                            $proddet = 'col-lg-8 col-md-6 col-12 square-thumb';
                                        } else {
                                            $prodimg = 'col-lg-7 col-md-8 col-12';
                                            $proddet = 'col-lg-5 col-md-4 col-12';
                                        }
                                    ?>

                                    <div class="<?php echo $prodimg; ?> prod-img si-img">
                                        
                                        <?php
                                            az_product_badge( get_the_ID() );
                                            az_product_preview( get_the_ID(), false );
                                        ?>

                                    </div>
        
                                    <?php 
                                    if ( !azin_opt( 'product_style_two' ) ) { ?>

                                        <div class="<?php echo $proddet; ?> prod-det">

                                        <?php
                                        az_product_fields( get_the_ID() );

                                        do_action( 'azin_after_product_fields' );

                                        az_check_user_purchased( get_the_ID() );

                                        az_product_price_edd( get_the_ID() );

                                        az_add_product_edd( get_the_ID() );

                                        do_action( 'azin_after_add_product' );
                                        ?>

                                        </div>
                                        
                                    <?php } ?>
                                    
                                </div>
                                
                            </div>

                            <?php 
                            //Show prodcut Services
                            if ( azin_opt( 'show_services_prod' ) && azin_opt( 'product_style_two' ) ) {
                                az_show_services();
                            }

                            if ( azin_opt( 'show_related_top' ) )
                                azin_show_related_product( get_the_ID() );
                            ?>

                            <ul class="edd-product-tabs nav nav-tabs">

                                <li class="nav-item description_tab">
                                    <a data-toggle="tab" href="#pdesc" class="active">
                                        <?php _e( 'Description', 'azin-file' ); ?>
                                    </a>
                                </li>

                                <?php if ( azin_opt( 'show_purchased_tab' ) && edd_has_user_purchased( get_current_user_id(), get_the_ID() ) ) { ?>
                                    <li class="nav-item azin_purchased_tab">
                                        <a data-toggle="tab" href="#azin_purchased">
                                            <?php
                                            $tab_title = ! empty ( azin_opt( 'purchased_tab_title' ) ) ? azin_opt( 'purchased_tab_title' ) : __( 'Product download', 'azin-file' );
                                            $tab_title = azin_is_course( get_the_ID() ) && azin_opt( 'change_purchased_text_course' ) ? azin_opt( 'purchased_course_tab_title' ) : $tab_title;
                                            echo $tab_title;
                                            ?>
                                        </a>
                                    </li>
                                <?php } ?>

                                <?php if ( azin_opt( 'show_course_lessons' ) && azin_is_course( get_the_ID() ) && ! edd_has_user_purchased( get_current_user_id(), get_the_ID() ) ) { ?>
                                    <li class="nav-item azin_course_lessons_tab">
                                        <a data-toggle="tab" href="#azin_course_lessons">
                                            <?php
                                            $tab_title = ! empty ( azin_opt( 'course_lessons_title' ) ) ? azin_opt( 'course_lessons_title' ) : __( 'Course lessons', 'azin-file' );
                                            
                                            $tab_icon = azin_opt( 'course_lessons_icon' );
                                            if( ! empty( $tab_icon ) && $tab_icon != 'none' )
                                                $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;

                                            echo $tab_title;
                                            ?>
                                        </a>
                                    </li>
                                <?php } ?>

                                <?php
                                //Output custom tab title in product page
                                for ( $tab_number = 1; $tab_number < 4; $tab_number++ ) {
                                    
                                    $tab = az_dig2word( $tab_number );
                                    $tab_title = rwmb_meta ( 'file_tab_'. $tab .'_title', '', get_the_ID() );

                                    if ( azin_opt( 'custom_product_tab_'. $tab ) && ! empty ( $tab_title ) ) { ?>

                                        <li class="nav-item azin_custom_tab_<?php echo $tab ?>_tab">
                                            <a data-toggle="tab" href="#tab-azin_custom_tab_<?php echo $tab ?>">
                                                <?php
                                                $tab_icon = rwmb_meta ( 'file_tab_'. $tab .'_icon', '', get_the_ID() );

                                                $tab_icon = ! empty( $tab_icon ) && $tab_icon != 'none' ? '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> ' : '';

                                                echo $tab_icon . $tab_title;
                                                ?>
                                            </a>
                                        </li>

                                <?php }
                                } ?>

                                <?php
                                //Product FAQ Tab
                                if ( azin_opt( 'show_faq_product_tab' ) ) {

                                    $show_faq  = rwmb_meta ( 'file_show_faq', '', get_the_ID() );
                                    $faqs      = rwmb_meta( 'file_faqs', '', get_the_ID() );

                                    if( $show_faq && ! empty( $faqs ) ) {
                                        $tab_title = azin_opt( 'faq_product_tab_title' );
                                        $tab_icon  = azin_opt( 'faq_product_tab_icon' );
                                        $tab_title = '<i class="azin-tab-icon fal fa-'. $tab_icon .'"></i> '. $tab_title;
                                        ?>
                                        <li class="nav-item azin_product_faq_tab_tab">
                                            <a data-toggle="tab" href="#tab-azin_product_faq_tab">
                                                <?php echo $tab_title; ?>
                                            </a>
                                        </li>
                                        <?php
                                    }
                                }
                                ?>

                                <?php
                                //Output custom tab content in theme settings
                                for ( $tab_number = 1; $tab_number < 6; $tab_number++ ) {
                                    
                                $tab = az_dig2word( $tab_number );

                                if ( azin_opt( 'show_add_prod_tab_'. $tab ) ) { ?>
                                    <li class="nav-item azin_add_prod_tab_<?php echo $tab ?>_tab">
                                        <a data-toggle="tab" href="#azin_add_prod_tab_<?php echo $tab ?>">
                                            <?php
                                            $tab_icon = azin_opt( 'add_prod_tab_'. $tab .'_icon' );

                                            $tab_icon = ! empty( $tab_icon ) && $tab_icon != 'none' ? '<i class="azin-tab-icon '. $tab_icon .'"></i> ' : '';

                                            echo $tab_icon . azin_opt( 'add_prod_tab_'. $tab .'_title' );
                                            ?>
                                        </a>
                                    </li>
                                <?php }
                                } ?>

                                <li class="nav-item reviews_tab">
                                    <a data-toggle="tab" href="#eddComments">
                                        <?php _e( 'Comments', 'azin-file' ); ?>
                                    </a>
                                </li>

                            </ul>

                            <div class="tab-content ptabs">

                                <div id="pdesc" class="tab-pane active entry-content">
                                    
                                    <?php azin_product_content( get_the_ID() ); ?>

                                </div>

                                <?php if ( azin_opt( 'show_purchased_tab' ) && edd_has_user_purchased( get_current_user_id(), get_the_ID() ) ) { ?>
                                    <div id="azin_purchased" class="tab-pane custom-add-tab entry-content">
                                    
                                        <?php azin_purchased_download_links_content( get_the_ID() ); ?>

                                    </div>
                                <?php } ?>

                                <?php if ( azin_opt( 'show_course_lessons' ) && azin_is_course( get_the_ID() ) && ! edd_has_user_purchased( get_current_user_id(), get_the_ID() ) ) { ?>
                                    <div id="azin_course_lessons" class="tab-pane custom-add-tab entry-content">
                                    
                                        <?php azin_edd_course_lessons_content( get_the_ID() ); ?>

                                    </div>
                                <?php } ?>

                                <?php
                                //Output custom tab content in product page
                                for ( $tab_number = 1; $tab_number < 4; $tab_number++ ) {
                                    
                                    $tab = az_dig2word( $tab_number );
                                    $tab_title = rwmb_meta ( 'file_tab_'. $tab .'_title', '', get_the_ID() );

                                    if ( azin_opt( 'custom_product_tab_'. $tab ) && ! empty ( $tab_title ) ) { ?>
                                        <div id="tab-azin_custom_tab_<?php echo $tab ?>" class="tab-pane custom-add-tab entry-content">
                                            <?php
                                            $content = rwmb_meta ( 'file_tab_'. $tab .'_content', '', get_the_ID() );
                                            echo azin_output_content( $content );
                                            ?>
                                        </div>
                                <?php }
                                } ?>

                                <?php
                                //Product FAQ Tab
                                if ( azin_opt( 'show_faq_product_tab' ) ) {

                                    $show_faq  = rwmb_meta ( 'file_show_faq', '', get_the_ID() );
                                    $faqs      = rwmb_meta( 'file_faqs', '', get_the_ID() );

                                    if( $show_faq && ! empty( $faqs ) ) {
                                        $count = 1;
                                        $faqnumber = 1;
                                    ?>
                                        <div id="tab-azin_product_faq_tab" class="tab-pane custom-add-tab entry-content">
                                            <div id="accordion" class="azin-faq-accordion">
                                                <?php
                                                foreach ( $faqs as $faq ) {
                                                    if ( $count % 2 != 0 ){
                                                    ?>
                                                        <div class="card">
                                                            <div class="card-header" id="heading<?php echo $faqnumber; ?>">
                                                                <h5 class="mb-0">
                                                                    <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse<?php echo $faqnumber; ?>" aria-expanded="false" aria-controls="collapse<?php echo $faqnumber; ?>">
                                                                        <?php echo $faq ?>
                                                                    </button>
                                                                </h5>
                                                            </div>
                                            
                                                            <div id="collapse<?php echo $faqnumber; ?>" class="collapse" aria-labelledby="heading<?php echo $faqnumber; ?>" data-parent="#accordion" style="">
                                                                <div class="card-body azin-accordion-body">
                                                        <?php
                                                        $faqnumber++;
                                                    } else {
                                                        echo $faq;
                                                    ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    
                                                    <?php
                                                    }
                                                    $count++;
                                                }
                                                ?>
                                            </div>
                                        </div>
                                    <?php
                                    }
                                }
                                ?>

                                <?php
                                //Output custom tab content in theme settings
                                for ( $tab_number = 1; $tab_number < 6; $tab_number++ ) {
                                    
                                    $tab = az_dig2word( $tab_number );

                                    if ( azin_opt( 'show_add_prod_tab_'. $tab ) ) { ?>
                                        <div id="azin_add_prod_tab_<?php echo $tab ?>" class="tab-pane custom-add-tab entry-content">
                                            <?php echo azin_output_content( azin_opt( 'add_prod_tab_'. $tab .'_content' ) ); ?>
                                        </div>
                                <?php }
                                } ?>

                                <div id="eddComments" class="tab-pane comment-tab fade">
                                    <?php comments_template(); ?>
                                </div>

                            </div>
                        </div>
                    </article>

                    <?php if ( ! azin_opt( 'product_style_two' ) ) :
                        if ( ! azin_opt( 'show_related_top' ) )
                            azin_show_related_product( get_the_ID() );

                        azin_show_related_product_posts( get_the_ID() );
                    endif; ?>

                <?php endwhile; ?>

                <?php az_product_foot_banner(); ?>                        
                
            <?php } ?>
        
        <?php endif; ?>
    </div>

    <?php
    if ( ! azin_opt( 'product_style_two' ) && azin_opt( 'remove_product_sidebar' ) ) {
        //Show nothing
    } else { ?>
        <aside class="col-lg-3 side-bar<?php echo az_show_side_mobile(); if ( azin_opt( 'sticky_side' ) ) { echo ' side-sticky'; } ?>">
            <?php
            if ( azin_is_course( get_the_ID() ) && azin_opt( 'course_side' ) ) {
                if ( is_active_sidebar( 'product-course-sidebar' ) ) {
                    dynamic_sidebar( 'product-course-sidebar' );
                }
            } elseif ( azin_opt( 'edd_side' ) ) {
                if ( is_active_sidebar( 'shop-sidebar' ) ) {
                    dynamic_sidebar( 'shop-sidebar' );
                }
            } else {
                get_template_part( 'right-sidebar' );
            }
            ?>
        </aside>
    <?php } ?>

</div>

<?php 
    if ( azin_opt( 'product_style_two' ) ) :
        if ( ! azin_opt( 'show_related_top' ) )
            azin_show_related_product( get_the_ID() );

        azin_show_related_product_posts( get_the_ID() );
    endif;
?>

<?php
azin_wrapper_end();

get_footer();