<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;
get_header();

azin_wrapper_start();

if ( azin_opt( 'show_next_prev_post' ) ) {
    require_once AZ_DIR . '/includes/next-prev.php';
}

$lock_post_content = rwmb_meta( 'file_lock_post_content', '', get_the_ID() ) == 1 ? true : false;
$hide_related_posts = rwmb_meta( 'file_hide_related_posts', '', get_the_ID() ) == 1 ? true : false;
$hide_author_block = rwmb_meta( 'file_hide_author_block', '', get_the_ID() ) == 1 ? true : false;
$post_sidebar = azin_opt( 'remove_post_sidebar' ) ? 'wside col-12' : p_sidebar( get_the_ID() );
?>

<div class="row main<?php side_type(); ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

    <div class="<?php echo $post_sidebar; if ( azin_opt( 'sticky_side' ) ) { echo ' pcol'; }?>">

        <?php az_post_head_banner(); ?>

        <?php if ( have_posts() ) :
            while ( have_posts() ) : the_post(); ?>

                <article role="main" class="scon" id="post-<?php the_ID(); ?>" <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="blogPost" itemscope itemtype="https://schema.org/BlogPosting"<?php } ?>>
                    
                    <?php if ( azin_opt( 'site_schema' ) ) { ?>
                    <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
                    <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>">
                    <span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
                        <span itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
                            <meta itemprop="url" content="<?php echo azin_to_https( azin_opt( 'site_logo', 'url' ) ); ?>">
                            <meta itemprop="width" content="140">
                            <meta itemprop="height" content="60">
                        </span>
                        <meta itemprop="name" content="<?php bloginfo( 'name' ); ?>">
                    </span>
                    <?php } ?>

                    <div class="s-product">
                        <?php if ( ! azin_opt( 'bread_style_two' ) ) { ?>

                            <header>
                                <div class="post-title">
                                    <h1 <?php if ( azin_opt( 'site_schema' ) ) { ?>itemprop="name headline"<?php } ?>>
                                        <?php the_title(); ?>
                                    </h1>
                                    <div class="post-extra">
                                        <?php if ( function_exists("az_star_ratings") && ( azin_opt( 'star_rating' ) ) ) { ?>
                                        <div class="rating">
                                            <?php echo az_star_ratings( get_the_ID() ); ?>
                                        </div>
                                        <?php } ?>
                                        <?php if ( azin_opt( 'social_share' ) ) { ?>
                                        <span tabindex="0" class="share-btn" data-toggle="modal" data-target="#shareModal">
                                            <i class="fal fa-share-alt" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Share', 'azin-file' ) ?>"></i>
                                        </span>
                                        <?php } ?>
                                    </div>
                                </div>
                            </header>

                        <?php } ?>

                        <div class="post-con entry-content" <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="articleBody"<?php } ?>>
                                        
                            <?php
                            
                            if ( ! is_user_logged_in() && $lock_post_content ) {
                                azin_locked_content();
                            } else {

                            ?>

                            <?php do_action( 'azin_before_post_details' ) ?>

                            <!-- Article Attr -->
                            <div class="row row-post-details row-post-details-top">

                                <?php if ( azin_opt( 'show_post_author' ) ) { ?>
                                    <div class="pattr azin-post-time" <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="author" itemscope itemtype="https://schema.org/Person"<?php } ?>>
                                        <i class="fal fa-user po-picon"></i>
                                        <?php _e( 'Author: ', 'azin-file' ); ?>
                                        <span>
                                            <a class="author-link" itemprop="url" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                                                <span <?php if ( azin_opt( 'site_schema' ) ) {?> itemprop="name"<?php } ?>>
                                                    <?php the_author(); ?>
                                                </span>
                                            </a>
                                        </span>
                                    </div>
                                <?php } ?>

                                <?php if ( azin_opt( 'show_post_date' ) ) { ?>
                                    <div class="pattr azin-post-date">
                                        <i class="fal fa-calendar po-picon"></i>
                                        <?php _e( 'Publication date: ', 'azin-file' ); ?>
                                        <span>
                                        <?php if ( azin_opt( 'site_schema' ) ) { ?>
                                            <?php if ( function_exists( 'eng_number' ) ) { ?>
                                                <time datetime="<?php echo gregdate("c", eng_number( get_the_time( 'c' ) )); ?>" itemprop="datePublished">
                                            <?php } else { ?>
                                                <time datetime="<?php echo get_the_date( 'Y-m-d' ); ?>" itemprop="datePublished">
                                            <?php } } ?>
                                            <?php
                                                if( azin_opt( 'show_post_update' ) ){
                                                    echo get_the_modified_time( 'j F Y' );
                                                } else {
                                                    echo get_the_date( 'j F Y' );
                                                }
                                            ?>
                                            <?php if ( azin_opt( 'site_schema' ) ) { ?>
                                            </time>
                                            <?php } ?>
                                            <?php if ( azin_opt( 'site_schema' ) ) {?>
                                            <?php if ( function_exists( 'eng_number' ) ) { ?>
                                                <meta content="<?php echo gregdate("c", eng_number( get_the_time( 'c' ) )); ?>" itemprop="dateModified">
                                            <?php } else { ?>
                                                <meta content="<?php echo get_the_date( 'Y-m-d' ); ?>" itemprop="dateModified">
                                            <?php } } ?>
                                        </span>
                                    </div>
                                <?php } ?>
                                
                                <?php if ( azin_opt( 'show_post_view' ) ) { ?>
                                    <div class="pattr azin-post-views">
                                        <i class="fal fa-eye po-picon"></i>
                                        <?php _e( 'Views: ', 'azin-file' ); ?>
                                        <span>
                                            <?php setPostViews( get_the_ID() ); ?>
                                            <?php echo getPostViews( get_the_ID() ); ?>
                                        </span>
                                    </div>
                                <?php } ?>

                                <?php 
                                    $az_reading_time = rwmb_meta( 'az_reading_time' );
                                    if ( ! empty( $az_reading_time ) ) { ?>
                                    <div class="pattr azin-post-time">
                                        <i class="fal fa-clock po-picon"></i>
                                        <?php _e( 'Reading time: ', 'azin-file' ); ?>
                                        <span>
                                            <?php echo $az_reading_time; ?>
                                        </span>
                                    </div>
                                <?php } ?>

                            </div>
                            <!-- Article Attr -->

                            <?php do_action( 'azin_after_post_details' ) ?>
                                
                            <?php
                                $az_video_thumb = rwmb_meta( 'az_video_thumb' );
                                $az_aparat_thumb = rwmb_meta( 'az_aparat_thumb' );
                                if ( azin_opt( 'show_post_thumb_video' ) && ( ! empty ( $az_video_thumb ) || ! empty ( $az_aparat_thumb ) ) ) {
                                    echo '<div class="post-thumb">';
                                        if ( ! empty ( $az_aparat_thumb ) ) {
                                            echo '<style>.h_iframe-aparat_embed_frame{position:relative;}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}</style><div class="h_iframe-aparat_embed_frame"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'.$az_aparat_thumb.'/vt/frame" title="'.get_the_title( $id ).'" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>';
                                        } elseif ( ! empty ( $az_video_thumb ) ) {
                                            echo do_shortcode( '[video src="'. $az_video_thumb .'" preload="none"]' );
                                        }
                                    echo '</div>';
                                } elseif ( has_post_thumbnail() && azin_opt( 'show_post_thumb' ) ) {
                            ?>
                                <div class="post-thumb">
                                    <?php the_post_thumbnail( 'full' ); ?>
                                </div>
                            <?php
                                } ?>

                            <?php do_action('azin_before_post_content'); ?>

                            <?php if ( azin_opt( 'text_summ' ) ) { ?>
                                <div class="single-text">
                            <?php } ?>

                            <?php the_content(); ?>

                            <?php
                                $defaults = array(
                                    'before'           => '<div class="text-center apage-break">',
                                    'after'            => '</div>',
                                    'link_before'      => '',
                                    'link_after'       => '',
                                    'next_or_number'   => 'text',
                                    'separator'        => ' ',
                                    'nextpagelink'     => '<span class="btn azin-btn">' . __( 'Next page', 'azin-file' ) . '<i aria-hidden="true" class="fal fa-angle-left"></i></span>',
                                    'previouspagelink' => '<span class="btn azin-btn"><i aria-hidden="true" class="fal fa-angle-right"></i>' . __( 'Prev page', 'azin-file' ) . '</span>',
                                    'pagelink'         => '%',
                                    'echo'             => 1
                                );
                                wp_link_pages( $defaults);
                            ?>

                            <?php if ( azin_opt( 'text_summ' ) ) { ?>
                                <p class="read-more">
                                    <a href="#" class="sbutton">
                                        <?php echo azin_opt( 'text_read_more' ); ?>
                                    </a>
                                </p>
                            </div>

                            <?php } ?>

                            <?php azin_dl_box( get_the_ID() ); ?>

                            <?php do_action('azin_after_post_content'); ?>

                            <footer class="details">
                                    
                                <?php if ( azin_opt( 'show_post_cat' ) ) { ?>
                                    <div class="p-tags">
                                        <?php the_terms( get_the_ID(), 'category', '<div class="p-tags"><span class="fal fa-folder-open"></span>'.__( 'Categories', 'azin-file' ), '', '</div>' ); ?>
                                    </div>
                                <?php } ?>

                                <?php if ( azin_opt( 'show_post_tags' ) && has_tag() ) { ?>
                                    <div class="p-tags" <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="keywords"<?php } ?>>
                                        <?php the_tags( '<span class="fal fa-tags"></span>'.azin_opt( 'text_tags' ).'&nbsp;', '', '' ); ?>
                                    </div>
                                <?php } ?>

                            </footer>
                            
                            <?php } ?>

                        </div>
                    </div>
                </article>

                <?php
                //Start Post Author Block
                if ( ( ! is_user_logged_in() && $lock_post_content ) || $hide_author_block ) {
                    //do nothing
                } else {
                    if ( azin_opt( 'show_author_box' ) ) { ?>
                    <div class="author-page">
                        <div class="row">

                            <?php if ( azin_opt( 'show_author_box_avatar' ) ) { ?>
                            <div class="col-md-2 col-12 uavatar">
                                <?php $author = get_post_field( 'post_author', get_the_ID() ); ?>
                                <?php echo get_avatar( $author , 128, '',get_the_author_meta( 'display_name', $author ) ); ?>
                            </div>
                            <?php } ?>

                            <div class="<?php echo azin_opt( 'show_author_box_avatar' ) ? 'col-md-10 col-12' : 'col-12'; ?>">

                                <?php if ( azin_opt( 'show_author_box_name' ) ) { ?>
                                <div class="row author-name">
                                    <?php echo get_the_author_meta( 'display_name', $author ); ?>
                                    <?php if ( class_exists( 'WeDevs_Dokan' ) ) { ?>
                                        <?php $vendor_rating = az_get_vendor_rating( $author );
                                        if ( $vendor_rating['count'] ) { ?>
                                        <span class="az-seller-rating">
                                            <?php echo wp_kses_post(dokan_get_readable_seller_rating( $author ) ); ?>
                                        </span>
                                    <?php } } ?>
                                </div>
                                <?php } ?>

                                <?php if ( azin_opt( 'show_author_box_bio' ) ) { ?>
                                <div class="author-bio">
                                    <?php echo get_the_author_meta( 'description', $author ); ?>
                                </div>
                                <?php } ?>

                                <div class="row author-det">
                                    <div class="col-12 author-attr">

                                        <?php if ( azin_opt( 'show_author_box_products' ) ) { ?>
                                        <?php $post_type = az_woo() ? 'product' : 'download'; ?>
                                            <i class="fal fa-shopping-bag author-icon" data-toggle="tooltip" data-placement="top" title="<?php echo count_user_posts( $author, $post_type, true  ) . __( ' Product', 'azin-file' ); ?>"></i>
                                        <?php } ?>

                                        <?php if ( azin_opt( 'course_sales_activation' ) && azin_opt( 'show_author_box_courses' ) ) { ?>
                                            <i class="fal fa-graduation-cap author-icon" data-toggle="tooltip" data-placement="top" title="<?php echo azin_count_course( $author ) . __( ' Course', 'azin-file' ); ?>"></i>
                                        <?php } ?>

                                        <?php if ( azin_opt( 'show_author_box_posts' ) ) { ?>
                                        <i class="fal fa-file-alt author-icon" data-toggle="tooltip" data-placement="top" title="<?php echo count_user_posts( $author , "post", true  ) . __( ' Post', 'azin-file' ) ?>"></i>
                                        <?php } ?>

                                        <?php if ( azin_opt( 'show_author_box_regdate' ) ) { ?>
                                        <i class="fal fa-user-plus author-icon"  data-toggle="tooltip" data-placement="top" title="<?php _e( 'Subscribe from ', 'azin-file' ); azin_register_date( $author ); ?>"></i>
                                        <?php } ?>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <?php } 
                }

                //related_posts
                if ( ! $hide_related_posts ) {
                    azin_show_related_post( get_the_ID() );

                    azin_show_related_post_products( get_the_ID() );
                }
                //related_posts

            endwhile; ?>

        <?php az_post_foot_banner(); ?>

        <?php
        if ( ! is_user_logged_in() && $lock_post_content ) {
            //do nothing
        } else {
            //Start Comments
            if ( comments_open() ) : ?>
            <div class="comments-con">
                <div class="comments-list">
                    <?php comments_template(); ?>
                </div>
            </div>
            <?php endif;
            //End Comments
        } ?>

        <?php endif; ?>

    </div>


    <?php
    if ( ! azin_opt( 'remove_post_sidebar' ) ) {
        if ( ( rwmb_meta( 'file_wside' ) != 1 ) && ( rwmb_meta( 'file_wside' ) != 'noside' ) ) {
        ?>
            <aside class="col-lg-3 side-bar<?php echo az_show_side_mobile(); if ( azin_opt( 'sticky_side' ) ) { echo ' side-sticky'; } ?>">
                <?php get_template_part( 'right-sidebar' ); ?>
            </aside>
        <?php }
    } ?>

</div>

<?php

azin_wrapper_end();

get_footer();