<?php

// Exit if accessed directly
if (!defined('ABSPATH' )) {
    exit;
}

 ?>

<header class="azin-header">

    <div class="container-fluid head">

        <div class="container header hidden-xs">

        <?php if ( ! azin_opt( 'hide_top_bar' ) ) { ?>
            <!-- .row-social -->
            <div class="row row-social<?php if ( azin_opt( 'social_pos' ) == 2 ) { echo ' social-right'; }?>">

                <!-- Header Contact -->
                <div class="col-md-6 col-12 head-contact">
                    <?php azin_head_contact(); ?>
                </div>
                <!-- Header Contact -->
                
                <?php if ( ! azin_opt( 'hide_header_social' ) ) { ?>
                <!-- Header Social Buttons -->
                <div class="col-md-6 col-12 head-social">
                    <?php azin_social_links( 'social', true, false ); ?>
                </div>
                <!-- Header Social Buttons -->
                <?php } ?>

            </div>
            <!-- /.row-social -->
        <?php } ?>

        <!-- .row-logo -->
        <div class="row row-logo <?php if ( azin_opt( 'logo_pos' ) == 2 ) { echo 'logo-right'; } ?>">

            <div class="col-md-3 hidden-xs user-btns">
            <?php if ( azin_opt( 'show_user_btn' ) ) {
            if ( is_user_logged_in() ) {
                $user = wp_get_current_user(); ?>
                <div class="dropdown">
                    <button class="dropdown-toggle user-btn" type="button" data-toggle="dropdown">
                        <?php echo get_avatar( get_current_user_id(), 30, '', $user->display_name); ?>
                        <span class="user-name"><?php echo $user->display_name; ?></span>
                        <?php if ( class_exists( 'EDD_Wallet' ) ) { 
                            echo '<span class="hidden-sm">';
                            $wallet = edd_currency_filter(edd_wallet()->wallet->balance( get_current_user_id() ) );
                            echo ' | '. $wallet;
                            echo '</span>';
                        }
                        if ( class_exists( 'WooWallet' ) ) {
                            echo '<span class="hidden-sm">';
                            $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                            echo ' | '. $wallet;
                            echo '</span>';
                        } ?>
                        <span class="fal fa-chevron-down user-chevron-down" aria-hidden="true"></span>
                    </button>
                    <?php if ( azin_opt( 'replace_user_menu' ) && has_nav_menu( 'user_menu' ) ) { ?>
                        <?php
                            wp_nav_menu( array(
                                'menu'              => 'user_menu',
                                'theme_location'    => 'user_menu',
                                'menu_class'        => 'dropdown-menu user-menu mu-menu',
                                'depth'             => 1,
                                'container'         => '',
                                'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                                'walker'            => new Yamm_Nav_Walker()
                                )
                            );
                        ?>
                    <?php } else { ?>
                        <ul class="dropdown-menu user-menu mu-menu">
                            <?php
                                if ( az_woo() ) {
                                    require AZ_DIR .'/includes/woo/umenu.php';
                                } else {
                                    require AZ_DIR .'/includes/edd/umenu.php';
                                } ?>
                        </ul>
                    <?php } ?>
                </div>
            <?php } else { ?>
                <?php if ( azin_opt( 'replace_userbtns_shortcode' ) ) { 
                    echo do_shortcode( azin_opt( 'userbtns_shortcode' ) );
                } elseif ( function_exists( 'digits_version' ) && azin_opt( 'digits_mode' ) ) {
                    $digits_link = ( azin_opt( 'digits_page' ) ? 'digitlink' : 'digitpopup' ); ?>
                
                    <span title="<?php _e( 'Login or Register', 'azin-file' ) ?>" class="btn btn-primary register-btn user-btn reg-btn digitsbtn <?php echo $digits_link; ?>">
                        <i aria-hidden="true" class="fal fa-user"></i>
                        <span class="hidden-sm"><?php _e( 'Login', 'azin-file' ) ?></span>
                        /
                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                        <span class="hidden-sm"><?php _e( 'Register', 'azin-file' ) ?></span>
                    </span>
                <?php } elseif ( az_woo() && azin_opt( 'merge_user_btn' ) ) { ?>
                    <a title="<?php _e( 'Login or Register', 'azin-file' ) ?>" class="btn btn-primary register-btn user-btn reg-btn digitsbtn" <?php if ( azin_opt( 'ch_login_link' ) ) {echo 'href="'.azin_opt( 'login_link' ).'"'; } else {echo 'href="' . get_myaccount_link() .'"';} ?>>
                        <i aria-hidden="true" class="fal fa-user"></i>
                        <span class="hidden-sm"><?php _e( 'Login', 'azin-file' ) ?></span>
                        /
                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                        <span class="hidden-sm"><?php _e( 'Register', 'azin-file' ) ?></span>
                    </a>
                <?php } else { ?>
                <a class="logged-btn user-btn login-btn btn btn-outline-primary" <?php if ( !azin_opt( 'ch_login_link' ) ) { echo 'href="#" onclick="openLogin()"';
                    } else {
                    echo 'href="' .azin_opt( 'login_link' ).'"';
                    } ?>>
                    <span class="fal fa-user user-icon"></span>
                    <span class="hidden-sm"><?php echo azin_opt( 'text_login' ); ?></span>
                </a><a href="<?php echo azin_register_link() ?>" title="<?php echo azin_opt( 'text_reg_hint' ); ?>" class="btn btn-primary register-btn user-btn reg-btn">
                    <span class="fal fa-user-plus reg-icon"></span>
                    <span class="hidden-sm"><?php echo azin_opt( 'text_register' ); ?></span>
                </a>
                <?php }//End digits_mode ?>
                <?php }//End is_user_logged_in() ?>
                <?php }//End show_user_btn ?>
            </div>
            
            <div class="col-md-6 s-form">
                <?php
                if ( azin_opt( 'hide_search_home' ) && is_front_page()  ) {
                    //Do Nothing
                } else {
                    if ( ! azin_opt( 'replace_search_shortcode' ) ) {
                        azin_search_form( 'col-md-11 col-12', 'searchformh', true, 'searchsubmith' );
                    } else {
                        echo do_shortcode( azin_opt( 'search_shortcode' ) );
                    }
                }
                ?>
            </div>

            <div role="banner" class="col-md-3 col-12 azin-logo logo">
                <?php if ( is_front_page() && azin_opt( 'add_home_heading' ) ) { ?>
                    <h1>
                <?php } ?>
                <a href="<?php echo azin_logo_link(); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" rel="home">
                <?php
                $logo_width  = ( ! empty( azin_opt( 'site_logo', 'width' ) ) ) ? azin_opt( 'site_logo', 'width' ) : '140';
                $logo_height = ( ! empty( azin_opt( 'site_logo', 'height' ) ) ) ? azin_opt( 'site_logo', 'height' ) : '60';
                $srcset      = ( ! empty( azin_opt( 'site_logo_retina', 'url' ) ) ) ? ' srcset="'. azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ) .' 2x"' : '';
                ?>
                    <img <?php if ( azin_opt( 'site_schema' ) ) {?>itemprop="logo" <?php } ?> src="<?php echo azin_to_https( azin_opt( 'site_logo', 'url' ) ) ?>"<?php echo $srcset ?> width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" class="img-logo"/>
                    <strong>
                        <?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>
                    </strong>
                </a>
                <?php if ( is_front_page() && azin_opt( 'add_home_heading' ) ) { ?>
                    </h1>
                <?php } ?>
            </div>

        </div>

        </div>

    </div>
    
    
    <nav class="azin-navbar azin-navbar-search azin-nav<?php if ( azin_opt( 'focus_nav' ) ) { echo ' focus-nav'; } ?> nav navbar-expand-sm<?php if ( azin_opt( 'fixed_head_top' ) ) { echo ' fixed-nav'; }?>" id="nav-row" <?php if ( azin_opt( 'site_schema' ) ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
        <div class="container hidden-xs nav-con">
            <!-- Collect the nav links from WordPress -->
            <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">         
                <?php
                $args = array(
                    'menu'              => 'primary',
                    'theme_location'    => 'primary',
                    'depth'             => 4,
                    'container'         => 'div',
                    'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                    'walker'            => new Yamm_Nav_Walker()
                    );

                    
                $args['menu_class'] = 'nav navbar-nav ';

                $args['menu_class'] .= ( azin_opt( 'mega_style' ) == 'second' ? 'yamm-s ' : 'yamm ' );

                if ( azin_opt( 'fixed_head_logo' ) ) {
                    if( azin_opt( 'site_schema' ) ) { $itemprop = 'itemprop="logo"'; } else { $itemprop = ''; }
                    if( azin_opt( 'change_fixed_logo' ) && ! empty( azin_to_https( azin_opt( 'sticky_logo', 'url' ) ) ) ) {
                        $sticky_logo = '<li class="sticky-logo"><a href="'. azin_logo_link() .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                    <img '. $itemprop .'src="'. azin_to_https( azin_opt( 'sticky_logo', 'url' ) ) .'" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" data-no-lazy="1" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="azin-sticky-logo"/>
                                </a></li>';
                    } else {
                        $srcset      = ( ! empty( azin_opt( 'site_logo_retina', 'url' ) ) ) ? ' srcset="'. azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ) .' 2x"' : '';
                        $sticky_logo = '<li class="sticky-logo"><a href="'. azin_logo_link() .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                    <img '. $itemprop .'src="'. azin_to_https( azin_opt( 'site_logo', 'url' ) ) .'"'. $srcset .' data-no-lazy="1" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="azin-sticky-logo"/>
                                </a></li>';
                    }
                    
                    $items_wrap = '<ul id="%1$s" class="%2$s">'.$sticky_logo.'%3$s';
                    $items_wrap .= '</ul>';
                    $args['items_wrap'] = $items_wrap;
                }

                wp_nav_menu( $args);
            ?>
            
            </div><!-- ./collapse -->

            <?php if( azin_opt( 'show_like_btn_head' ) && ( class_exists( 'YITH_WCWL' ) || class_exists( 'EDD_Wish_Lists' ) ) ) {

                if ( az_woo() ) {
                    $wishlist_url = esc_url( YITH_WCWL()->get_wishlist_url() );
                } else {
                    $wishlist_url = azin_edd_whishlist_url();
                } ?>

                <div class="head-btn-like azin-yith-wcwl-btn">

                    <a href="<?php echo $wishlist_url; ?>" class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Wishlist', 'azin-file'); ?>">
                        <i aria-hidden="true" class="fal fa-heart"></i>

                        <?php if ( class_exists('YITH_WCWL') ) { ?>
                        <span class="wish-amount">
                            <?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?>
                        </span>
                        <?php } ?>

                    </a>
                    
                </div>

            <?php } ?>

            <?php if( azin_opt( 'show_cart_btn_head' ) ) {
                if ( az_woo() ) {
                    $cart_count = WC()->cart->get_cart_contents_count();
                    $cart_url = wc_get_cart_url();
                } else {
                    $cart_count = edd_get_cart_quantity();
                    $cart_url = edd_get_checkout_uri();
                } ?>
                <div class="btn-cart">

                <?php if ( azin_opt( 'link_cart_page' ) ) { ?>
                    <a href="<?php echo $cart_url; ?>" class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Shopping cart', 'azin-file'); ?>">
                    
                    <i aria-hidden="true" class="fal fa-shopping-bag"></i>

                    <?php if ( azin_opt( 'show_cart_number' )) { ?>
                    <span class="edd-cart-quantity">
                        <?php echo $cart_count ?>
                    </span>
                    <?php } ?>

                    </a>
                <?php } else { ?>
                    <span onclick="openCart()" class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Shopping cart', 'azin-file'); ?>">
                    
                    <i aria-hidden="true" class="fal fa-shopping-bag"></i>

                    <?php if ( azin_opt( 'show_cart_number' )) { ?>
                    <span class="edd-cart-quantity">
                        <?php echo $cart_count ?>
                    </span>
                    <?php } ?>

                    </span>
                <?php } ?>

                </div>
            <?php } ?>

            <?php do_action( 'azin_before_blog_btn' ); ?>

            <?php if ( azin_opt( 'blog_menu' ) ) { ?>
            <a class="btn <?php echo azin_opt( 'blog_color' ); ?> blog-btn hidden-sm" href="<?php echo azin_opt( 'blog_link' ); ?>">
                <?php echo '<span class="'.azin_opt( 'blog_icon' ). '"></span> ' . azin_opt( 'blog_text' ); ?>
            </a>
            <?php } ?>

            <?php do_action( 'azin_after_blog_btn' ); ?>

        </div>

        <div class="visible-xs mobile-header<?php if (azin_opt( 'mobile_logo_pos' ) == 1) {echo ' mobile-right-logo';} ?>">

            <?php if ( ! azin_opt( 'hide_top_bar' ) ) { ?>
                <?php if ( azin_opt( 'show_mobile_head_contact' ) ) { ?>
                    <!-- Mobile Contact -->
                    <div class="col-12 mobile-head-contact">
                        <?php azin_head_contact(); ?>
                    </div>
                    <!-- Mobile Contact -->
                <?php } ?>
                        
                <?php if ( azin_opt( 'show_mobile_head_social' ) ) { ?>
                    <!-- Mobile Social Buttons -->
                    <div class="col-12 mobile-head-social">
                        <?php azin_social_links( 'social', true, false ); ?>
                    </div>
                    <!-- Mobile Social Buttons -->
                <?php } ?>
            <?php } ?>

            <div class="col-6 mobile-logo">
                <a href="<?php echo azin_logo_link(); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" rel="home">
                    <?php 
                    $logo_width  = ( ! empty( azin_opt( 'site_logo', 'width' ) ) ) ? azin_opt( 'site_logo', 'width' ) : '140';
                    $logo_height = ( ! empty( azin_opt( 'site_logo', 'height' ) ) ) ? azin_opt( 'site_logo', 'height' ) : '60';
                    $srcset      = ( ! empty( azin_opt( 'site_logo_retina', 'url' ) ) ) ? ' srcset="'. azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ) .' 2x"' : '';
                    ?>
                    <img src="<?php echo azin_to_https( azin_opt( 'site_logo', 'url' ) ) ?>"<?php echo $srcset ?> width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" />
                </a>
            </div>
        
            <div class="col-6 mobile-user-btns">
                <span class="btn btn-outline-primary logged-btn mm-btn" onclick="openmNav()">
                    <i class="fal fa-bars"></i>
                </span>

                <?php if ( azin_opt( 'show_user_btn' ) ) {
                    if ( is_user_logged_in() ) { ?>
                        <span class="btn btn-outline-primary logged-btn ml-btn" onclick="openNav()">
                            <i aria-hidden="true" class="fal fa-user"></i>
                        </span>
                    <?php } else { ?>
                            <?php if ( azin_opt( 'replace_userbtns_shortcode' ) ) { 
                                echo do_shortcode( azin_opt( 'userbtns_shortcode' ) );
                            } elseif ( function_exists( 'digits_version' ) && azin_opt( 'digits_mode' ) ) {
                                $digits_link = ( azin_opt( 'digits_page' ) ? 'digitlink' : 'digitpopup' ); ?>
                                    <span title="<?php _e( 'Login or Register', 'azin-file' ) ?>" class="btn btn-primary register-btn digitsbtn <?php echo $digits_link; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                    </span>
                            <?php } elseif ( az_woo() && azin_opt( 'merge_user_btn' ) ) { ?>
                                <a title="<?php _e( 'Login or Register', 'azin-file' ) ?>" class="btn btn-primary register-btn digitsbtn" <?php if ( azin_opt( 'ch_login_link' ) ) {echo 'href="'.azin_opt( 'login_link' ).'"'; } else {echo 'href="' . get_myaccount_link() .'"';} ?>>
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                    /
                                    <i aria-hidden="true" class="fal fa-user-plus"></i>
                                </a>
                            <?php } else { ?>

                                <a class="btn btn-outline-primary ml-btn logged-btn" <?php if ( !azin_opt( 'ch_login_link' ) ) { echo 'href="#" onclick="openLogin()"'; } else { echo 'href="' .azin_opt( 'login_link' ).'"'; } ?>>
                                    <span class="fal fa-sign-in-alt user-icon"></span>
                                </a>

                                <a href="<?php echo azin_register_link() ?>" title="<?php echo azin_opt( 'text_reg_hint' ); ?>" class="btn btn-primary register-btn mu-btn">
                                    <span class="fal fa-user-plus"></span>
                                </a> 
                            <?php } ?>
                    <?php }
                } ?>
            </div>

            <div class="col-12 mobile-search d-flex">
                <?php
                if ( ! azin_opt( 'replace_search_shortcode' ) ) {
                    $search_form_class = ( azin_opt( 'show_cart_btn_head' ) ? 'msform' : 'col-12 msform' );
                    azin_search_form( $search_form_class, 'searchformm', true, 'searchsubmitm' );
                } else {
                    echo do_shortcode( azin_opt( 'search_shortcode' ) );
                }
                ?>
                <?php if( azin_opt( 'show_cart_btn_head' ) ) { ?>
                <div class="btn-cart">
                    <span class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Shopping cart', 'azin-file'); ?>" onclick="openCart()">
                        <i aria-hidden="true" class="fal fa-shopping-bag"></i>
                        <span class="edd-cart-quantity">
                            <?php
                            if ( az_woo() ) {
                                echo WC()->cart->get_cart_contents_count();
                            } else {
                                echo edd_get_cart_quantity();
                            } ?>
                        </span>
                    </span>
                </div>
                <?php } ?>
            </div>

        </div>
        
    </nav>
    

</header>

<?php do_action ( 'azin_after_header' ); ?>