<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <?php if( ! azin_opt( 'dis_mobile_color' ) ) { ?>
        <meta name="theme-color" content="<?php echo ( azin_opt( 'ch_mobile_color' ) ? azin_opt( 'mobile_bar_color' ) : azin_opt( 'custom_color' ) ); ?>" />
    <?php } ?>
    <title>
        <?php bloginfo( 'name' ); ?>
    </title>
    <link rel="shortcut icon" href="<?php echo azin_to_https( azin_opt( 'site_favicon', 'url' ) ); ?>" type="image/x-icon" />
    <link rel="apple-touch-icon" href="<?php echo azin_to_https( azin_opt( 'site_favicon', 'url' ) ); ?>">
    <style>
        .container.under{
            color:<?php echo azin_opt( 'maintenance_text_color' ); ?>!important;
        }
    </style>
    <?php wp_head(); ?>
</head>

<body class="maintenance-mode">
    <div class="container-fluid">
        <div class="row">
            <div class="container under">

                <h1>
                    <a href="<?php echo azin_logo_link(); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" rel="home">
                    <?php 
                        $logo_width = ( ! empty( azin_opt( 'site_logo_retina', 'width' ) ) ) ? azin_opt( 'site_logo_retina', 'width' ) : '280';
                        $logo_height = ( ! empty( azin_opt( 'site_logo_retina', 'height' ) ) ) ? azin_opt( 'site_logo_retina', 'height' ) : '120'; ?>
                        <img class="skip-lazy" src="<?php echo azin_to_https( azin_opt( 'site_logo_retina', 'url' ) ); ?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>" />
                    </a>
                </h1>

                <?php
                //show maintenance mode countdown
                $date = azin_opt( 'date_counter' );
                if( azin_opt( 'show_counter' ) && !empty( $date ) ) {
                    
                    $date = date("Y/m/d",strtotime($date) );
                    
                    $now = time(); // or your date as well
                    $end_date = strtotime($date);
                    $diff = $end_date - $now;
                    $datediff = round($diff / (60 * 60 * 24) );
                ?>
                <div class="salecount <?php echo azin_opt( 'sale_count_style' ) ?> col-12" data-datediff="<?php echo $datediff; ?>" data-countdown="<?php echo $date; ?>" data-dir="<?php echo (is_rtl() )?'rtl':'ltr';?>" data-seconds="<?php _e( 'Seconds' , 'azin-file'); ?>" data-minutes="<?php _e( 'Minutes' , 'azin-file'); ?>" data-hours="<?php _e( 'Hours' , 'azin-file'); ?>" data-days="<?php _e( 'Days' , 'azin-file'); ?>" data-weeks="<?php _e( 'Weeks' , 'azin-file'); ?>">
                </div>
                <?php }  ?>

                <h2>
                    <?php echo azin_opt( 'maintenance_title' ); ?>
                </h2>

                <h3>
                    <?php echo do_shortcode( azin_opt( 'maintenance_msg' ) ); ?>
                </h3>

                <?php if( azin_opt( 'maintenance_social' ) ) { ?>
                    <div class="col-12 social-footer under-social">
                        <?php azin_social_links( 'social footer-social', true, true ); ?>                        
                    </div>
                <?php } ?>

            </div>
        </div>
    </div>

    <?php 
    
    do_action( 'azin_footer' );

    wp_footer(); ?>
</body>

</html>