<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}

global $product;
?>

<?php
//Show product head banner 
az_product_head_banner( get_the_ID() );
?>

<?php 
//Show prodcut Services
if ( azin_opt( 'show_services_prod' ) && !azin_opt( 'product_style_two' ) ) {
    az_show_services();
}
?>

<article class="row">
<?php
$product_square_thumb = azin_opt( 'square_thumb' ) ? ' product-square-thumb': '';
?>
    <div role="main" class="col-12 scon <?php echo $product_square_thumb; ?>" id="post-<?php the_ID(); ?>">

        <div class="s-product">

            <?php az_header_style_one_woo( get_the_ID() ) ?>

            <div class="row product-details">

                <?php
                    if ( azin_opt( 'product_style_two' ) ) {
                        $prodimg = 'col-12 product-style-two-pre';
                        $proddet = '';
                    } elseif ( azin_opt( 'square_thumb' ) && azin_opt( 'full_width_style' ) ) {
                        $prodimg = 'col-lg-4 col-md-6 col-12';
                        $proddet = 'col-lg-8 col-md-6 col-12 square-thumb';
                    } elseif ( azin_opt( 'square_thumb' ) ) {
                        $prodimg = 'col-lg-4 col-md-6 col-12';
                        $proddet = 'col-lg-8 col-md-6 col-12 square-thumb';
                    } else {
                        $prodimg = 'col-lg-7 col-md-8 col-12';
                        $proddet = 'col-lg-5 col-md-4 col-12';
                    }
                ?>

                <div class="<?php echo $prodimg; ?> prod-img si-img">
                    
                    <?php
                    az_product_badge( get_the_ID() );
                    az_product_preview( get_the_ID(), false );
                    ?>

                </div>

                <?php 
                if ( ! azin_opt( 'product_style_two' ) ) { ?>

                    <div class="<?php echo $proddet; ?> prod-det">
                    
                        <?php 

                        if ( azin_opt( 'replace_woo_attr' ) ) {
                            echo azin_get_product_attributes ( get_the_ID() , azin_opt( 'woo_attr_number' ) );
                        } else {
                            az_product_fields( get_the_ID() );
                        }

                        do_action( 'azin_after_product_fields' );

                        az_check_user_purchased( get_the_ID() );

                        azin_product_sale_timer( get_the_ID() );

                        az_product_price_woo( get_the_ID() );

                        az_add_product_woo( get_the_ID() );

                        do_action( 'azin_after_add_product' );
                        ?>

                     </div>
                    
                <?php } ?>
                

            </div>

        </div>
        
        <?php 
        //Show prodcut Services
        if ( azin_opt( 'show_services_prod' ) && azin_opt( 'product_style_two' ) )
            az_show_services();

        if ( azin_opt( 'show_related_top' ) )
            azin_show_related_product( get_the_ID() );

            do_action( 'azin_before_single_product_summary' );
        ?>
    <?php
        /**
         * Hook: woocommerce_before_single_product_summary.
         *
         * @hooked woocommerce_show_product_sale_flash - 10
         * @hooked woocommerce_show_product_images - 20
         */
        do_action( 'woocommerce_before_single_product_summary' );
    ?>

    <?php
        /**
         * Hook: woocommerce_after_single_product_summary.
         *
         * @hooked woocommerce_output_product_data_tabs - 10
         * @hooked woocommerce_upsell_display - 15
         * @hooked woocommerce_output_related_products - 20
         */
        do_action( 'woocommerce_after_single_product_summary' );

    ?>
    <?php do_action( 'woocommerce_after_single_product' ); ?>
</article>