<?php
/**
 * Content wrappers
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/wrapper-end.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


$template = wc_get_theme_slug_for_templates();

switch ( $template ) {
	case 'twentyten' :
		echo '</div></div>';
		break;
	case 'twentyeleven' :
		echo '</div>';
		get_sidebar( 'shop' );
		echo '</div>';
		break;
	case 'twentytwelve' :
		echo '</div></div>';
		break;
	case 'twentythirteen' :
		echo '</div></div>';
		break;
	case 'twentyfourteen' :
		echo '</div></div></div>';
		get_sidebar( 'content' );
		break;
	case 'twentyfifteen' :
		echo '</div></div>';
		break;
	case 'twentysixteen' :
		echo '</main></div>';
		break;
	default :
		echo '</div>'; ?>

		<?php
		if ( is_singular( 'product' ) && ! azin_opt( 'product_style_two' ) && azin_opt( 'remove_product_sidebar' ) ) {
			//Show nothing
		} elseif ( is_woocommerce() && is_product_taxonomy() && azin_opt( 'remove_product_archive_sidebar' ) ) {
			//Show nothing
		} else { ?>
			<aside class="col-lg-3 side-bar<?php echo az_show_side_mobile(); if ( azin_opt( 'sticky_side' ) ) { echo ' side-sticky'; }?>">
				<?php
					if ( azin_is_course( get_the_ID() ) && is_singular( 'product' ) && azin_opt( 'course_side' ) ) {
						if ( is_active_sidebar( 'product-course-sidebar' ) ) {
							dynamic_sidebar( 'product-course-sidebar' );
						}
					} elseif ( azin_opt( 'woo_side' ) && is_singular( 'product' ) ) {
						if ( is_active_sidebar( 'product-shop-sidebar' ) ) {
							dynamic_sidebar( 'product-shop-sidebar' );
						} 
					} else {
						if ( is_active_sidebar( 'shop-sidebar' ) ) {
							dynamic_sidebar( 'shop-sidebar' );
						}
					}
        		?>
			</aside>
		<?php } ?>

		</div>
		<?php 
			if ( is_singular( 'product' ) && azin_opt( 'product_style_two' ) ) {
				if ( ! azin_opt( 'show_related_top' ) )
					azin_show_related_product( get_the_ID() );

				azin_show_related_product_posts( get_the_ID() );
			}
		?>

	<?php
		azin_wrapper_end();
		break;
}
