<?php
/**
 * Content wrappers
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/wrapper-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$template = wc_get_theme_slug_for_templates();

azin_wrapper_start();

$product_page_class = is_singular( 'product' ) ? implode(" ", az_product_classes( get_the_ID() ) ) : '';

if ( is_woocommerce() && is_archive() ) {

	$ajax_prod =  ( azin_opt( 'ajax_prod' ) ? ' ajax-prod' : '');

	$ajax_prod_auto = ( azin_opt( 'ajax_prod' ) && azin_opt( 'ajax_prod_auto' )  ? ' ajax-prod-auto' : '');

	$ajax_prod_data = ( azin_opt( 'ajax_prod' ) && azin_opt( 'ajax_prod_auto' )  ? ' data-auto-ajax-load="100"' : ' data-auto-ajax-load="false"');

	$ajax_prod_history = ( azin_opt( 'ajax_prod' ) && azin_opt( 'ajax_prod_history' )  ? ' data-ajax-prod-history="push"' : ' data-ajax-prod-history="false"');

} else {

	$ajax_prod = '';

	$ajax_prod_auto = '';

	$ajax_prod_data = '';

	$ajax_prod_history = '';

}

$side_type = ( azin_opt( 'side_type' ) == 2  ? ' right-side' : '' );

$sticky_side = ( azin_opt( 'sticky_side' ) ? ' pcol' : '' );

$archive_class = ( is_woocommerce() && is_archive() && ! azin_opt( 'remove_product_archive_sidebar' ) ? 'col-lg-9 col-12 azin-archive-con ' : 'col-12 azin-archive-con ' );

?>
	<div class="row main<?php side_type(); echo $product_page_class; ?>" id="main" <?php if ( azin_opt( 'site_schema' ) ) { ?>itemscope itemtype="https://schema.org/Blog" <?php } ?>>

	<?php
	if ( is_singular( 'product' ) ) {
		$product_class  = ( ! azin_opt( 'product_style_two' ) && azin_opt( 'remove_product_sidebar' ) ) ? 'col-12' : 'col-lg-9 col-12';
		echo '<div class="'. $product_class . $side_type . $sticky_side .'" >';
	} else {
		echo '<div class="'. $archive_class . $ajax_prod . $ajax_prod_auto . $side_type . $sticky_side .'" '. $ajax_prod_data . $ajax_prod_history .'>';
		}
	?>

