<?php
/**
 * Order Downloads.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/order-downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

//$show_title = false;
?>

<?php if ( azin_opt( 'remove_myacc_hooks' ) || isset( $show_title ) ) { ?>
	<section class="woocommerce-order-downloads">
		<?php if ( isset( $show_title ) ) : ?>
			<h2 class="woocommerce-order-downloads__title"><?php esc_html_e( 'Downloads', 'woocommerce' ); ?></h2>
		<?php endif; ?>
		<table class="woocommerce-table woocommerce-table--order-downloads shop_table shop_table_responsive order_details">
			<thead>
				<tr>
					<?php foreach ( wc_get_account_downloads_columns() as $column_id => $column_name ) : ?>
					<th class="<?php echo esc_attr( $column_id ); ?>"><span class="nobr"><?php echo esc_html( $column_name ); ?></span></th>
					<?php endforeach; ?>
				</tr>
			</thead>

			<?php foreach ( $downloads as $download ) : ?>
				<tr>
					<?php foreach ( wc_get_account_downloads_columns() as $column_id => $column_name ) : ?>
						<td class="<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
							<?php
							if ( has_action( 'woocommerce_account_downloads_column_' . $column_id ) ) {
								do_action( 'woocommerce_account_downloads_column_' . $column_id, $download );
							} else {
								switch ( $column_id ) {
									case 'download-product':
										if ( $download['product_url'] ) {
											echo '<a href="' . esc_url( $download['product_url'] ) . '">' . esc_html( $download['product_name'] ) . '</a>';
										} else {
											echo esc_html( $download['product_name'] );
										}
										break;
									case 'download-file':
										echo '<a href="' . esc_url( $download['download_url'] ) . '" class="woocommerce-MyAccount-downloads-file button alt">' . esc_html( $download['download_name'] ) . '</a>';
										break;
									case 'download-remaining':
										echo is_numeric( $download['downloads_remaining'] ) ? esc_html( $download['downloads_remaining'] ) : esc_html__( '&infin;', 'woocommerce' );
										break;
									case 'download-expires':
										if ( ! empty( $download['access_expires'] ) ) {
											echo '<time datetime="' . esc_attr( date( 'Y-m-d', strtotime( $download['access_expires'] ) ) ) . '" title="' . esc_attr( strtotime( $download['access_expires'] ) ) . '">' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $download['access_expires'] ) ) ) . '</time>';
										} else {
											esc_html_e( 'Never', 'woocommerce' );
										}
										break;
								}
							}
							?>
						</td>
					<?php endforeach; ?>
				</tr>
			<?php endforeach; ?>
		</table>
	</section>
<?php } else { ?>
	<section class="woocommerce-order-downloads">
		<?php if ( isset( $show_title ) ) : ?>
			<h2 class="woocommerce-order-downloads__title"><?php esc_html_e( 'Downloads', 'azin-file' ); ?></h2>
		<?php endif; ?>

		<div id="accordion" class="azin-download-accordion">
			<?php $downloadNumber = 1; ?>
			<?php foreach ( $downloads as $download ) :
				$id = $download['product_id'];
				if ( azin_opt( 'course_user_panel' ) && rwmb_meta( 'file_training_course', '', $id ) == 1 ) {
					//Show Nothing
				} else {
			?>

				<div class="card">

					<div class="card-header" id="heading<?php echo $downloadNumber; ?>">
						<h5 class="mb-0">
							<button class="btn btn-link" data-toggle="collapse" data-target="#collapse<?php echo $downloadNumber; ?>" aria-expanded="true" aria-controls="collapse<?php echo $downloadNumber; ?>">
							<?php
							echo get_the_post_thumbnail( $download['product_id'], 'thumbnail' );

								//if ( $download['product_url'] ) {
									//echo '<a href="' . esc_url( $download['product_url'] ) . '">' . esc_html( $download['product_name'] ) . '</a>';
								//} else {
									echo esc_html( $download['product_name'] );
								//}
							?>
							</button>
						</h5>
					</div>

					<div id="collapse<?php echo $downloadNumber; ?>" class="collapse" aria-labelledby="heading<?php echo $downloadNumber; ?>" data-parent="#accordion">
						<div class="card-body azin-accordion-body">

							<?php 

							if ( azin_opt( 'show_downloads_fields' ) && ! empty ( azin_opt( 'downloads_fields' ) ) ) {
								
								$count = count ( azin_opt( 'downloads_fields' ) );
								$i = 0;
								foreach( azin_opt( 'downloads_fields' ) as $field ) {
									$title = '';
									$icon  = '';
									$value = '';
									if ( $i++ > $count ) break;
									switch ( $field ) {
										case 'field-one':
											$title = azin_opt( 'fone' );
											$icon = ( ! empty ( azin_opt( 'fone_icon' ) ) ? azin_opt( 'fone_icon' ) : 'fa-file-alt' );
											$value = rwmb_meta( 'file_fone', '', $id );
											break;
										case 'field-two':
											$title = azin_opt( 'ftwo' );
											$icon = ( ! empty ( azin_opt( 'ftwo_icon' ) ) ? azin_opt( 'ftwo_icon' ) : 'fa-save' );
											$value = rwmb_meta( 'file_ftwo', '', $id );
											break;
										case 'field-three':
											$title = azin_is_course( $id ) && ! azin_opt( 'edit_fthree' ) ? __( 'Teacher', 'azin-file' ) : azin_opt( 'fthree' );
											$icon = azin_opt( 'fthree_icon' );
											if ( azin_opt( 'edit_fthree' ) ) { 
												$value = rwmb_meta( 'file_fthree', '', $id );
											} else {
												$author_id = get_post_field( 'post_author', $id );
												$value = get_the_author_meta( 'display_name', $author_id );
											}
											break;
										case 'field-four':
											$title = azin_opt( 'ffour' );
											$icon = azin_opt( 'ffour_icon' );
											if ( azin_opt( 'edit_ffour' ) ) {
												$value = rwmb_meta( 'file_ffour', '', $id );
											} else {
												$value = get_the_date( 'j F Y' ); 
											}
											break;
										case 'field-five':
											$title = azin_opt( 'ffive' );
											$icon = ( ! empty ( azin_opt( 'ffive_icon' ) ) ? azin_opt( 'ffive_icon' ) : 'fa-folder-open' );
											if ( azin_opt( 'edit_ffive' ) ) {
												$value = rwmb_meta( 'file_ffive', '', $id );
											} else {
												$sep = ( is_rtl() ? '، ' : ', ' );
												$term_obj_list = get_the_terms( $id, 'product_cat' );
												$value = join( $sep, wp_list_pluck( $term_obj_list, 'name') );
											}
											break;
										case 'field-six':
											$title = azin_opt( 'fsix' );
											$icon = azin_opt( 'fsix_icon' );
											if ( azin_opt( 'edit_fsix' ) ) {
												$value = rwmb_meta( 'file_fsix', '', $id );
											} else {
												$value = getPostViews( $id );
											}
											break;
										case 'field-dcount':
											$title = azin_is_course( $id ) && ! azin_opt( 'edit_dcount' ) ? __( 'Number of students', 'azin-file' ) : azin_opt( 'dcount_title' );
											$icon  = azin_opt( 'dcount_icon' );
											if ( azin_opt( 'edit_dcount' ) ) {
												$value = rwmb_meta( 'file_dcount', '', $id );
											} else {
												$count = get_post_meta( $id, 'total_sales', true );
												$value = $count . __( ' Sales', 'azin-file' );
											}
											break;
										case 'field-modified':
											$title = azin_opt( 'modified_date_title' );
											$icon  = azin_opt( 'modified_date_icon' );
											if ( azin_opt( 'edit_modified_date' ) ) {
												$value = rwmb_meta( 'file_modified_date', '', $id );
											} else {
												$value = get_the_modified_time( 'j F Y', $id );
											}
											break;
										case 'field-sku':
											$title = azin_opt( 'product_sku_title' );
											$icon  = azin_opt( 'product_sku_icon' );
											if ( azin_opt( 'edit_product_sku' ) ) {
												$value = rwmb_meta( 'file_modified_date', '', $id );
											} else {
												$product = wc_get_product( $id );
												$value = $product->get_sku();
											}
											break;
									} 
									
									if ( ! empty ( $title ) && ! empty ( $value ) ) {
									?>
									<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-downloads-field-<?php echo $i ?>">
										<i class="fa <?php echo $icon ?>" aria-hidden="true"></i>
										<?php echo $title . ': ' . $value; ?>
									</div>
								<?php
									}
								}
							}
							?>

							<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-remaining-downloads">
								<i class="fa fa-tasks" aria-hidden="true"></i>
								<?php
									_e( 'Remaining downloads: ', 'azin-file' );
									echo is_numeric( $download['downloads_remaining'] ) ? esc_html( $download['downloads_remaining'] ) : esc_html__( '&infin;', 'azin-file' );
								?>
							</div>

							<div class="col-12 col-md-6 col-xl-4 azin-accordion-extra azin-access-expiration">
								<i class="fa fa-alarm-exclamation" aria-hidden="true"></i>
								<?php
									_e( 'Access Expiration: ', 'azin-file' );
									if ( ! empty( $download['access_expires'] ) ) {
										echo '<time datetime="' . esc_attr( date( 'Y-m-d', strtotime( $download['access_expires'] ) ) ) . '" title="' . esc_attr( strtotime( $download['access_expires'] ) ) . '">' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $download['access_expires'] ) ) ) . '</time>';
									} else {
										esc_html_e( 'Never', 'azin-file' );
									}
								?>
							</div>

							<?php
							$lists = $download['list'];

							if ( empty( $lists ) ) {
								_e( 'No Download Files', 'azin-file' );
								return;
							}
						
							echo '<ul class="azin-download-list col-12">';
						
							foreach ( $lists as $list ) {
								echo '<li>';
								echo '<a href="' . esc_url( $list['download_url'] ) . '" class="woocommerce-MyAccount-downloads-file">';
								echo esc_html( $list['file_name'] );
								echo '</a></li>';
							}
						
							echo '</ul>';
							//do_action( 'woocommerce_account_downloads_column_download-file', $download );
							?>


						</div>
					</div>

				</div>

				<?php $downloadNumber++;
				} ?>
			<?php endforeach;
			if ( $downloadNumber == 1 ) { ?>
				<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
					<a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
						<?php _e( 'Browse products', 'azin-file' ); ?>
					</a>
					<?php _e( 'You have not purchased any products.', 'azin-file' ); ?>
				</div>
			<?php
			} ?>
		</div>
	</section>
<?php } ?>

