<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

if ( $upsells && azin_opt( 'show_up_sells' ) ) : ?>

<div class="m-product<?php echo az_block_style(); ?>">
    <div class="post-title">
        <div>
            <i aria-hidden="true" class="fal fa-shopping-bag"></i>
            <?php echo azin_opt( 'up_sells_title' ); ?>
        </div>
    </div>
    <div class="owl-carousel" data-mobile-col="<?php echo az_mobile_col(); ?>" data-itemplay="false" data-itemscount="<?php echo azin_opt( 'related_pcol_count' ); ?>" data-dir="<?php azin_rtl(); ?>">
    <?php
    //woocommerce_product_loop_start();
    foreach ( $upsells as $upsell ) :
            $post_object = get_post( $upsell->get_id() );
            setup_postdata( $GLOBALS['post'] =& $post_object );
            global $product;
            $in_stock = $product->is_in_stock();
        azin_product_block_content( get_the_ID() );
    endforeach;
    //woocommerce_product_loop_end();
    ?>
    </div>
</div>

<?php
endif;

wp_reset_postdata();